/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelPeriodNavigation;
import bitel.billing.module.common.BGSelectFilePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.integration.common.bean.Register;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.common.service.IntegrationService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.Result;

public abstract class RegistryLoad
extends BGPanel {
    protected static final int PAYMENT = 0;
    protected static final int CHARGE = 1;
    private static final String NAME_DATE = "date";
    private static final String NAME_PATTERN_TITLE = "patternTitle";
    private static final String NAME_TITLE = "title";
    private static final String NAME_STATUS = "status";
    private static final String NAME_COUNT = "stringsCount";
    private static final String NAME_ERROR_COUNT = "errorCount";
    private static final String NAME_SUMMA = "summ";
    protected int type = 0;
    protected String tabName = "";
    private JTabbedPane reportAndViewPanel = new JTabbedPane();
    private BGControlPanelPeriodNavigation periodPanel = new BGControlPanelPeriodNavigation();
    private OpperationTableModel opperationTableModel = new OpperationTableModel(OpperationTableModel.class.getName());
    protected BGUTable registerItemsTable = new BGUTable((TableModel)((Object)this.opperationTableModel));
    private RegistersTableModel tableModel = new RegistersTableModel();
    private BGUTable registersTable = new BGUTable((TableModel)((Object)this.tableModel));
    private JTextArea loadReport_TA = new JTextArea();
    private BGSelectFilePanel selectFilePanel = new BGSelectFilePanel(false, true, false);
    private BGUComboBox<KeyValue> pattern_CB = new BGUComboBox();
    private BGTextField title_TF = new BGTextField();
    private BGControlPanelDateNoB datePanel = new BGControlPanelDateNoB();
    private IntegrationService integrationService = null;

    public RegistryLoad(int type, String tabName) {
        this.type = type;
        this.tabName = tabName;
        this.module = "integration";
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.registersTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Register row;
                if (e.getClickCount() == 2 && (row = (Register)RegistryLoad.this.tableModel.getSelectedRow()) != null) {
                    RegistryLoad.this.viewRegister(row.getId());
                }
            }
        });
        LocalDate now = LocalDate.now();
        this.periodPanel.setDateFrom(TimeUtils.convertLocalDateToDate((LocalDate)now));
        this.periodPanel.setDateTo(TimeUtils.convertLocalDateToDate((LocalDate)now));
        this.setData();
    }

    private void jbInit() throws Exception {
        this.loadReport_TA.setEditable(false);
        this.loadReport_TA.setBorder(new EmptyBorder(3, 5, 3, 5));
        this.reportAndViewPanel.setBorder((Border)new BGTitleBorder(" \u041b\u043e\u0433 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 / \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0440\u0435\u0435\u0441\u0442\u0440\u0430"));
        this.reportAndViewPanel.add("\u041b\u043e\u0433 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438", this.getPanel(this.loadReport_TA));
        this.reportAndViewPanel.add(this.tabName, new JScrollPane((Component)this.registerItemsTable));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getRegisterActionsPanel(), "North");
        panel.add((Component)this.reportAndViewPanel, "Center");
        BGSplitPane splitPane = new BGSplitPane(0, (Component)this.getRegistersPanel(), (Component)panel);
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getActionPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getRegistersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0435\u0441\u0442\u0440\u044b "));
        panel.add((Component)new JScrollPane((Component)this.registersTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPanel(JComponent component) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(component), new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getRegisterActionsPanel() {
        JButton loadButton = new JButton();
        loadButton.setText("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c");
        loadButton.addActionListener(e -> this.loadButton_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0440\u0435\u0435\u0441\u0442\u0440\u0430 "));
        panel.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.selectFilePanel, new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.datePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.pattern_CB, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.title_TF, new GridBagConstraints(9, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)loadButton, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        JButton filterButton = new JButton();
        filterButton.setText(">>");
        filterButton.addActionListener(e -> this.setData());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 0, 0), 0, 0));
        panel.add(Box.createHorizontalStrut(8), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)filterButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        BGSwingUtilites.wrapBorder((JPanel)panel, (String)" \u0424\u0438\u043b\u044c\u0442\u0440 ");
        return panel;
    }

    private JPanel getActionPanel() {
        JButton processButton = new JButton();
        processButton.setText("\u041f\u0440\u043e\u0432\u0435\u0441\u0442\u0438 \u0440\u0435\u0435\u0441\u0442\u0440");
        processButton.addActionListener(e -> this.processButton_actionPerformed(e));
        JButton rollBackButton = new JButton();
        rollBackButton.setText("\u041e\u0442\u043a\u0430\u0442\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440");
        rollBackButton.addActionListener(e -> this.rollBackButton_actionPerformed(e));
        JPanel actionPanel = new JPanel(new FlowLayout(1, 5, 0));
        actionPanel.setBorder((Border)new BGTitleBorder(" \u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u043c "));
        actionPanel.add(processButton);
        actionPanel.add(rollBackButton);
        return actionPanel;
    }

    public void setData() {
        if (!this.init) {
            return;
        }
        try {
            this.tableModel.setData(this.getIntegrationService().searchRegistersRowList(this.type, this.periodPanel.getPeriod()).getList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    protected IntegrationService getIntegrationService() {
        if (this.integrationService == null) {
            this.integrationService = (IntegrationService)this.getContext().getPort(IntegrationService.class, 0);
        }
        return this.integrationService;
    }

    protected void init() {
        this.init = true;
        try {
            this.pattern_CB.setData(this.getIntegrationService().getLoadPatternList(this.type));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    public void processButton_actionPerformed(ActionEvent e) {
        Register row = (Register)this.tableModel.getSelectedRow();
        if (row != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041f\u0440\u043e\u0432\u0435\u0441\u0442\u0438 \u0440\u0435\u0435\u0441\u0442\u0440?", "\u041f\u0440\u043e\u0432\u043e\u0434\u043a\u0430", 0) == 0) {
            try {
                this.getIntegrationService().processRegister(this.type, row.getId());
                ClientUtils.showMessageDialog((Object)"\u0420\u0435\u0435\u0441\u0442\u0440 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public void rollBackButton_actionPerformed(ActionEvent e) {
        Register row = (Register)this.tableModel.getSelectedRow();
        if (row != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u043a\u0430\u0442\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440?", "\u041e\u0442\u043a\u0430\u0442", 0) == 0) {
            try {
                this.getIntegrationService().rollbackRegister(this.type, row.getId());
                ClientUtils.showMessageDialog((Object)"\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d \u043e\u0442\u043a\u0430\u0442 \u0440\u0435\u0435\u0441\u0442\u0440\u0430");
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void viewRegister(int id) {
        try {
            Result<RegisterItem> result = this.getIntegrationService().registerItems(id);
            this.opperationTableModel.setData(result.getList());
            this.loadReport_TA.setText((String)result.getAttribute("load_log"));
            this.reportAndViewPanel.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0440\u0435\u0435\u0441\u0442\u0440\u0430 " + ex.toString()));
        }
    }

    public void loadButton_actionPerformed(ActionEvent e) {
        File files = this.selectFilePanel.getSelectedFile();
        if (files == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        KeyValue pattern = (KeyValue)this.pattern_CB.getSelectedItem();
        if (pattern == null || pattern.getKey().equals("0")) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438!");
            return;
        }
        String date = this.datePanel.getDateString();
        if (Utils.isEmptyString((String)date)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0440\u0435\u0435\u0441\u0442\u0440\u0430!");
            return;
        }
        String title = this.title_TF.getText();
        if (Utils.isBlankString((String)title)) {
            title = files.getName();
        }
        String encodedFile = null;
        try {
            encodedFile = Base64.encode((InputStream)new FileInputStream(files));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            int id = this.getIntegrationService().loadRegister(pattern.getKey().split(":")[0], this.type, encodedFile, this.datePanel.getDate(), title);
            this.setData();
            this.viewRegister(id);
        }
        catch (Exception e1) {
            this.setData();
            ClientUtils.showErrorMessageDialog((Throwable)e1);
        }
    }

    public void deleteItem() {
        List registersRows = this.tableModel.getSelectedRows();
        if (!registersRows.isEmpty() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0435\u0441\u0442\u0440(\u044b)?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                for (Register registersRow : registersRows) {
                    this.getIntegrationService().deleteRegister(this.type, registersRow.getId());
                }
                this.loadReport_TA.setText("");
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    public class OpperationTableModel
    extends BGTableModel<RegisterItem> {
        public OpperationTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("ID", 80, 80, 80, "balanceItemId", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 100, RegistryLoad.NAME_DATE, true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, -1, -1, "contract", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn(RegistryLoad.this.type == 0 ? "\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430" : "\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430", 200, 250, 400, "operationTypeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 150, 150, 150, "summa", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "balanceItemComment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u043f.\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", 250, 250, 400, "extraParametersMap", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RegisterItem val, int column) throws BGException {
            if (column == 6) {
                return val.extraParametersAsString();
            }
            return super.getValue((Object)val, column);
        }
    }

    class RegistersTableModel
    extends BGTableModel<Register> {
        public RegistersTableModel() {
            super(RegistersTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 100, RegistryLoad.NAME_DATE, true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u0418\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430", 100, -1, -1, RegistryLoad.NAME_PATTERN_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a", 200, -1, -1, RegistryLoad.NAME_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, RegistryLoad.NAME_STATUS, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 100, 100, 100, RegistryLoad.NAME_COUNT, true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041e\u0448\u0438\u0431\u043e\u043a", 100, 100, 100, RegistryLoad.NAME_ERROR_COUNT, true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 150, 150, 150, RegistryLoad.NAME_SUMMA, true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }
    }
}

