/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class TariffVarDao
extends AbstractIdDao<TariffVar> {
    public TariffVarDao(Connection con) {
        super(con, 0, "tariff_vars");
    }

    public List<TariffVar> list(TariffVarType tariffVarType, List<Integer> tariffIds) throws BGException {
        String where = "tariff_id IN (" + Utils.toString(tariffIds) + ")";
        if (tariffVarType != null) {
            return this.list(where + " AND `type`=?", "id", new Object[]{tariffVarType.getCode()});
        }
        return this.list(where, "id", new Object[0]);
    }

    public void update(TariffVar tariffVar) throws BGException {
        this.updateTariffVar(tariffVar);
    }

    public int updateTariffVar(TariffVar tariffVar) throws BGException {
        boolean update = tariffVar.getId() > 0;
        this.ormUpdateImpl((Object)tariffVar);
        if (update) {
            this.updateChildTariffVarTitle(tariffVar);
            this.updateTariffDefaultValue(tariffVar);
        } else {
            this.copyTariffVar(tariffVar);
        }
        return tariffVar.getId();
    }

    private void updateChildTariffVarTitle(TariffVar tariffVar) throws BGException {
        if (tariffVar.getUpId() == 0) {
            String queryUpdate = "UPDATE `tariff_vars` SET `title`=? WHERE `top_id`=?";
            try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
                psUpdate.setString(1, tariffVar.getTitle());
                psUpdate.setInt(2, tariffVar.getId());
                psUpdate.executeUpdate();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    private void copyTariffVar(TariffVar tariffVar) throws BGException {
        ArrayList<TariffVar> tariffVars = new ArrayList<TariffVar>();
        boolean moduleTariffVar = tariffVar.getModuleId() > 0;
        String querySelect = "SELECT " + (moduleTariffVar ? "tp2.id" : "DISTINCT(tp2.id)") + " AS tariff_plan_id FROM tariff_plan tp LEFT JOIN module_tariff_tree mtt ON tp.tree_id=mtt.parent_tree LEFT JOIN tariff_plan tp2 ON tp2.tree_id=mtt.tree_id WHERE tp.id=?" + (moduleTariffVar ? " AND mtt.mid=?" : "");
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);){
            psSelect.setInt(1, tariffVar.getTariffPlanId());
            if (moduleTariffVar) {
                psSelect.setInt(2, tariffVar.getModuleId());
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    int tariffPlanId = rs.getInt(1);
                    if (tariffPlanId == 0) continue;
                    TariffVar copyTariffVar = tariffVar.copyTariffVar();
                    copyTariffVar.setId(0);
                    copyTariffVar.setUpId(tariffVar.getId());
                    copyTariffVar.setTopId(tariffVar.getTopId() > 0 ? tariffVar.getTopId() : tariffVar.getId());
                    copyTariffVar.setTariffPlanId(tariffPlanId);
                    copyTariffVar.setDefaultValue("");
                    copyTariffVar.setParentDefaultValue(tariffVar.getDefaultValue());
                    this.ormUpdateImpl((Object)copyTariffVar);
                    tariffVars.add(copyTariffVar);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        for (TariffVar childTariffVar : tariffVars) {
            this.copyTariffVar(childTariffVar);
        }
    }

    private void updateTariffDefaultValue(TariffVar tariffVar) throws BGException {
        ArrayList<TariffVar> tariffVars = new ArrayList<TariffVar>();
        String querySelect = "SELECT * FROM `tariff_vars` WHERE `up_id`=?";
        String queryUpdate = "UPDATE `tariff_vars` SET `parent_default_value`=? WHERE id=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            psSelect.setInt(1, tariffVar.getId());
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    TariffVar childTariffVar = this.getFromRS(rs);
                    childTariffVar.setParentDefaultValue(tariffVar.getDefaultValue().isEmpty() ? tariffVar.getParentDefaultValue() : tariffVar.getDefaultValue());
                    psUpdate.setString(1, childTariffVar.getParentDefaultValue());
                    psUpdate.setInt(2, childTariffVar.getId());
                    psUpdate.executeUpdate();
                    if (!childTariffVar.getDefaultValue().isEmpty()) continue;
                    tariffVars.add(childTariffVar);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        for (TariffVar childTariffVar : tariffVars) {
            this.updateTariffDefaultValue(childTariffVar);
        }
    }

    protected TariffVar getFromRS(ResultSet rs) throws SQLException, BGException {
        return (TariffVar)((Object)this.ormFromResultSet(rs, TariffVar.class));
    }

    protected void updateImpl(TariffVar tariffVar) throws BGException, SQLException {
        this.ormUpdateImpl((Object)tariffVar);
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        return this.delete("(id=? AND top_id=0) OR top_id=?", new Object[]{id, id});
    }
}

