/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.util;

import bitel.billing.common.cache.CacheManagerClient;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.common.ErrorDialog;
import ru.bitel.bgbilling.client.common.table.tree.DefaultTreeTableModel;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.runner.BGClientRunnerUtil;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.ListItem;

public class ClientUtils {
    private static Map<String, ImageIcon> icons = new HashMap<String, ImageIcon>();
    public static final ImageIcon nullIcon = new ImageIcon();

    public static boolean confirm(String message, String title) {
        return 0 == JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, title, 0);
    }

    public static boolean confirmDelete(Object what) {
        return ClientUtils.confirmDelete(what, true);
    }

    public static boolean confirmDelete(Object what, boolean useQuotes) {
        String string;
        if (what instanceof IdTitle) {
            IdTitle a = (IdTitle)what;
            string = a.getTitle();
        } else {
            string = String.valueOf(what);
        }
        String txt = string;
        Object msg = useQuotes ? "\"" + txt + "\"" : txt;
        return ClientUtils.confirm("\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (String)msg + "?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435");
    }

    public static void showDialog(Object message, String title, int messageType) {
        JButton button = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        JOptionPane optionPane = new JOptionPane(message, messageType, -1);
        optionPane.setOptions(new JButton[]{button});
        JDialog dialog = optionPane.createDialog(JOptionPane.getRootFrame(), title);
        button.addActionListener(e -> dialog.setVisible(false));
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showScrollMessageDialog(String message, String title) {
        JTextArea text = new JTextArea(20, 50);
        text.setEditable(false);
        text.setText(message);
        text.setMargin(new Insets(3, 3, 3, 3));
        ClientUtils.showDialog(new JScrollPane(text), title, 1);
    }

    public static void showMessageDialog(Object message, String title) {
        ClientUtils.showDialog(message, title, 1);
    }

    public static void showMessageDialog(Object message) {
        ClientUtils.showMessageDialog(message, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
    }

    public static void warning(String message, String title) {
        ClientUtils.showDialog(message, title, 2);
    }

    public static void showErrorMessageDialog(String message, String title) {
        Object object = message;
        if (message != null && message.length() > 100) {
            BGTextArea textArea = new BGTextArea(10, 50);
            textArea.setText(message);
            object = new JScrollPane(textArea);
        }
        ClientUtils.showDialog(object, title, 0);
    }

    public static void showErrorMessageDialog(String message) {
        ClientUtils.showErrorMessageDialog(message, "\u041e\u0448\u0438\u0431\u043a\u0430");
    }

    public static void showErrorMessageDialog(final Throwable e) {
        String message = null;
        if (e instanceof SOAPFaultException) {
            Throwable throwable = e.getCause();
            if (throwable != null && Utils.isEmptyString(message = throwable.getLocalizedMessage())) {
                message = throwable.getMessage();
            }
            if (Utils.isEmptyString(message) && Utils.isEmptyString(message = e.toString())) {
                message = e.getCause().getClass().getName();
            }
        } else if (e instanceof BGMessageException) {
            ClientUtils.showErrorMessageDialog(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage());
        } else {
            message = e.getLocalizedMessage();
            if (Utils.isEmptyString(message)) {
                message = e.getMessage();
            }
            if (Utils.isEmptyString(message)) {
                message = e.getClass().getName();
            }
        }
        if (message != null) {
            if (message.startsWith("#@!")) {
                ClientUtils.showErrorMessageDialog(message.substring(3));
                return;
            }
            final String message0 = message;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (e instanceof BGMessageException || e.getCause() != null && e.getCause().toString().contains("BGMessageException") || e.getCause() != null && e.getCause().toString().contains("BGIllegalAccessException")) {
                        if (message0.trim().equalsIgnoreCase("ok")) {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u0441\u043f\u0435\u0448\u043d\u043e", "Ok", 1);
                            return;
                        }
                        StringBuilder buf = new StringBuilder(message0);
                        if (buf.length() > 100) {
                            for (int pos = 100; pos < buf.length(); pos += 100) {
                                int index = buf.lastIndexOf(" ", pos);
                                if (index > 1 && index > pos - 99 && pos < 100000) {
                                    buf.insert(index, '\n');
                                    pos = index;
                                    if (pos + 100 <= buf.length()) continue;
                                    int l = (int)((double)(100 - (buf.length() - pos)) / 1.4);
                                    for (int i = 0; i < l; ++i) {
                                        buf.insert(index + 1, " ");
                                    }
                                    continue;
                                }
                                buf.insert(pos, '\n');
                            }
                        }
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), buf.toString(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    } else {
                        new ErrorDialog(BGException.printStackTraceToString(e), message0).showDialog();
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static boolean checkStatus(Document doc) {
        boolean result = false;
        if (doc == null) {
            result = false;
        } else {
            String status;
            Element data = doc.getDocumentElement();
            if (!"data".equals(data.getNodeName())) {
                data = XMLUtils.selectElement(doc, "/data");
            }
            if ((status = data.getAttribute("status")).equals("error") && data.hasChildNodes()) {
                ClientUtils.showErrorMessageDialog(Utils.getMessage(doc));
            } else if (status.equals("message") && data.hasChildNodes()) {
                JTextArea message = new JTextArea(7, 50);
                message.setMargin(new Insets(5, 5, 5, 5));
                message.setText(Utils.getMessage(doc));
                ClientUtils.showMessageDialog(new JScrollPane(message));
                result = true;
            } else {
                result = true;
            }
        }
        return result;
    }

    public static boolean getStatus(Component component, Document doc) {
        if (doc == null) {
            return false;
        }
        Element data = XMLUtils.selectElement(doc, "/data");
        String status = XMLUtils.getAttribute(data, "status", "ok");
        return !status.equals("error") || !data.hasChildNodes();
    }

    public static ImageIcon getIcon(String name) {
        return ClientUtils.getIcon("img", name, true);
    }

    public static ImageIcon getIconByPath(String path, boolean nonNull) {
        ImageIcon result = icons.get(path);
        if (result == null) {
            URL url;
            if (path.endsWith(".png") || path.endsWith(".gif")) {
                url = ClientUtils.class.getResource(path);
            } else {
                url = ClientUtils.class.getResource(path + ".png");
                if (url == null) {
                    url = ClientUtils.class.getResource(path + ".gif");
                }
            }
            result = url == null ? (nonNull ? nullIcon : null) : new ImageIcon(url);
            icons.put(path, result);
        }
        return result;
    }

    public static ImageIcon getIcon(String packageicon, String name, boolean nonNull) {
        Object path = packageicon == null ? "" : "/" + packageicon.replace('.', '/') + "/";
        return ClientUtils.getIconByPath((String)path + name, nonNull);
    }

    public static String getRBName(Object obj) {
        return obj.getClass().getPackage().getName() + ".setup";
    }

    public static String getRBName(Class<?> clazz) {
        return clazz.getPackage().getName() + ".setup";
    }

    public static String getRowId(BGTable table) {
        return ClientUtils.getRowId(table, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!", "id");
    }

    public static String getRowId(BGTable table, String msg, String col) {
        String id = null;
        int selectRowIndex = table.getSelectedRow();
        if (selectRowIndex == -1) {
            if (msg != null) {
                ClientUtils.showErrorMessageDialog(msg);
            }
        } else {
            if (table.getRowSorter() != null) {
                selectRowIndex = table.getRowSorter().convertRowIndexToModel(selectRowIndex);
            }
            if (col == null) {
                col = "id";
            }
            id = table.getRowId(selectRowIndex, col);
        }
        return id;
    }

    public static void buildList(JList<BGUListItem> jList, Node node) {
        ClientUtils.buildList(jList, new DefaultListModel<BGUListItem>(), node, null);
    }

    public static void buildList(BGControlPanelListSelect list, Node node) {
        ClientUtils.buildList(list.getList(), list.getListModel(), node, null);
    }

    public static void buildList(JList<BGUListItem> jList, DefaultListModel<BGUListItem> model, Node node) {
        ClientUtils.buildList(jList, model, node, null);
    }

    public static void buildList(BGUList<BGUListItem> list, Iterable<Element> iterable) {
        ArrayList<BGUListItem> data = new ArrayList<BGUListItem>();
        for (Element itemElement : iterable) {
            BGUListItem listItem = new BGUListItem(itemElement.getAttribute("id"), itemElement.getAttribute("title"));
            listItem.setSelected(Utils.parseBoolean(XMLUtils.getAttribute(itemElement, "selected", "false")));
            data.add(listItem);
        }
        list.setData(data);
    }

    public static void buildList(BGControlPanelListSelect list, Node node, String defaultValue) {
        ClientUtils.buildList(list.getList(), list.getListModel(), node, defaultValue);
    }

    public static void buildList(JList<BGUListItem> jList, Node node, String defaultValue) {
        ClientUtils.buildList(jList, new DefaultListModel<BGUListItem>(), node, defaultValue);
    }

    public static void buildList(JList<BGUListItem> jList, DefaultListModel<BGUListItem> model, Node node, String defaultValue) {
        ArrayList<String> defaultValueList = new ArrayList<String>();
        if (defaultValue == null) {
            defaultValue = "";
        }
        Arrays.stream(defaultValue.split(",")).forEach(e -> defaultValueList.add((String)e));
        ClientUtils.buildMultiList(jList, model, node, defaultValueList);
    }

    public static void buildMultiList(JList<BGUListItem> jList, DefaultListModel<BGUListItem> model, Node node, List<String> defaultValues) {
        if (jList == null) {
            return;
        }
        model.clear();
        ArrayList<Integer> defaultItems = new ArrayList<Integer>();
        if (node != null && node.hasChildNodes()) {
            int index = 0;
            for (Element item : XMLUtils.elements(node.getChildNodes())) {
                String itemName = XMLUtils.getAttribute(item, "title", null);
                String itemSelected = XMLUtils.getAttribute(item, "selected", null);
                BGUListItem listItem = new BGUListItem();
                listItem.setTitle(itemName);
                listItem.setSelected(itemSelected != null);
                NamedNodeMap map = item.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    Node attr = map.item(j);
                    listItem.setAttribute(attr.getNodeName(), attr.getNodeValue());
                    if (!"id".equals(attr.getNodeName())) continue;
                    listItem.setId(Utils.parseInt(attr.getNodeValue()));
                }
                model.addElement(listItem);
                String itemId = (String)listItem.getAttribute("id");
                if (defaultValues == null || itemId == null) continue;
                for (String value : defaultValues) {
                    if (!value.equals(itemId)) continue;
                    listItem.setSelected(true);
                    defaultItems.add(index);
                }
                ++index;
            }
        }
        if (model != jList.getModel()) {
            jList.setModel(model);
        }
        jList.updateUI();
        for (Integer item : defaultItems) {
            jList.getSelectionModel().addSelectionInterval(item, item);
        }
    }

    public static List<String> buildList(Node node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node != null && node.hasChildNodes()) {
            for (Element item : XMLUtils.elements(node.getChildNodes())) {
                result.add(XMLUtils.getAttribute(item, "title", null));
            }
        }
        return result;
    }

    public static void buildList(JList<BGUListItem> jList, List<? extends ListItem> list) {
        if (jList == null) {
            return;
        }
        DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
        for (ListItem listItem : list) {
            model.addElement(new BGUListItem(listItem.getId(), listItem.getTitle()));
        }
        jList.setModel(model);
    }

    public static void setListSelection(JList<BGUListItem> list, String selected_id) {
        ClientUtils.setListSelection(list, Utils.toIntegerList(selected_id));
    }

    public static void setListSelection(JList<BGUListItem> list, List<Integer> selectedIds) {
        if (list != null) {
            ListModel<BGUListItem> model = list.getModel();
            int size = model.getSize();
            for (int index = 0; index < size; ++index) {
                BGUListItem listItem = model.getElementAt(index);
                listItem.setSelected(false);
            }
            list.removeSelectionInterval(0, size);
            if (selectedIds != null) {
                block1: for (Integer selectedId : selectedIds) {
                    for (int index = 0; index < size; ++index) {
                        BGUListItem listItem = model.getElementAt(index);
                        if (listItem.getId() != selectedId.intValue()) continue;
                        list.addSelectionInterval(index, index);
                        listItem.setSelected(true);
                        continue block1;
                    }
                }
            }
        }
    }

    public static void setListSelection(JList<? extends IdTitle> list, int selectedId) {
        if (list != null) {
            ListModel<? extends IdTitle> model = list.getModel();
            int size = model.getSize();
            for (int index = 0; index < size; ++index) {
                IdTitle idTitle = model.getElementAt(index);
                if (idTitle.getId() != selectedId) continue;
                list.setSelectedIndex(index);
                break;
            }
        }
    }

    public static DefaultComboBoxModel<ComboBoxItem> buildComboBox(Node node, String selected, String idName, String titleName) {
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        if (node == null || !node.hasChildNodes()) {
            return model;
        }
        for (Element item : XMLUtils.elements(node.getChildNodes())) {
            String item_id = XMLUtils.getAttribute(item, idName, null);
            String item_title = XMLUtils.getAttribute(item, titleName, null);
            if (item_id == null && item_title == null) continue;
            ComboBoxItem comboBoxItem = new ComboBoxItem(item_id, item_title);
            model.addElement(comboBoxItem);
            if (selected == null || !selected.equals(item_id)) continue;
            model.setSelectedItem(comboBoxItem);
        }
        return model;
    }

    public static DefaultComboBoxModel<ComboBoxItem> buildComboBox(JSONArray array, int selected, String idName, String titleName) {
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        if (array == null || array.isEmpty()) {
            return model;
        }
        for (int index = 0; index < array.length(); ++index) {
            JSONObject item = array.getJSONObject(index);
            int itemId = item.optInt(idName, -1);
            String itemTitle = item.optString(titleName, null);
            if (itemId < 0 && itemTitle == null) continue;
            ComboBoxItem comboBoxItem = new ComboBoxItem(itemId, itemTitle);
            model.addElement(comboBoxItem);
            if (selected != itemId) continue;
            model.setSelectedItem(comboBoxItem);
        }
        return model;
    }

    public static DefaultComboBoxModel<ComboBoxItem> buildComboBox(Node node, String selected) {
        return ClientUtils.buildComboBox(node, selected, "id", "title");
    }

    public static DefaultComboBoxModel<ComboBoxItem> buildComboBox(JSONArray array, int selected) {
        return ClientUtils.buildComboBox(array, selected, "id", "title");
    }

    public static DefaultComboBoxModel<ComboBoxItem> buildComboBoxWithDefault(Node node, String selected) {
        return ClientUtils.buildComboBoxWithDefault(node, selected, "----------");
    }

    public static DefaultComboBoxModel<ComboBoxItem> buildComboBoxWithDefault(Node node, String selected, String defaultName) {
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        if (node == null || !node.hasChildNodes()) {
            return model;
        }
        model.addElement(new ComboBoxItem(-1, defaultName));
        for (Element item : XMLUtils.elements(node.getChildNodes())) {
            String item_id = XMLUtils.getAttribute(item, "id", null);
            String item_title = XMLUtils.getAttribute(item, "title", null);
            if (item_id == null && item_title == null) continue;
            ComboBoxItem comboBoxItem = new ComboBoxItem(item_id, item_title);
            model.addElement(comboBoxItem);
            if (selected == null || !selected.equals(item_id)) continue;
            model.setSelectedItem(comboBoxItem);
        }
        return model;
    }

    public static void buildComboBox(JComboBox<ComboBoxItem> comboBox, Node node, String selected) {
        comboBox.setModel(ClientUtils.buildComboBox(node, selected));
    }

    public static void buildComboBox(JComboBox<ComboBoxItem> comboBox, Node node, String selected, String idName, String titleName) {
        comboBox.setModel(ClientUtils.buildComboBox(node, selected, idName, titleName));
    }

    public static boolean setComboBoxSelection(JComboBox<ComboBoxItem> combo, int selectedId) {
        return ClientUtils.setComboBoxSelection(combo, String.valueOf(selectedId));
    }

    public static boolean setComboBoxSelection(JComboBox<ComboBoxItem> combo, Object selectedId) {
        boolean result = false;
        DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ComboBoxItem comboBoxItem;
            if (BGComboBox.SEPARATOR.equals(model.getElementAt(i)) || (comboBoxItem = (ComboBoxItem)model.getElementAt(i)).getObject() == null || !comboBoxItem.getObject().equals(selectedId)) continue;
            combo.setSelectedIndex(i);
            result = true;
            break;
        }
        return result;
    }

    public static void setComboBoxSelection(BGUComboBox<? extends IdTitle> comboBox, int selectedObj) {
        if (comboBox == null || comboBox.getModel() == null) {
            return;
        }
        for (int i = 0; i < comboBox.getModel().getSize(); ++i) {
            if (((IdTitle)comboBox.getModel().getElementAt(i)).getId() != selectedObj) continue;
            comboBox.setSelectedIndex(i);
        }
    }

    public static String getIdFromComboBox(JComboBox<ComboBoxItem> combo) {
        String result = null;
        ComboBoxItem cbi = (ComboBoxItem)combo.getSelectedItem();
        if (cbi != null) {
            result = (String)cbi.getObject();
        }
        return result;
    }

    public static String getRowIdList(BGTable table, String col, String msg) {
        int[] rows = table.getSelectedRows();
        StringBuffer idList = new StringBuffer(30);
        for (int i = 0; i < rows.length; ++i) {
            if (idList.length() != 0) {
                idList.append(",");
            }
            idList.append(table.getRowId(rows[i], col));
        }
        if (idList.length() == 0 && msg != null) {
            ClientUtils.showErrorMessageDialog(msg);
        }
        return idList.toString();
    }

    public static String linesToString(Element node) {
        StringBuilder result = new StringBuilder();
        if (node != null) {
            NodeList nl = node.getElementsByTagName("row");
            int size = nl.getLength();
            Element row = null;
            for (int i = 0; i < size; ++i) {
                row = (Element)nl.item(i);
                result.append(row.getAttribute("text"));
                result.append("\n");
            }
        }
        return result.toString();
    }

    public static final void saveHtmlFile(String text, File file) throws Exception {
        text = text.replaceAll("[Cc][Hh][Aa][Rr][Ss][Ee][Tt]=[\\-\\w]+", "charset=utf-8");
        ClientUtils.saveBinaryFile(text.getBytes("utf-8"), file, ".html");
    }

    public static final void saveTextFile(String text, File file, String ext) throws IOException {
        ClientUtils.saveBinaryFile(text.getBytes("UTF-8"), file, ext);
    }

    public static void saveBinaryFile(byte[] bytes, File file, String ext) throws IOException {
        Object path = file.getAbsolutePath();
        if (!((String)path).endsWith(ext) && !((String)path).endsWith(ext.toUpperCase())) {
            path = (String)path + ext;
        }
        FileOutputStream fos = new FileOutputStream((String)path);
        fos.write(bytes);
        fos.flush();
        fos.close();
    }

    public static void saveBinaryFile(InputStream is, File file, String ext) throws IOException {
        Object path = file.getAbsolutePath();
        if (!((String)path).endsWith(ext) && !((String)path).endsWith(ext.toUpperCase())) {
            path = (String)path + ext;
        }
        FileOutputStream fos = new FileOutputStream((String)path);
        Utils.flush(is, fos);
        fos.flush();
        fos.close();
    }

    public static Document getCacheDocument(Document doc, String key) {
        return CacheManagerClient.getCacheManager().getDocument(doc, key);
    }

    public static void expandTree(JTree tree, DefaultMutableTreeNode start) {
        Enumeration<TreeNode> children = start.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)children.nextElement();
            if (dtm.isLeaf()) continue;
            TreePath tp = new TreePath(dtm.getPath());
            tree.expandPath(tp);
            ClientUtils.expandTree(tree, dtm);
        }
    }

    public static List<String> getExpandedTreeNodeList(JTree tree, String pathdelim) {
        ArrayList<String> r = new ArrayList<String>();
        for (int row = 0; row < tree.getRowCount(); ++row) {
            TreePath path = tree.getPathForRow(row);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            if (node.isLeaf() || tree.isCollapsed(row)) continue;
            r.add(Utils.toString(Arrays.asList(path.getPath()), pathdelim));
        }
        return r;
    }

    public static void setExpandedTreeNodeList(JTree tree, List<String> expandedNodes, String pathdelim) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        for (String n : expandedNodes) {
            List<String> pathcomponents = Utils.toList(n, pathdelim);
            ArrayList<Object> comps = new ArrayList<Object>();
            ClientUtils.getPathComponents((ArrayList)pathcomponents, comps, root);
            TreePath tp = new TreePath(comps.toArray());
            tree.expandPath(tp);
        }
    }

    private static void getPathComponents(ArrayList<String> pathcomponents, List<Object> comps, TreeNode curnode) {
        String currnodename;
        if (pathcomponents.size() > 0 && (currnodename = pathcomponents.remove(0)).toString().equals(curnode.toString())) {
            comps.add(curnode);
            for (int i = 0; i < curnode.getChildCount(); ++i) {
                TreeNode child = curnode.getChildAt(i);
                if (child.isLeaf()) continue;
                ClientUtils.getPathComponents((ArrayList)pathcomponents.clone(), comps, child);
            }
        }
    }

    public static final void addShowCodeListener(final BGTable table) {
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String id;
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (id = ClientUtils.getRowId(table)) != null) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u0434 = " + id, "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", 1);
                }
            }
        });
    }

    public static void openBrowser(URI uri) throws BGException {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return;
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f: " + e.getMessage());
            }
        }
        try {
            String url = uri.toURL().toString();
            String os = System.getProperty("os.name").toLowerCase();
            Runtime rt = Runtime.getRuntime();
            if (os.indexOf("win") >= 0) {
                rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else if (os.indexOf("mac") >= 0) {
                rt.exec("open " + url);
            } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                String[] browsers = new String[]{"chrome", "/opt/google/chrome/chrome", "firefox", "epiphany", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < browsers.length; ++i) {
                    cmd.append((i == 0 ? "" : " || ") + browsers[i] + " \"" + url + "\" ");
                }
                rt.exec(new String[]{"sh", "-c", cmd.toString()});
            }
        }
        catch (Exception e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f: " + e.getMessage(), e);
        }
    }

    public static void exec(String command) throws BGException {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new BGException(e);
        }
    }

    public static void openTelnet(String host, int port) throws BGException {
        String telnet = host + " " + port;
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            try {
                Runtime.getRuntime().exec("cmd /c start cmd.exe /k \"telnet " + telnet + "\"");
                return;
            }
            catch (IOException iOException) {}
        } else if (os.indexOf("mac") >= 0) {
            try {
                String url = "telnet://" + host + ":" + port;
                Runtime.getRuntime().exec("open " + url);
                return;
            }
            catch (IOException iOException) {}
        } else {
            try {
                Runtime.getRuntime().exec("konsole -e telnet " + telnet);
                return;
            }
            catch (IOException iOException) {
                try {
                    Runtime.getRuntime().exec(new String[]{"gnome-terminal", "-e", "telnet " + telnet});
                    return;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        try {
            Runtime.getRuntime().exec(new String[]{"xterm", "-e", "telnet " + telnet});
            return;
        }
        catch (IOException iOException) {
            throw new BGException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
    }

    public static void openTerminal(String cmd) throws BGException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            try {
                Runtime.getRuntime().exec("cmd /c start cmd.exe /k \"" + cmd + "\"");
                return;
            }
            catch (IOException iOException) {}
        } else {
            try {
                Runtime.getRuntime().exec("konsole -e " + cmd);
                return;
            }
            catch (IOException iOException) {
                try {
                    Runtime.getRuntime().exec(new String[]{"gnome-terminal", "-e", cmd});
                    return;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        try {
            Runtime.getRuntime().exec(new String[]{"xterm", "-e", cmd});
            return;
        }
        catch (IOException iOException) {
            throw new BGException("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
    }

    public static void openFile(File file) throws BGException {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(file);
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f: " + e.getMessage());
            }
        } else {
            throw new BGMessageException("\u0444\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        }
    }

    public static String getIdFromTable(BGTable table, int column) {
        String result = null;
        int pos = table.getSelectedRow();
        if (pos >= 0) {
            String id;
            result = id = (String)table.getValueAt(pos, column);
        }
        return result;
    }

    public static String getIdFromList(JList<BGUListItem> list) {
        String result = null;
        BGUListItem li = list.getSelectedValue();
        if (li != null) {
            result = li.getIdStr();
        }
        return result;
    }

    public static void removeFromComboBox(JComboBox<ComboBoxItem> comboBox, String value) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ComboBoxItem item = comboBox.getItemAt(i);
            if (!item.getObject().equals(value)) continue;
            comboBox.removeItemAt(i);
            break;
        }
    }

    public static final void addShowCodeListener(final JList<?> list) {
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73) {
                    Object item = list.getSelectedValue();
                    if (item == null) {
                        return;
                    }
                    if (item instanceof ListItem) {
                        ListItem li = (ListItem)item;
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u0434 = " + li.getId(), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", 1);
                    } else if (item instanceof IdTitle) {
                        IdTitle li = (IdTitle)item;
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u0434 = " + li.getId(), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", 1);
                    }
                }
            }
        });
    }

    public static void checkValues(JTextField tf, int minValue, int maxValue) {
        int[] values = new int[maxValue + 1];
        int i = 0;
        StringBuffer sb = new StringBuffer(tf.getText().trim());
        while (i < sb.length()) {
            char ch = sb.charAt(i);
            if (ch == '*' || ch == '-' || ch == ',' || ch == '/' || ch >= '0' && ch <= '9') {
                ++i;
                continue;
            }
            sb.deleteCharAt(i);
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("*/")) {
                try {
                    int s = Integer.parseInt(token.substring(2));
                    for (i = minValue; i <= maxValue; i += s) {
                        values[i] = 1;
                    }
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
            }
            i = token.indexOf("-");
            if (i != -1) {
                try {
                    int v1 = Integer.parseInt(token.substring(0, i));
                    int v2 = Integer.parseInt(token.substring(i + 1));
                    if (v1 < minValue || v1 > maxValue || v2 < minValue || v2 > maxValue) continue;
                    for (i = v1; i <= v2; ++i) {
                        values[i] = 1;
                    }
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
            }
            try {
                int v = Integer.parseInt(token);
                if (v < minValue || v > maxValue) continue;
                values[v] = 1;
            }
            catch (Exception e) {}
        }
        sb.delete(0, sb.length());
        int len = 0;
        for (i = minValue; i <= maxValue; ++i) {
            boolean b;
            boolean bl = b = values[i] > 0;
            if (b && len == 0) {
                sb.append(sb.length() == 0 ? "" + i : "," + i);
                ++len;
                continue;
            }
            if (b && len > 0) {
                ++len;
                continue;
            }
            if (!b && len > 1) {
                sb.append("-" + (i - 1));
                len = 0;
                continue;
            }
            len = 0;
        }
        if (len > 1) {
            sb.append("-" + maxValue);
        }
        tf.setText(sb.toString());
    }

    public static String getListSelectedItemtoString(JList<BGUListItem> list) {
        StringBuilder result = new StringBuilder();
        ListModel<BGUListItem> listModel = list.getModel();
        for (int index = 0; index < listModel.getSize(); ++index) {
            BGUListItem listItem = listModel.getElementAt(index);
            if (!listItem.isSelected()) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(listItem.getIdStr());
        }
        return result.toString();
    }

    public static final void addOnlyOneShownListener(final Component ... comp) {
        ComponentAdapter listener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Component showedComponent = e.getComponent();
                for (Component c : comp) {
                    c.setVisible(c == showedComponent);
                }
            }
        };
        for (Component c : comp) {
            c.addComponentListener(listener);
        }
    }

    public static final void addShowCodeListener(JTreeTable dataTree, final DefaultTreeTableModel<?> model) {
        dataTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object node;
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (node = model.getSelectedNode()) != null) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u0434 = " + ((ru.bitel.bgbilling.client.common.table.tree.TreeNode)node).id, "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", 1);
                }
            }
        });
    }

    public static final void addOpenAction(Component comp, final AWTEventListener eventListener) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getButton() & 1) != 0 && e.getClickCount() == 2) {
                    eventListener.eventDispatched(e);
                }
            }
        });
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    eventListener.eventDispatched(e);
                }
            }
        });
    }

    public static void addEnterDoClickDelegate(Component comp, final AbstractButton button) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    button.doClick();
                }
            }
        });
    }

    public static Document getModuleDoc(Class<?> clazz) {
        InputStream inputStream = clazz.getResourceAsStream("module.xml");
        return XMLUtils.parseDocument(inputStream != null ? new InputSource(inputStream) : null);
    }

    public static Document getModuleDoc(String rb_name) {
        InputStream inputStream;
        int pos;
        int n = pos = rb_name != null ? rb_name.lastIndexOf(".") : -1;
        if (Utils.isEmptyString(rb_name) || pos < 0) {
            return null;
        }
        Document document = (Document)ClientSetup.getInstance().getObject(rb_name);
        String classPath = rb_name.substring(0, pos).replaceAll("\\.", "/");
        if (document == null && (inputStream = ClientUtils.class.getResourceAsStream("/" + classPath + "/module.xml")) != null && (document = XMLUtils.parseDocument(new InputSource(inputStream))) != null) {
            ClientSetup.getInstance().putObject(rb_name, document);
        }
        return document;
    }

    public static List<IdTitle> getList(Node node) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        if (node != null && node.hasChildNodes()) {
            for (Element item : XMLUtils.elements(node.getChildNodes())) {
                String itemId = XMLUtils.getAttribute(item, "id", null);
                String itemName = XMLUtils.getAttribute(item, "title", null);
                result.add(new IdTitle(Utils.parseInt(itemId), itemName));
            }
        }
        return result;
    }

    public static final boolean isCtrlI(KeyEvent e) {
        return (e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73;
    }

    public static String getValueFromResourceBundle(String resourceBundleName, String key) {
        return ClientUtils.getValueFromResourceBundle(resourceBundleName, key, null);
    }

    public static String getValueFromResourceBundle(String resourceBundleName, String key, String defaultValue) {
        String value = defaultValue;
        if (resourceBundleName != null && key != null) {
            try {
                value = ResourceBundle.getBundle(resourceBundleName.concat("_user")).getString(key);
            }
            catch (MissingResourceException e1) {
                try {
                    value = ResourceBundle.getBundle(resourceBundleName).getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    public static Window showWaitWindow(String message) {
        JDialog dialog = new JDialog(JOptionPane.getRootFrame());
        dialog.setUndecorated(true);
        JLabel label = new JLabel(message, ClientUtils.getIcon("wait.gif"), 0);
        label.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        dialog.getContentPane().add(label);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        dialog.setModal(true);
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        label.paintImmediately(label.getBounds());
        label.revalidate();
        label.repaint();
        dialog.revalidate();
        dialog.repaint();
        return dialog;
    }

    public static String getComponentKey(Component c, String suffix) {
        StringBuilder sb = new StringBuilder();
        while (c != null) {
            if (c.getName() != null) {
                sb.append(c.getName());
            } else {
                sb.append(c.getClass().getSimpleName());
            }
            sb.append(":");
            c = c.getParent();
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        if (suffix != null) {
            sb.append(".").append(suffix);
        }
        return sb.toString();
    }

    public static File getLocalSettingFolder() {
        return BGClientRunnerUtil.getLocalSettingsDir();
    }

    public static int addComponentToPanel(JPanel panel, int gridy, Component[][] components, boolean addBottom) {
        for (Component[] rows : components) {
            panel.add(rows[0], new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            int both = rows[1] instanceof EditorTextField && ((EditorTextField)rows[1]).toHorizontal() ? 2 : 0;
            panel.add(rows[1], new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, both, new Insets(5, 5, 0, 5), 0, 0));
        }
        if (addBottom) {
            panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        return gridy;
    }

    public static void openContract(int contractId) {
        BGClientBase.getFrame().getTabbedPane().addTab(new ContractEditor(contractId));
    }

    public static void openContract(int contractId, String tabClass) {
        ContractEditor contractEditor = new ContractEditor(contractId);
        contractEditor = (ContractEditor)BGClientBase.getFrame().getTabbedPane().addTab(contractEditor);
        contractEditor.chooseTab(tabClass);
    }

    public static void openContract(int contractId, String tabClass, Object parameter) {
        ContractEditor contractEditor = new ContractEditor(contractId, tabClass);
        ContractEditor old = (ContractEditor)BGClientBase.getFrame().getTabbedPane().addTab(contractEditor);
        if (contractEditor != old) {
            contractEditor = old;
        }
        ContractPanel contractPanel = contractEditor.chooseTab(tabClass);
        contractPanel.setParameter(parameter);
    }

    public static void openContract(BGTable table, String idCol) {
        int contractId;
        String id = ClientUtils.getRowId(table, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440", idCol);
        if (id != null && (contractId = Utils.parseInt(id, -1)) > 0) {
            ClientUtils.openContract(contractId);
        }
    }
}

