/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class LicenseLocalDao
extends AbstractDao<LicenseData> {
    public LicenseLocalDao(Connection con) {
        super(con, 0, "license");
    }

    public LicenseData getLicenseData(int licenseId) throws BGException {
        LicenseData licenseData = null;
        try {
            licenseData = (LicenseData)this.getById(licenseId);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return licenseData;
    }

    public List<LicenseData> getLicenseDataList() throws BGException {
        return this.list("", "dt", new Object[0]);
    }

    public void deleteLicenseData(int licenseId) throws BGException {
        this.delete("id=?", licenseId);
    }

    public void activateLicenseData(int licenseId) throws BGException {
        String query = "UPDATE " + this.tableName + " SET active=(id=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, licenseId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    @Override
    protected LicenseData getFromRS(ResultSet rs) throws BGException, SQLException {
        return LicenseData.builder().setId(rs.getInt("id")).setActive(rs.getBoolean("active")).setCreateDate(rs.getTimestamp("dt")).setCount(rs.getInt("count")).setStorage(Storage.DATABASE).setHash(rs.getString("hash")).setEncryptData(rs.getString("encryptData")).setPlainData(rs.getString("plainData")).build();
    }

    @Override
    protected void updateImpl(LicenseData licenseLocalData) throws BGException, SQLException {
        if (licenseLocalData != null) {
            String query = "INSERT INTO " + this.tableName + " SET id=?, active=?, dt=?, count=?, hash=?, encryptData=?, plainData=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, licenseLocalData.getId());
                ps.setBoolean(index++, licenseLocalData.isActive());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp(licenseLocalData.getCreateDate()));
                ps.setInt(index++, licenseLocalData.getCount());
                ps.setString(index++, licenseLocalData.getHash());
                ps.setString(index++, licenseLocalData.getEncryptData());
                ps.setString(index++, licenseLocalData.getPlainData());
                ps.executeUpdate();
            }
        }
    }
}

