/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.bean;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailConfigDao;
import ru.bitel.bgbilling.server.util.Setup;

public class MailConfigCache {
    private static Map<String, MailConfig> mailConfigCacheMap = null;

    public static MailConfig getMailConfig(String componentId, int moduleId, String key) {
        return MailConfigCache.getMailConfigCacheMap().get(componentId + "_" + moduleId + "_" + key);
    }

    public static void resetCache() {
        mailConfigCacheMap = null;
    }

    private static Map<String, MailConfig> getMailConfigCacheMap() {
        if (mailConfigCacheMap == null) {
            HashMap<String, MailConfig> map = new HashMap<String, MailConfig>();
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();
                 MailConfigDao mailConfigDao = new MailConfigDao(con);){
                mailConfigDao.list().forEach(a -> map.put(a.getComponentId() + "_" + a.getModuleId() + "_" + a.getKey(), (MailConfig)a));
            }
            catch (Exception ex) {
                LogManager.getLogger().error((Object)ex);
            }
            mailConfigCacheMap = map;
        }
        return mailConfigCacheMap;
    }
}

