/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client;

import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.ClosableTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import ru.bitel.bgbilling.client.action.ActionCloseContracts;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.function.Async;

public class ContractTabbedPane
extends BGTabbedPane {
    private Image image = null;
    private JPopupMenu popupMenu = null;
    final ContractTabbedPane contractTabbedPane = this;

    public ContractTabbedPane() {
        super(3);
        this.init();
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && ContractTabbedPane.this.getUI().tabForCoordinate(ContractTabbedPane.this, event.getX(), event.getY()) >= 0) {
                    ContractTabbedPane.this.getPopupMenu().show(ContractTabbedPane.this, event.getX(), event.getY());
                }
            }
        });
        this.addChangeListener(event -> {
            Component component = this.getSelectedTab();
            if (component == null || !(component instanceof BGTabPanel)) {
                return;
            }
            BGTabPanel panel = (BGTabPanel)component;
            String panelId = panel.getTabId();
            if (!panelId.startsWith("contract_")) {
                return;
            }
            this.contractHistory(panel.getContext());
        });
    }

    private void contractHistory(ClientContext clientContext) {
        int contractId = clientContext.getContractId();
        if (contractId <= 0) {
            return;
        }
        ContractService contractService = clientContext.getPort(ContractService.class);
        Async.ofWithTry(() -> contractService.updateContractHistoryRecord(contractId));
    }

    private void init() {
        if ("0".equals(ClientSetup.getInstance().get("bg.enable", "1"))) {
            Color clr = UIManager.getColor("Panel.background");
            if (clr != null) {
                this.setBackground(clr);
            }
        } else {
            this.setImage("/img/background.gif");
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (image != null) {
            this.setPreferredSize(new Dimension(image.getWidth(this), image.getHeight(this)));
        }
    }

    public void setImage(URL url) {
        MediaTracker mt = new MediaTracker(this);
        this.image = this.getToolkit().createImage(url);
        mt.addImage(this.image, 1);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            this.image = null;
        }
        if (this.image != null) {
            this.setPreferredSize(new Dimension(this.image.getWidth(this), this.image.getHeight(this)));
        }
    }

    public void setImage(String path) {
        URL url = ContractTabbedPane.class.getResource(path);
        if (url != null) {
            this.setImage(url);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.getComponentCount() > 0) {
            super.paint(g);
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.image != null) {
                int w = this.image.getWidth(this);
                int h = this.image.getHeight(this);
                for (int x = 0; x < this.getWidth(); x += w) {
                    for (int y = 0; y < this.getHeight(); y += h) {
                        g.drawImage(this.image, x, y, this);
                    }
                }
            }
        }
    }

    @Override
    public void setUI(TabbedPaneUI ui) {
        super.setUI(new ClosableTabbedPaneUI());
    }

    public List<JPanel> getTabList() {
        ArrayList<JPanel> tabList = new ArrayList<JPanel>();
        JPanel[] tabs = this.getTabs();
        for (int index = 0; index < tabs.length; ++index) {
            tabList.add(tabs[index]);
        }
        return tabList;
    }

    public void setTabList(List<JPanel> tabs) {
        if (tabs != null) {
            for (JPanel tab : tabs) {
                if (!(tab instanceof AbstractTabPanel)) continue;
                super.addTab(((AbstractTabPanel)((Object)tab)).getTabId(), (AbstractTabPanel)((Object)tab));
            }
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new JMenuItem("\u041d\u043e\u0432\u0430\u044f \u0432\u043a\u043b\u0430\u0434\u043a\u0430 ..."){
                {
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            Component currentTab = ContractTabbedPane.this.getSelectedTab();
                            try {
                                String tabTitle;
                                if (currentTab instanceof BGTabPanel) {
                                    String tabTitle2 = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u043a\u043b\u0430\u0434\u043a\u0438", "\u0417\u0430\u043f\u0440\u043e\u0441", 3, null, null, ((BGTabPanel)currentTab).getTabTitle());
                                    if (tabTitle2 != null) {
                                        ContractTabbedPane.this.addCopyTab(((BGTabPanel)currentTab).getCopyTabPanel(tabTitle2));
                                    }
                                } else if (currentTab instanceof BGUTabPanel && (tabTitle = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u043a\u043b\u0430\u0434\u043a\u0438", "\u0417\u0430\u043f\u0440\u043e\u0441", 3, null, null, ((BGUTabPanel)currentTab).getTabTitle())) != null) {
                                    ContractTabbedPane.this.addCopyTab(((BGUTabPanel)currentTab).getCopyTabPanel(tabTitle));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            });
            this.popupMenu.addSeparator();
            this.popupMenu.add(new JMenuItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0443"){
                {
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            ContractTabbedPane.this.removeSelectedTab();
                        }
                    });
                }
            });
            this.popupMenu.add(new JMenuItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0438 ..."){
                {
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            new ActionCloseContracts().actionPerformed(event);
                        }
                    });
                }
            });
            this.popupMenu.add(new JMenuItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0438 \u0441\u043b\u0435\u0432\u0430"){
                {
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            Component currentTab = ContractTabbedPane.this.getSelectedTab();
                            for (JPanel panel : ContractTabbedPane.this.getTabs()) {
                                if (panel.equals(currentTab)) break;
                                ContractTabbedPane.this.removeTab(panel);
                            }
                        }
                    });
                }
            });
            this.popupMenu.add(new JMenuItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u043a\u043b\u0430\u0434\u043a\u0438 \u0441\u043f\u0440\u0430\u0432\u0430"){
                {
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            Component currentTab = ContractTabbedPane.this.getSelectedTab();
                            JPanel[] tabs = ContractTabbedPane.this.getTabs();
                            for (int index = tabs.length - 1; index > -1 && !tabs[index].equals(currentTab); --index) {
                                ContractTabbedPane.this.removeTab(tabs[index]);
                            }
                        }
                    });
                }
            });
        }
        return this.popupMenu;
    }

    public List<ContractIdTitleComment> getContracts() {
        ArrayList<ContractIdTitleComment> list = new ArrayList<ContractIdTitleComment>();
        for (int index = 0; index < this.getTabCount(); ++index) {
            BGTabPanel panel;
            String panelId;
            Component comp = this.getComponentAt(index);
            if (comp == null || !(comp instanceof BGTabPanel) || !(panelId = (panel = (BGTabPanel)comp).getTabId()).startsWith("contract_")) continue;
            String title = panel.getTabTitle();
            String comment = "";
            if (comp instanceof ContractEditor) {
                comment = String.valueOf(((ContractEditor)comp).getAttribute("contractComment"));
            }
            list.add(new ContractIdTitleComment(Utils.parseInt(panelId.substring(9)), title, comment));
        }
        return list;
    }
}

