/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.SearchResult;

public class ContractHistoryRecordDao
extends AbstractDao<ContractHistoryRecord> {
    public ContractHistoryRecordDao(Connection con) {
        super(con, 0, "contract_history_open_log");
    }

    public void searchContractHistoryRecord(SearchResult<ContractHistoryRecord> searchResult, int userId) throws BGException {
        if (searchResult != null) {
            List<ContractHistoryRecord> list = searchResult.getList();
            String query = "SELECT log.*, c.title AS contract_title, c.comment AS contract_comment FROM " + this.tableName + " AS log LEFT JOIN contract AS c ON c.id=log.contract_id WHERE user_id=? AND c.title IS NOT NULL ORDER BY last_open DESC LIMIT 100";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, userId);
                try (ResultSet resultSet = ps.executeQuery();){
                    while (resultSet.next()) {
                        list.add(this.getFromRS(resultSet));
                    }
                }
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    @Override
    protected ContractHistoryRecord getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractHistoryRecord contractHistoryRecord = new ContractHistoryRecord();
        contractHistoryRecord.setUserId(rs.getInt("user_id"));
        contractHistoryRecord.setContractId(rs.getInt("contract_id"));
        contractHistoryRecord.setLastOpen(rs.getTimestamp("last_open"));
        contractHistoryRecord.setContractTitle(rs.getString("contract_title"));
        contractHistoryRecord.setContractComment(rs.getString("contract_comment"));
        return contractHistoryRecord;
    }

    @Override
    protected void updateImpl(ContractHistoryRecord contractHistoryRecord) throws BGException, SQLException {
        int index = 1;
        PreparedStatement ps = this.con.prepareStatement("INSERT INTO `" + this.tableName + "` SET user_id=?, contract_id=?, last_open=? ON DUPLICATE KEY UPDATE last_open=?");
        ps.setInt(index++, contractHistoryRecord.getUserId());
        ps.setInt(index++, contractHistoryRecord.getContractId());
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds(contractHistoryRecord.getLastOpen()));
        ps.setTimestamp(index, TimeUtils.convertDateToTimestampSeconds(contractHistoryRecord.getLastOpen()));
        ps.executeUpdate();
        ps.close();
        if (ThreadLocalRandom.current().nextInt(9) == 0) {
            ps = this.con.prepareStatement("DELETE FROM `" + this.tableName + "` WHERE user_id=? AND last_open < NOW() - INTERVAL 2 MONTH");
            ps.setInt(1, contractHistoryRecord.getUserId());
            ps.executeUpdate();
            ps.close();
        }
    }
}

