/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.inet.IpAddress;

public abstract class Data {
    public final byte[] ipv4SrcAddress = new byte[4];
    public final byte[] ipv4DstAddress = new byte[4];
    public final byte[] ipv6SrcAddress = new byte[16];
    public final byte[] ipv6DstAddress = new byte[16];
    public final IpAddress srcAddress = new IpAddress();
    public final IpAddress dstAddress = new IpAddress();
    public int srcPort;
    public int dstPort;
    public long nextHop;
    public int inputInterface;
    public int outputInterface;
    public long packets;
    public long octets;
    public long first;
    public long last;
    public long milliseconds;
    public int diffServ;
    public int protocol;

    public int getProtocol() {
        return this.protocol;
    }

    public long getSrcAddress() {
        byte[] srcAddress = this.ipv4SrcAddress;
        return ((long)srcAddress[0] & 0xFFL) << 24 | ((long)srcAddress[1] & 0xFFL) << 16 | ((long)srcAddress[2] & 0xFFL) << 8 | ((long)srcAddress[3] & 0xFFL) << 0;
    }

    public IpAddress getSrcIpAddress() {
        return this.srcAddress;
    }

    public IpAddress getDstIpAddress() {
        return this.dstAddress;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public long getDstAddress() {
        byte[] dstAddress = this.ipv4DstAddress;
        return ((long)dstAddress[0] & 0xFFL) << 24 | ((long)dstAddress[1] & 0xFFL) << 16 | ((long)dstAddress[2] & 0xFFL) << 8 | ((long)dstAddress[3] & 0xFFL) << 0;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public long getNextHop() {
        return this.nextHop;
    }

    public int getInputInterface() {
        return this.inputInterface;
    }

    public int getOutputInterface() {
        return this.outputInterface;
    }

    public long getPackets() {
        return this.packets;
    }

    public long getOctets() {
        return this.octets;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public int getDiffServ() {
        return this.diffServ;
    }

    public static final void copy(Data data, Data thiz) {
        if (thiz.srcAddress.address.length == 4) {
            data.srcAddress.address = data.ipv4SrcAddress;
            data.dstAddress.address = data.ipv4DstAddress;
            System.arraycopy(thiz.srcAddress.address, 0, data.srcAddress.address, 0, 4);
            System.arraycopy(thiz.dstAddress.address, 0, data.dstAddress.address, 0, 4);
        } else {
            data.srcAddress.address = data.ipv6SrcAddress;
            data.dstAddress.address = data.ipv6DstAddress;
            System.arraycopy(thiz.srcAddress.address, 0, data.srcAddress.address, 0, 16);
            System.arraycopy(thiz.dstAddress.address, 0, data.dstAddress.address, 0, 16);
        }
        data.nextHop = thiz.nextHop;
        data.inputInterface = thiz.inputInterface;
        data.outputInterface = thiz.outputInterface;
        data.packets = thiz.packets;
        data.octets = thiz.octets;
        data.first = thiz.first;
        data.last = thiz.last;
        data.srcPort = thiz.srcPort;
        data.dstPort = thiz.dstPort;
        data.diffServ = thiz.diffServ;
        data.milliseconds = thiz.milliseconds;
        data.protocol = thiz.protocol;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(50).append("Flow ");
        result.append(this.inputInterface);
        result.append(":");
        result.append(this.srcAddress.toString());
        result.append(":");
        result.append(this.srcPort);
        result.append(" / ");
        result.append(this.outputInterface);
        result.append(":");
        result.append(this.dstAddress.toString());
        result.append(":");
        result.append(this.dstPort);
        result.append(" ");
        result.append(this.octets);
        result.append(" ToS/DiffServ: ");
        result.append(Integer.toBinaryString(this.diffServ));
        result.append(" nextHop: ");
        result.append(IPUtils.convertLongIpToString(this.nextHop));
        return result.toString();
    }
}

