/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.update.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public class LibInfo
extends BGLogger
implements Comparator<LibInfo> {
    private String type;
    private String dir;
    private String toDir;
    private String name;
    private String hash;
    private File file;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToDir() {
        return this.toDir;
    }

    public void setToDir(String toDir) {
        this.toDir = toDir;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        return String.format("%s\t%s\t%s", this.name, this.hash, this.file.toString());
    }

    @Override
    public int compare(LibInfo libInfo1, LibInfo libInfo2) {
        return libInfo1.getName().compareToIgnoreCase(libInfo2.getName());
    }

    public void serializeLib(OutputStream outputStream) throws IOException {
        byte[] bytes = this.getType().getBytes("UTF-8");
        outputStream.write(bytes.length);
        outputStream.write(bytes);
        Object name = this.getName();
        if (Utils.notBlankString(this.toDir)) {
            int pos = ((String)name).lastIndexOf("/");
            if (pos > -1) {
                name = ((String)name).substring(pos + 1);
            }
            name = this.toDir + "/" + (String)name;
        }
        this.getLogger().debug("this.name={}; this.toDir={}; name={}", (Object)this.getName(), (Object)this.getToDir(), name);
        bytes = ((String)name).getBytes("UTF-8");
        outputStream.write(bytes.length);
        outputStream.write(bytes);
        long length = this.getFile().length();
        outputStream.write(LibInfo.longToBytes(length));
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        Utils.flush(fileInputStream, outputStream);
        fileInputStream.close();
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private LibInfo libInfo = new LibInfo();

        private Builder() {
        }

        public Builder setType(String type) {
            this.libInfo.type = type;
            return this;
        }

        public Builder setDir(String dir) {
            this.libInfo.dir = dir;
            return this;
        }

        public Builder setName(String name) {
            this.libInfo.name = name;
            return this;
        }

        public Builder setToDir(String toDir) {
            this.libInfo.toDir = toDir;
            return this;
        }

        public LibInfo build() {
            try {
                LibInfo libInfo = this.libInfo;
                return libInfo;
            }
            finally {
                this.libInfo = null;
            }
        }
    }
}

