/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client.tariff;

import bitel.billing.module.tariff.directory.DirectoriesManager;
import javax.swing.Icon;
import javax.swing.JComboBox;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.directory.tariff.common.TariffDirectory;
import ru.bitel.bgbilling.kernel.tariff.client.tree.MultiSelectTariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;

public class ProductSpecFilterTariffTreeNode
extends MultiSelectTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("fugue/present");

    @Override
    protected String getDirName() {
        return "productSpec";
    }

    @Override
    protected boolean needMode() {
        return false;
    }

    @Override
    protected boolean canEmpty() {
        return false;
    }

    @Override
    protected String getViewLabel() {
        return "\u041f\u0440\u043e\u0434\u0443\u043a\u0442: ";
    }

    @Override
    protected String getStoreKey() {
        return "productSpecIds";
    }

    @Override
    protected Icon getIcon() {
        return icon;
    }

    @Override
    protected void buildDirectoryCombo(Directory dir, JComboBox<IdTitle> combo) {
        if (dir instanceof DirectoriesManager.LazyDirectory) {
            dir = ((DirectoriesManager.LazyDirectory)dir).getDirectory();
        }
        TariffDirectory productSpecDirectory = (TariffDirectory)dir;
        for (ProductSpec productSpec : productSpecDirectory.list()) {
            Object title = Utils.isBlankString(productSpec.getIdentifier()) ? productSpec.getTitle() : productSpec.getTitle() + " [" + productSpec.getIdentifier() + "]";
            combo.addItem(new IdTitle(productSpec.getId(), (String)title));
        }
    }

    @Override
    protected String getValue(int sid) {
        TariffDirectory productSpecDirectory;
        ProductSpec productSpec;
        Directory dir = this.getDirectory();
        if (dir instanceof DirectoriesManager.LazyDirectory) {
            dir = ((DirectoriesManager.LazyDirectory)dir).getDirectory();
        }
        if ((productSpec = (ProductSpec)(productSpecDirectory = (TariffDirectory)dir).get(sid)) == null) {
            return "null";
        }
        if (Utils.isBlankString(productSpec.getIdentifier())) {
            return productSpec.getTitle();
        }
        return productSpec.getTitle() + " [" + productSpec.getIdentifier() + "]";
    }
}

