/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device;

import bitel.billing.module.common.BGPasswordField;
import bitel.billing.module.common.BGTextArea;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGConfigEditor;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.client.device.DevicePanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public class DeviceFormMain<D extends Device<D, T>, T extends DeviceType>
extends BGUPanel {
    protected String module = "";
    protected final DevicePanel<D, T> devicePanel;
    protected DeviceTextField deviceId;
    protected BGTextArea deviceTitle;
    protected DeviceTextField identifier;
    protected DeviceTextField customIdentifier;
    protected DeviceTextField host;
    protected DeviceTextField customHost;
    protected BGControlPanelPeriod period = new BGControlPanelPeriod();
    protected DeviceTextField user;
    protected BGPasswordField password;
    protected BGPasswordField secret;
    protected BGUComboBox<T> deviceType;
    protected BGUComboBox<T> customDeviceType;
    protected BGUCheckTree<DeviceGroup> deviceGroup;
    protected BGUCheckTree<DeviceGroup> customDeviceGroup;
    protected BGConfigEditor config;
    protected BGConfigEditor customConfig;
    protected BGConfigEditor configPreview;
    protected CardLayout configPanelLayout;
    protected JPanel configPanel;
    protected JCheckBox orderManagerDisabled;
    protected JTextArea comment;
    protected final AtomicReference<D> currentRef;
    protected D current;
    protected DeviceService<D, T> wsDevice;
    protected boolean neeDeviceGroup = true;
    protected JPanel paramPanel;
    protected List<BGUPanel> panels = new ArrayList<BGUPanel>();
    AbstractBGUPanel.DefaultAction configPreviewToggle = new AbstractBGUPanel.DefaultAction("ok.configPreviewToggle", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f"){

        @Override
        protected void init(JComponent panel, String command, KeyStroke stroke) {
            super.init(panel, command, stroke);
            this.putValue("ShortDescription", "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0438 \u0442\u0438\u043f\u043e\u0432 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
        }

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (DeviceFormMain.this.config.isShowing()) {
                String preview = DeviceFormMain.this.wsDevice.deviceConfigPreview(DeviceFormMain.this.current.getId());
                DeviceFormMain.this.configPreview.setText(preview);
                DeviceFormMain.this.configPanelLayout.show(DeviceFormMain.this.configPanel, "configPreview");
                this.putValue("Name", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
                this.putValue("ShortDescription", "\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043a \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e");
            } else {
                DeviceFormMain.this.configPanelLayout.show(DeviceFormMain.this.configPanel, "config");
                this.putValue("Name", "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
                this.putValue("ShortDescription", "\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 \u0438 \u0442\u0438\u043f\u043e\u0432 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432");
            }
        }
    };

    public DeviceFormMain(DevicePanel<D, T> devicePanel, AtomicReference<D> currentRef, String module) {
        super(new BorderLayout());
        this.wsDevice = devicePanel.getWs();
        this.devicePanel = devicePanel;
        this.currentRef = currentRef;
        this.module = module;
    }

    @Override
    protected void jbInit() {
        this.deviceId = new DeviceTextField(7);
        Color bgColor = this.deviceId.getBackground();
        this.deviceId.setEditable(false);
        this.deviceId.setBackground(bgColor);
        this.deviceTitle = new BGTextArea(2, 30);
        this.deviceTitle.setEditable(false);
        this.identifier = new DeviceTextField();
        this.customIdentifier = new DeviceTextField();
        this.host = new DeviceTextField();
        this.customHost = new DeviceTextField();
        this.config = new BGConfigEditor();
        this.configPreview = new BGConfigEditor();
        this.configPreview.setEditable(false);
        this.deviceType = new BGUComboBox();
        this.customDeviceType = new BGUComboBox();
        this.deviceGroup = new BGUCheckTree<DeviceGroup>(DeviceGroup.class);
        this.user = new DeviceTextField();
        this.password = new BGPasswordField();
        this.secret = new BGPasswordField();
        String orderManagerText = switch (this.module) {
            case "inet" -> "\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
            case "voice" -> "\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
            default -> "OrderManager \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
        };
        this.orderManagerDisabled = new JCheckBox(orderManagerText);
        this.comment = new JTextArea(2, 20);
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        JPanel panel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapEmptyBorder(panel);
        this.paramPanel = panel;
        JTabbedPane leftTabbedPane = null;
        if (!this.devicePanel.isLibrary()) {
            leftTabbedPane = new JTabbedPane();
            JScrollPane scrollPane = new JScrollPane(BGSwingUtilites.wrapEmptyBorder(panel, true), 20, 31);
            scrollPane.setBorder(null);
            leftTabbedPane.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", scrollPane);
        }
        panel.add((Component)this.getIdPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.deviceTitle), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)this.identifier, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.addRedefinitionField(panel, "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 (\u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435):", this.customIdentifier);
        panel.add((Component)new JLabel("\u0425\u043e\u0441\u0442/\u043f\u043e\u0440\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.host, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.addRedefinitionField(panel, "\u0425\u043e\u0441\u0442/\u043f\u043e\u0440\u0442 (\u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435):", this.customHost);
        panel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.user, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.password, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("Community/secret:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.secret, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.addPanelAfterSecret();
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add(this.deviceType, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.addRedefinitionField(panel, "\u0422\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 (\u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435):", this.customDeviceType);
        panel.add((Component)this.orderManagerDisabled, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
        JComponent leftComponent = null;
        if (!this.devicePanel.isLibrary()) {
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            if (this.neeDeviceGroup) {
                this.customDeviceGroup = new BGUCheckTree<DeviceGroup>(DeviceGroup.class);
                panel = new JPanel(new GridBagLayout());
                BGSwingUtilites.wrapEmptyBorder(panel);
                panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)new JScrollPane(this.deviceGroup), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
                panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 (\u0434\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435):"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
                panel.add((Component)new JScrollPane(this.customDeviceGroup), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
                leftTabbedPane.addTab("\u0413\u0440\u0443\u043f\u043f\u044b", panel);
            }
            leftComponent = leftTabbedPane;
        } else {
            if (this.neeDeviceGroup) {
                JScrollPane pane = new JScrollPane(this.deviceGroup);
                pane.setPreferredSize(new Dimension(0, 130));
                panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
                panel.add((Component)pane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
            }
            panel.add(Box.createGlue(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JScrollPane scrollPane = new JScrollPane(BGSwingUtilites.wrapEmptyBorder(panel, true), 20, 31);
            scrollPane.setBorder(null);
            leftComponent = scrollPane;
        }
        panel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapEmptyBorder(panel);
        panel.add((Component)new BGButton(this.configPreviewToggle), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane tabbed = new JTabbedPane();
        this.addContigTabs(tabbed);
        tabbed.addTab("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", BGSwingUtilites.wrapEmptyBorder(this.config));
        if (!this.devicePanel.isLibrary()) {
            this.customConfig = new BGConfigEditor();
            tabbed.addTab("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f (\u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435)", BGSwingUtilites.wrapEmptyBorder(this.customConfig));
        }
        this.configPanelLayout = new CardLayout();
        this.configPanel = new JPanel(this.configPanelLayout);
        this.configPanel.add((Component)tabbed, "config");
        this.configPanel.add((Component)this.configPreview, "configPreview");
        panel.add((Component)this.configPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, leftComponent, (Component)panel, 400L);
        this.add((Component)splitPane, "Center");
        this.deviceType.addActionListener(e -> this.setEntitySpecId());
        this.customDeviceType.addActionListener(e -> this.setEntitySpecId());
        this.orderManagerDisabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = DeviceFormMain.this.getContext() != null && "inet".equals(((ClientContext)DeviceFormMain.this.getContext()).getModule()) ? "\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432" : "OrderManager";
                if (DeviceFormMain.this.orderManagerDisabled.isSelected()) {
                    if (!BGSwingUtilites.confirm("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c " + title, null)) {
                        DeviceFormMain.this.orderManagerDisabled.setSelected(false);
                    }
                } else if (!BGSwingUtilites.confirm("\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c " + title, null)) {
                    DeviceFormMain.this.orderManagerDisabled.setSelected(true);
                }
            }
        });
    }

    protected void addContigTabs(JTabbedPane tabbed) {
    }

    private void setEntitySpecId() {
        int deviceEntitySpecId = 0;
        DeviceType typeId = (DeviceType)this.customDeviceType.getSelectedItem();
        if (typeId != null && typeId.getDeviceEntitySpecId() > 0) {
            deviceEntitySpecId = typeId.getDeviceEntitySpecId();
        } else {
            typeId = (DeviceType)this.deviceType.getSelectedItem();
            if (typeId != null && typeId.getDeviceEntitySpecId() > 0) {
                deviceEntitySpecId = typeId.getDeviceEntitySpecId();
            }
        }
        this.current.setEntitySpecId(deviceEntitySpecId);
    }

    private JPanel getIdPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("ID#"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.deviceId, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected void addRedefinitionField(JPanel panel, String labeltext, Component field) {
        if (!this.devicePanel.isLibrary()) {
            panel.add((Component)new JLabel(labeltext), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            panel.add(field, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        }
    }

    protected void addPanelAfterSecret() {
    }

    public DeviceType getSelectedDeviceType() {
        return (DeviceType)this.deviceType.getSelectedItem();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> {
            this.current = (Device)this.currentRef.get();
            this.current.setId(-1);
            this.current.setEntityAttributes(new HashMap());
            for (BGUPanel panel : this.panels) {
                panel.performAction("new");
            }
            this.devicePanel.getModel().optSelectedRow().ifPresent(parent -> this.current.setParentId(parent.getId()));
            this.deviceId.setText("");
            this.deviceTitle.setText("");
            this.identifier.setText("");
            this.host.setText("");
            this.period.setLocalDateFrom(null);
            this.period.setLocalDateTo(null);
            this.user.setText("");
            this.password.setText("");
            this.secret.setText("");
            List<T> deviceTypeList = ((ClientContext)this.getContext()).getDirectory(this.devicePanel.getDeviceTypeClass()).list();
            deviceTypeList.sort(Comparator.comparing(IdTitle::getTitle));
            this.initDeviceTypeCombobox(deviceTypeList);
            if (this.customDeviceType != null) {
                this.initCustomDeviceTypeCombo(deviceTypeList);
            }
            this.deviceGroup.setData(this.wsDevice.deviceGroupRoot());
            this.deviceGroup.expand();
            this.orderManagerDisabled.setSelected(false);
            this.comment.setText("");
            this.config.setText("");
            this.showCustomValues();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            this.current = (Device)this.currentRef.get();
            if (this.current != null) {
                for (BGUPanel panel : this.panels) {
                    panel.performAction("edit");
                }
                this.deviceId.setText(String.format("%d", this.current.getId()));
                this.deviceTitle.setText(this.current.getTitle());
                this.identifier.setText(this.current.getIdentifier());
                this.host.setText(this.current.getHost());
                this.period.setDateFrom(this.current.getDateFrom());
                this.period.setDateTo(this.current.getDateTo());
                this.user.setText(this.current.getUsername());
                this.password.setText(this.current.getPassword());
                this.secret.setText(this.current.getSecret());
                List<T> deviceTypeList = ((ClientContext)this.getContext()).getDirectory(this.devicePanel.getDeviceTypeClass()).list();
                this.initDeviceTypeCombobox(deviceTypeList);
                if (this.customDeviceType != null) {
                    this.initCustomDeviceTypeCombo(deviceTypeList);
                }
                this.deviceType.setSelectedItem(this.current.getDeviceTypeId());
                this.orderManagerDisabled.setSelected(this.current.isOrderManagerDisabled());
                DeviceGroup deviceGroupRoot = this.wsDevice.deviceGroupRoot();
                this.deviceGroup.setData(deviceGroupRoot, this.current.getDeviceGroupIds() != null ? this.current.getDeviceGroupIds() : Collections.emptySet());
                this.deviceGroup.expand();
                this.comment.setText(this.current.getComment());
                this.config.setText(this.current.getConfig());
                this.showCustomValues();
            }
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (DeviceFormMain.this.deviceType.getSelectedItem() != null) {
                    DeviceFormMain.this.current.setDeviceTypeId(((DeviceType)DeviceFormMain.this.deviceType.getSelectedItem()).getId());
                }
                DeviceFormMain.this.current.setDeviceGroupIds(DeviceFormMain.this.deviceGroup.getChecked());
                DeviceFormMain.this.current.setIdentifier(DeviceFormMain.this.identifier.getText());
                DeviceFormMain.this.current.setHost(DeviceFormMain.this.host.getText());
                DeviceFormMain.this.current.setDateFrom(DeviceFormMain.this.period.getDateFrom());
                DeviceFormMain.this.current.setDateTo(DeviceFormMain.this.period.getDateTo());
                DeviceFormMain.this.current.setUsername(DeviceFormMain.this.user.getText());
                DeviceFormMain.this.current.setPassword(new String(DeviceFormMain.this.password.getPassword()));
                DeviceFormMain.this.current.setSecret(new String(DeviceFormMain.this.secret.getPassword()));
                DeviceFormMain.this.current.setComment(DeviceFormMain.this.comment.getText());
                DeviceFormMain.this.current.setConfig(DeviceFormMain.this.config.getText());
                DeviceFormMain.this.current.setOrderManagerDisabled(DeviceFormMain.this.orderManagerDisabled.isSelected());
                DeviceFormMain.this.saveCustomValues();
                for (BGUPanel panel : DeviceFormMain.this.panels) {
                    panel.performAction("ok");
                }
            }
        };
        final HashSet cutSet = new HashSet();
        new AbstractBGUPanel.MenuAction("device.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("cut")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                cutSet.clear();
                List selectedRows = DeviceFormMain.this.devicePanel.getModel().getSelectedRows();
                if (selectedRows == null) {
                    return;
                }
                for (Device d : selectedRows) {
                    cutSet.add(d.getId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("device.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("paste")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                Device parent = (Device)DeviceFormMain.this.devicePanel.getModel().getSelectedRow();
                if (parent != null && cutSet.size() > 0) {
                    DeviceFormMain.this.devicePanel.deviceMove(parent.getId(), cutSet);
                    cutSet.clear();
                    DeviceFormMain.this.devicePanel.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.MenuAction("device.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("delete")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DeviceFormMain.this.devicePanel.performAction("delete");
            }
        };
    }

    protected void initCustomDeviceTypeCombo(List<T> deviceTypeList) {
        ArrayList<T> data = new ArrayList<T>(deviceTypeList);
        data.add(0, this.devicePanel.newDeviceType(-1, "---"));
        this.customDeviceType.setData(data);
    }

    protected void initDeviceTypeCombobox(List<T> deviceTypeList) {
        ArrayList<T> data = new ArrayList<T>(deviceTypeList);
        data.add(0, this.devicePanel.newDeviceType(0, "\u041f\u0430\u043f\u043a\u0430"));
        data.add(1, this.devicePanel.newDeviceType(-1, "-----"));
        this.deviceType.setData(data);
    }

    protected void saveCustomValues() {
    }

    protected void showCustomValues() {
    }

    public static class DeviceTextField
    extends BGTextField {
        public DeviceTextField() {
            this.setHorizontalAlignment(2);
            this.setFont(this.getFont().deriveFont(1));
        }

        public DeviceTextField(int cols) {
            super(cols);
            this.setHorizontalAlignment(2);
            this.setFont(this.getFont().deriveFont(1));
        }
    }
}

