/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoPhone;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MangoPhoneDao
extends AbstractIdDao<MangoPhone> {
    public MangoPhoneDao(Connection con, int moduleId) {
        super(con, moduleId, "mango_product_phone_number");
    }

    public List<MangoPhone> phoneList(int contractId) throws BGException {
        return this.list("contractId=?", null, new Object[]{contractId});
    }

    protected MangoPhone getFromRS(ResultSet rs) throws SQLException, BGException {
        MangoPhone phone = new MangoPhone();
        phone.setId(rs.getInt("id"));
        phone.setAccountProductId(rs.getInt("accountProductId"));
        phone.setPhone(rs.getString("phone"));
        phone.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        phone.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        phone.setStatus(rs.getInt("status"));
        return phone;
    }

    protected void updateImpl(MangoPhone phone) throws BGException, SQLException {
        if (phone == null) {
            return;
        }
        int index = 1;
        if (phone.getId() < 1) {
            try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET contractId=?, accountProductId=?, phone=?, dateFrom=?, dateTo=?, status=?", 1);){
                ps.setInt(index++, phone.getContractId());
                ps.setInt(index++, phone.getAccountProductId());
                ps.setString(index++, phone.getPhone());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)phone.getDateFrom()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)phone.getDateTo()));
                ps.setInt(index++, phone.getStatus());
                ps.executeUpdate();
                phone.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET dateTo=?, status=? WHERE id=?");){
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)phone.getDateTo()));
            ps.setInt(index++, phone.getStatus());
            ps.setInt(index++, phone.getId());
            ps.executeUpdate();
        }
    }
}

