/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubRequestLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MegogoContractSubRequestLogDao
extends AbstractIdDao<MegogoContractSubRequestLog> {
    public MegogoContractSubRequestLogDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_sub_request_log");
    }

    public void setContractSubscriptionId(int id, int contractSubscriptionId) {
        if (id > 0 && contractSubscriptionId > 0) {
            try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET contractSubId=" + contractSubscriptionId + " WHERE id=" + id);){
                ps.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<MegogoContractSubRequestLog> getContractLogList(int contractId) throws BGException {
        return this.list("contractId=?", "time", new Object[]{contractId});
    }

    protected MegogoContractSubRequestLog getFromRS(ResultSet rs) throws SQLException, BGException {
        MegogoContractSubRequestLog log = new MegogoContractSubRequestLog();
        log.setId(rs.getInt("id"));
        log.setContractSubId(rs.getInt("contractSubId"));
        log.setSid(rs.getInt("sid"));
        log.setContractId(rs.getInt("contractId"));
        log.setType(rs.getInt("type"));
        log.setAnswerResult(rs.getInt("answerResult"));
        log.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time")));
        log.setErrorMessage(rs.getString("errorMessage"));
        log.setUserId(rs.getInt("userId"));
        return log;
    }

    protected void updateImpl(MegogoContractSubRequestLog log) throws BGException, SQLException {
        if (log != null && log.getId() < 1) {
            String query = "INSERT INTO " + this.tableName + " SET contractSubId=?, contractId=?, sid=?, type=?, answerResult=?, time=?, errorMessage=?, userId=?";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                int index = 0;
                ps.setInt(++index, log.getContractSubId());
                ps.setInt(++index, log.getContractId());
                ps.setInt(++index, log.getSid());
                ps.setInt(++index, log.getType());
                ps.setInt(++index, log.getAnswerResult());
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)log.getDate()));
                ps.setString(++index, log.getErrorMessage());
                ps.setInt(++index, log.getUserId());
                ps.executeUpdate();
                log.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

