/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.mps.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.mps.common.service.MPSService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    protected List<KeyValue> systemItems = new ArrayList<KeyValue>();
    protected BGComboBox<ComboBoxItem> systemComboBox = new BGComboBox();

    public TransactionPanel() {
        try {
            this.systemItems.add(new KeyValue("0", "-----"));
            this.systemItems.addAll(((MPSService)((ClientContext)this.getContext()).getPort(MPSService.class)).getMPSSystemList());
            this.systemItems.forEach(a -> this.systemComboBox.addItem((Object)new ComboBoxItem((Object)a.getKey(), a.getValue())));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            AbstractTransactionStatus status = (AbstractTransactionStatus)this.statusComboBox.getSelectedItem();
            String systemId = ((ComboBoxItem)this.systemComboBox.getSelectedItem()).getObject().toString();
            SearchResult searchResult = ((MPSService)((ClientContext)this.getContext()).getPort(MPSService.class)).searchTransactions(((ClientContext)this.getContext()).getContractId(), systemId, status.getCode(), this.periodPanel.getPeriod(), this.pagePanel.getPage());
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
    }

    protected JPanel getExtraFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0421\u0438\u0441\u0442\u0435\u043c\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.systemComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected void initListeners() {
        if (this.systemComboBox.getItemCount() > 0) {
            this.systemComboBox.setSelectedIndex(0);
        }
        this.systemComboBox.addItemListener(this.comboBoxSelect(e -> {
            this.pagePanel.setPageIndex(1);
            this.performAction("refresh");
        }));
        super.initListeners();
    }
}

