/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.RangeParser;
import ru.bitel.bgbilling.modules.phone.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionClientItemUpdate
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", 0);
        int type = this.getIntParameter("type", -1);
        if (this.mid <= 0 || this.cid <= 0 || type <= 0) {
            throw new BGIllegalArgumentException();
        }
        ClientItemManager man = new ClientItemManager(this.con, this.mid);
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        TimeUtils.checkPeriod((Date)date1, (Date)date2);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionClientItemUpdate", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            ClientItem oldItem = man.getItem(id);
            Date olddate1 = null;
            Date olddate2 = null;
            if (oldItem != null) {
                olddate1 = TimeUtils.convertCalendarToDate((Calendar)oldItem.getDate1());
                olddate2 = TimeUtils.convertCalendarToDate((Calendar)oldItem.getDate2());
            }
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, olddate2, (Date)date1, (Date)date2);
        }
        ClientItem item = new ClientItem();
        item.setId(id);
        item.setObjectId(this.getIntParameter("object_id", 0));
        item.setContractId(this.cid);
        item.setSourceId(this.getIntParameter("sourceId", 0));
        item.setDate1(TimeUtils.convertDateToCalendar((Date)date1));
        item.setDate2(TimeUtils.convertDateToCalendar((Date)date2));
        item.setType(type);
        item.setComment(this.getParameter("comment", ""));
        item.setAlias(this.getParameter("alias", ""));
        if (type == 1) {
            item.setClientNumbers(Utils.toList((String)this.getParameter("clientNumbers")));
            item.setClientPorts(Utils.toList((String)this.getParameter("clientPorts")));
        } else {
            item.setOperFromPorts(Utils.toList((String)this.getParameter("operFromPorts", "")));
            item.setOperToPorts(Utils.toList((String)this.getParameter("operToPorts", "")));
            item.setOperFromPrefs(this.getParameter("operFromPrefs", ""));
            item.setOperToPrefs(this.getParameter("operToPrefs", ""));
            item.setOperNotFromPrefs(this.getParameter("operNotFromPrefs", ""));
            item.setOperNotToPrefs(this.getParameter("operNotToPrefs", ""));
            item.setOperServiceId(this.getIntParameter("operServiceId", 0));
            item.setOperFromPortsRegexp(this.getParameter("operFromPortsRegexp", ""));
            item.setOperToPortsRegexp(this.getParameter("operToPortsRegexp", ""));
            String operFromRange = this.getParameter("operFromRange");
            String operNotFromRange = this.getParameter("operNotFromRange");
            String operToRange = this.getParameter("operToRange");
            String operNotToRange = this.getParameter("operNotToRange");
            if (!(this.checkRange(operFromRange, "\u0421 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u043e\u0432") && this.checkRange(operNotFromRange, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u043e\u0432") && this.checkRange(operToRange, "\u041d\u0430 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u044b") && this.checkRange(operNotToRange, "\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043d\u0430 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u044b"))) {
                return;
            }
            item.setOperFromRange(operFromRange);
            item.setOperNotFromRange(operNotFromRange);
            item.setOperToRange(operToRange);
            item.setOperNotToRange(operNotToRange);
            item.setOperFromRangeMapIds(this.getParameter("operFromRangeMapIds", ""));
            item.setOperToRangeMapIds(this.getParameter("operToRangeMapIds", ""));
            item.setOperNotFromRangeMapIds(this.getParameter("operNotFromRangeMapIds", ""));
            item.setOperNotToRangeMapIds(this.getParameter("operNotToRangeMapIds", ""));
        }
        boolean strictCheck = this.moduleSetup.getInt("point.resource.strict.check", 0) > 0;
        man.realUpdate(this.userId, item, strictCheck, this.context, true);
        this.rootNode.setAttribute("id", String.valueOf(item.getId()));
    }

    private boolean checkRange(String range, String rangeName) throws BGException {
        try {
            new RangeParser(range);
        }
        catch (BGException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 '" + rangeName + "' [" + e.toString() + "] ");
        }
        return true;
    }
}

