/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftPayment;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class RentsoftPaymentManager
extends AbstractIdDao<RentsoftPayment> {
    private static final Logger logger = LogManager.getLogger();
    private int serviceId = 0;

    public RentsoftPaymentManager(Connection con, int moduleId) throws BGException {
        super(con, moduleId, "rentsoft_payment");
        this.setServiceId();
    }

    private void setServiceId() throws BGException {
        try {
            String query = "SELECT id FROM service WHERE mid=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, this.moduleId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                this.serviceId = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<RentsoftPayment> getPaymentList(int productId, int cid) throws BGException {
        return this.list("product_id=? AND cid=?", "date DESC", new Object[]{productId, cid});
    }

    protected void updateImpl(RentsoftPayment rentsoftPayment) throws BGException, SQLException {
        PreparedStatement ps = null;
        String query = (rentsoftPayment.getId() <= 0 ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET txid=?, date=?, cid=?, comment=?, amount=?, status=?, product_id=?" + (rentsoftPayment.getId() <= 0 ? "" : " WHERE id=?");
        ps = this.con.prepareStatement(query, 1);
        ps.setString(1, rentsoftPayment.getTxid());
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)rentsoftPayment.getDate()));
        ps.setInt(3, rentsoftPayment.getContractId());
        ps.setString(4, rentsoftPayment.getComment());
        ps.setBigDecimal(5, rentsoftPayment.getAmount());
        ps.setInt(6, rentsoftPayment.getStatus());
        ps.setInt(7, rentsoftPayment.getProductId());
        if (rentsoftPayment.getId() > 0) {
            ps.setInt(8, rentsoftPayment.getId());
        }
        ps.executeUpdate();
        if (rentsoftPayment.getId() <= 0) {
            rentsoftPayment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    protected RentsoftPayment getFromRS(ResultSet rs) throws SQLException, BGException {
        RentsoftPayment payment = new RentsoftPayment();
        payment.setAmount(rs.getBigDecimal("amount"));
        payment.setComment(rs.getString("comment"));
        payment.setContractId(rs.getInt("cid"));
        payment.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
        payment.setId(rs.getInt("id"));
        payment.setProductId(rs.getInt("product_id"));
        payment.setStatus(rs.getInt("status"));
        payment.setTxid(rs.getString("txid"));
        return payment;
    }

    public RentsoftPayment getByTxid(String txid) throws BGException {
        RentsoftPayment result = null;
        try {
            result = (RentsoftPayment)this.get("txid=?", new Object[]{txid});
        }
        catch (BGException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public boolean isTxidExists(String txid) throws BGException {
        try {
            String query = "SELECT id FROM " + this.tableName + " WHERE txid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, txid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                rs.close();
                ps.close();
                return true;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public boolean checkCid(int contractId) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT c.id FROM contract AS c LEFT JOIN contract_module AS cm ON cm.cid=c.id WHERE c.id=? AND cm.mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, this.moduleId);
            ResultSet rs = ps.executeQuery();
            result = rs.next();
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public boolean isEnoughMoney(int contractId, BigDecimal amount) throws BGException {
        boolean isEnoughMoney;
        Contract contract = null;
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            contract = (Contract)contractDao.get(contractId);
            if (contract == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Contract is null [ID#" + contractId + "], return False");
                }
                boolean bl = false;
                return bl;
            }
        }
        byte contractStatus = contract.getStatus();
        boolean isModuleActiveStatus = StatusCache.getInstance().isModuleActiveStatus(this.moduleId, (int)contractStatus);
        if (!isModuleActiveStatus) {
            if (logger.isDebugEnabled()) {
                logger.debug("contractStatus=" + contractStatus + "; moduleId=" + this.moduleId + "; isModuleActiveStatus=" + isModuleActiveStatus + ", return False");
            }
            return false;
        }
        BalanceUtils balanceUtils = new BalanceUtils(this.con);
        BigDecimal balance = balanceUtils.getBalance(LocalDate.now(), contractId);
        balanceUtils.close();
        byte balanceMode = contract.getBalanceMode();
        if (logger.isDebugEnabled()) {
            logger.debug("Contract balance=" + balance.toPlainString());
            logger.debug("Contract balanceMode=" + balanceMode);
        }
        if (balanceMode == 1) {
            BigDecimal balanceLimit = contract.getBalanceLimit();
            balance = balance.subtract(balanceLimit);
            if (logger.isDebugEnabled()) {
                logger.debug("Contract balanceLimit=" + balanceLimit);
                logger.debug("Contract balance=" + balance.toPlainString());
            }
        }
        boolean bl = isEnoughMoney = balance.compareTo(amount) >= 0;
        if (logger.isDebugEnabled()) {
            logger.debug("Amount=" + amount);
            logger.debug("Contract isEnoughMoney=" + isEnoughMoney);
        }
        return isEnoughMoney;
    }

    public boolean billUser(RentsoftPayment payment, boolean revert) throws BGException {
        boolean bl;
        BalanceUtils bu = new BalanceUtils(this.con);
        try {
            this.update(payment);
            bu.addContractAccount(payment.getContractId(), TimeUtils.convertDateToLocalDate((Date)payment.getDate()), this.serviceId, payment.getAmount().multiply(new BigDecimal(revert ? -1 : 1)));
            bu.updateBalance(payment.getDate(), payment.getContractId());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bu.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException ex) {
                throw new BGException(ex.getMessage(), (Throwable)ex);
            }
        }
        bu.close();
        return bl;
    }

    public boolean recalculateUser(int contractId, Date date) throws BGException {
        boolean bl;
        StringBuilder sb = new StringBuilder().append("SELECT SUM(amount) FROM ").append(this.tableName).append(" WHERE cid=? AND YEAR(date) = YEAR(?) AND MONTH(date) = MONTH(?) GROUP BY cid");
        BalanceUtils bu = new BalanceUtils(this.con);
        try {
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, contractId);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)date));
            LocalDate localDate = TimeUtils.convertDateToLocalDate((Date)date);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                bu.setContractAccount(contractId, localDate, this.serviceId, rs.getBigDecimal(1));
            } else {
                bu.setContractAccount(contractId, localDate, this.serviceId, BigDecimal.ZERO);
            }
            rs.close();
            ps.close();
            bu.updateBalance(date, contractId);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bu.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        bu.close();
        return bl;
    }

    public String getCurrentBalance(int contractId) {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            String string = new DecimalFormat("0").format(bu.getBalance(LocalDate.now(), contractId));
            return string;
        }
    }

    public String getTariffIds(int contractId) throws BGException {
        try {
            String query = "SELECT tpid FROM contract_tariff WHERE cid=? AND ( date1 IS NULL OR date1 <= CURDATE() ) AND ( date2 IS NULL OR date2 >= CURDATE() )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            Object ids = "";
            while (rs.next()) {
                ids = (String)("".equals(ids) ? "" : (String)ids + " ") + rs.getInt(1);
            }
            rs.close();
            ps.close();
            return ids;
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean getIsJuridical(int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            boolean bl = ((Contract)contractDao.get(contractId)).getPersonType() == 1;
            return bl;
        }
    }

    public boolean getIsPostpaid(int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            boolean bl = ((Contract)contractDao.get(contractId)).getBalanceMode() == 1;
            return bl;
        }
    }

    public boolean areChargesAllowedToCid(int contractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            Contract c = (Contract)contractDao.get(contractId);
            boolean bl = c != null && (c.getPersonType() == 0 || RentsoftPaymentManager.containsRentsoftName(c));
            return bl;
        }
    }

    public List<String> getUuidsByTariff(int tid) throws BGException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String query = "SELECT c.id FROM contract as c INNER JOIN contract_module AS cm ON c.id=cm.cid INNER JOIN contract_tariff AS ct ON c.id=ct.cid WHERE ct.tpid=? AND cm.mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, tid);
            ps.setInt(2, this.moduleId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ids.add(this.cidToUuid(rs.getInt(1)));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return ids;
    }

    public void deleteForContract(int cid) throws BGException {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
    }

    public int uuidToCid(String uuid) {
        Matcher m = Pattern.compile("(.*):juridical").matcher(uuid);
        if (m.matches()) {
            return Utils.parseInt((String)m.group(1));
        }
        return Utils.parseInt((String)uuid);
    }

    public String cidToUuid(int ccontractId) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            Contract c = (Contract)contractDao.get(ccontractId);
            if (c.getPersonType() == 1 && c.getSuperCid() != 0 && RentsoftPaymentManager.containsRentsoftName(c)) {
                c = (Contract)contractDao.get(c.getSuperCid());
            }
            String string = c.getPersonType() == 0 ? "" + c.getId() : c.getId() + ":juridical";
            return string;
        }
    }

    public int getCidToCharge(int parentContractId) throws BGException {
        int result;
        block8: {
            result = 0;
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Contract parent = (Contract)contractDao.get(parentContractId);
                if (parent == null) {
                    result = 0;
                    break block8;
                }
                if (parent.getPersonType() == 0 || RentsoftPaymentManager.containsRentsoftName(parent)) {
                    result = parent.getId();
                    break block8;
                }
                List subContracts = contractDao.getSubContracts(parent.getId(), -1);
                for (Contract child : subContracts) {
                    if (!RentsoftPaymentManager.containsRentsoftName(child)) continue;
                    result = child.getId();
                    break;
                }
            }
        }
        return result;
    }

    private static boolean containsRentsoftName(Contract c) {
        return RentsoftPaymentManager.containsRentsoftName(c.getComment()) || RentsoftPaymentManager.containsRentsoftName(c.getTitle());
    }

    private static boolean containsRentsoftName(String text) {
        return text.matches("(?i).*(rentsoft|rensoft).*");
    }
}

