/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftPayment;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftProduct;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.SubscribtionStatus;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftPaymentManager;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftProductManager;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftRequestEntry;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.SubscribtionStatusManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebServlet(name="RentsoftApi", urlPatterns={"/rentsoft_api/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String ERROR_OK = "OK";
    private static final String ERROR_USER_UNKNOWN_UUID = "USER_UNKNOWN_UUID";
    private static final String ERROR_USER_NO_MONEY = "USER_NO_MONEY";
    private static final String ERROR_USER_DUPLICATE_TXID = "USER_DUPLICATE_TXID";
    private static final String ERROR_USER_UNKNOWN_TXID = "USER_UNKNOWN_TXID";
    private static final Pattern slashPattern = Pattern.compile("/");

    public void init() {
        this.setup = Setup.getSetup();
        System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
    }

    private String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        Connection con = null;
        try {
            con = this.setup.getDBConnectionFromPool();
            response.setContentType("text/plain");
            out = response.getWriter();
            String method = this.getParameter(request, "method", "none");
            String key = this.getParameter(request, "apikey", "none");
            int moduleId = 0;
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                String[] params = slashPattern.split(pathInfo);
                switch (params.length) {
                    default: {
                        moduleId = Utils.parseInt((String)params[1], (int)0);
                        break;
                    }
                    case 0: 
                    case 1: {
                        moduleId = 0;
                    }
                }
            }
            if (moduleId <= 0) {
                out.write("Invalid URL: mid missing!");
                return;
            }
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(moduleId));
            if (key == null) {
                out.write("Invalid key in request!");
                return;
            }
            if (!key.equals(moduleSetup.get("rentsoft.secret", "undefined"))) {
                out.write("Invalid apikey!");
                return;
            }
            RentsoftProductManager productManager = new RentsoftProductManager(con, moduleId);
            RentsoftPaymentManager rentsoftPaymentManager = new RentsoftPaymentManager(con, moduleId);
            Map<Integer, RentsoftRequestEntry> entries = this.readEntries(request);
            if ("getUserInfo".equals(method)) {
                this.getUserInfo(request, out, moduleSetup, entries, rentsoftPaymentManager);
            } else if ("getUserInfoByTariff".equals(method)) {
                this.getUserInfoByTariff(request, out, moduleSetup, entries, rentsoftPaymentManager);
            } else if ("canCharge".equals(method)) {
                this.charge(request, out, entries, rentsoftPaymentManager, productManager, true);
            } else if ("charge".equals(method)) {
                this.charge(request, out, entries, rentsoftPaymentManager, productManager, false);
            } else if ("uncharge".equals(method)) {
                this.uncharge(request, out, entries, rentsoftPaymentManager);
            } else if ("notifyStatusChange".equals(method)) {
                SubscribtionStatusManager ssm = new SubscribtionStatusManager(con, moduleId);
                this.notifyStatusChange(request, out, entries, rentsoftPaymentManager, productManager, ssm);
            } else {
                out.write("Invalid or unimplemented method!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void notifyStatusChange(HttpServletRequest request, PrintWriter out, Map<Integer, RentsoftRequestEntry> entries, RentsoftPaymentManager rentsoftPaymentManager, RentsoftProductManager productManager, SubscribtionStatusManager ssm) throws BGException {
        for (Map.Entry<Integer, RentsoftRequestEntry> entry : entries.entrySet()) {
            int id = entry.getKey();
            RentsoftRequestEntry rentsoftRequestEntry = entry.getValue();
            int cidParent = rentsoftPaymentManager.uuidToCid(rentsoftRequestEntry.getUuid());
            int cidCharge = rentsoftPaymentManager.getCidToCharge(cidParent);
            this.write(out, "debugCidToCharge", id, cidCharge);
            if (rentsoftPaymentManager.checkCid(cidParent)) {
                SubscribtionStatus subscribtionStatus = new SubscribtionStatus();
                subscribtionStatus.setContractId(cidCharge != 0 ? cidCharge : cidParent);
                RentsoftProduct product = productManager.getByServiceKey(rentsoftRequestEntry.getServiceKey());
                if (product == null) {
                    product = new RentsoftProduct();
                    product.setServiceKey(rentsoftRequestEntry.getServiceKey());
                    product.setServiceName(rentsoftRequestEntry.getServiceName());
                    productManager.safeUpdate(product);
                }
                subscribtionStatus.setProductId(product.getId());
                subscribtionStatus.setStatus(rentsoftRequestEntry.getStatus());
                ssm.updateStatus(subscribtionStatus);
                this.write(out, "txid", id, rentsoftRequestEntry.getTxid());
                this.write(out, "error", id, ERROR_OK);
                continue;
            }
            this.write(out, "txid", id, rentsoftRequestEntry.getTxid());
            this.write(out, "error", id, ERROR_USER_UNKNOWN_UUID);
        }
    }

    private void getUserInfo(HttpServletRequest request, PrintWriter out, ModuleSetup setup, Map<Integer, RentsoftRequestEntry> entries, RentsoftPaymentManager rpm) throws BGException {
        for (Map.Entry<Integer, RentsoftRequestEntry> entry : entries.entrySet()) {
            int id = entry.getKey();
            RentsoftRequestEntry rentsoftRequestEntry = entry.getValue();
            this.writeUserInfo(out, setup, rpm, id, rentsoftRequestEntry.getUuid());
        }
    }

    private void getUserInfoByTariff(HttpServletRequest request, PrintWriter out, ModuleSetup setup, Map<Integer, RentsoftRequestEntry> entries, RentsoftPaymentManager rpm) throws BGException {
        int id = 0;
        for (Map.Entry<Integer, RentsoftRequestEntry> entry : entries.entrySet()) {
            RentsoftRequestEntry rre = entry.getValue();
            for (String uuid : rpm.getUuidsByTariff(rre.getTariffId())) {
                this.writeUserInfo(out, setup, rpm, id, uuid);
                ++id;
            }
        }
    }

    private void writeUserInfo(PrintWriter out, ModuleSetup setup, RentsoftPaymentManager rentsoftPaymentManager, int id, String uuid) throws BGException {
        int periodStartDay = setup.getInt("period.start.day", 1);
        this.write(out, "uuid", id, uuid);
        this.write(out, "periodStartDay", id, periodStartDay);
        GregorianCalendar calendar = new GregorianCalendar();
        this.write(out, "timeShift", id, (calendar.get(15) + calendar.get(16)) / 3600000);
        int cidParent = rentsoftPaymentManager.uuidToCid(uuid);
        int cidCharge = rentsoftPaymentManager.getCidToCharge(cidParent);
        this.write(out, "debugCidToCharge", id, cidCharge);
        if (rentsoftPaymentManager.checkCid(cidParent)) {
            this.write(out, "isJuridical", id, rentsoftPaymentManager.getIsJuridical(cidParent) ? "1" : "0");
            this.write(out, "isPostpaid", id, rentsoftPaymentManager.getIsPostpaid(cidCharge != 0 ? cidCharge : cidParent) ? "1" : "0");
            this.write(out, "amount", id, cidCharge != 0 ? rentsoftPaymentManager.getCurrentBalance(cidCharge) : "0");
            this.write(out, "tariffId", id, rentsoftPaymentManager.getTariffIds(cidParent));
            this.write(out, "error", id, ERROR_OK);
        } else {
            this.write(out, "error", id, ERROR_USER_UNKNOWN_UUID);
        }
    }

    private void uncharge(HttpServletRequest request, PrintWriter out, Map<Integer, RentsoftRequestEntry> entries, RentsoftPaymentManager rpm) throws BGException {
        for (Map.Entry<Integer, RentsoftRequestEntry> entry : entries.entrySet()) {
            int id = entry.getKey();
            RentsoftRequestEntry rre = entry.getValue();
            RentsoftPayment payment = rpm.getByTxid(rre.getTxid());
            this.write(out, "txid", id, rre.getTxid());
            if (payment == null || payment.getStatus() == 1) {
                this.write(out, "error", id, ERROR_USER_UNKNOWN_TXID);
                continue;
            }
            payment.setDate(new Date());
            payment.setStatus(1);
            rpm.billUser(payment, true);
            this.write(out, "error", id, ERROR_OK);
        }
    }

    private void charge(HttpServletRequest request, PrintWriter out, Map<Integer, RentsoftRequestEntry> entries, RentsoftPaymentManager rentsoftPaymentManager, RentsoftProductManager productManager, boolean checkOnly) throws BGException {
        for (Map.Entry<Integer, RentsoftRequestEntry> entry : entries.entrySet()) {
            int id = entry.getKey();
            RentsoftRequestEntry rentsoftRequestEntry = entry.getValue();
            this.write(out, "txid", id, rentsoftRequestEntry.getTxid());
            int cidParent = rentsoftPaymentManager.uuidToCid(rentsoftRequestEntry.getUuid());
            int cidCharge = rentsoftPaymentManager.getCidToCharge(cidParent);
            this.write(out, "debugCidToCharge", id, cidCharge);
            if (!rentsoftPaymentManager.checkCid(cidParent)) {
                this.write(out, "error", id, ERROR_USER_UNKNOWN_UUID);
                continue;
            }
            if (!rentsoftPaymentManager.isEnoughMoney(cidCharge, rentsoftRequestEntry.getAmount())) {
                this.write(out, "error", id, ERROR_USER_NO_MONEY);
                continue;
            }
            if (rentsoftPaymentManager.isTxidExists(rentsoftRequestEntry.getTxid())) {
                this.write(out, "error", id, ERROR_USER_DUPLICATE_TXID);
                continue;
            }
            if (!checkOnly) {
                RentsoftProduct product = productManager.getByServiceKey(rentsoftRequestEntry.getServiceKey());
                if (product == null) {
                    product = new RentsoftProduct();
                    product.setServiceKey(rentsoftRequestEntry.getServiceKey());
                    product.setServiceName(rentsoftRequestEntry.getServiceName());
                    productManager.safeUpdate(product);
                }
                RentsoftPayment payment = new RentsoftPayment();
                payment.setAmount(rentsoftRequestEntry.getAmount());
                payment.setContractId(cidCharge);
                payment.setComment(rentsoftRequestEntry.getComment());
                payment.setDate(new Date());
                payment.setStatus(0);
                payment.setTxid(rentsoftRequestEntry.getTxid());
                payment.setProductId(product.getId());
                if (!rentsoftPaymentManager.billUser(payment, false)) continue;
                this.write(out, "error", id, ERROR_OK);
                continue;
            }
            this.write(out, "error", id, ERROR_OK);
        }
    }

    private Map<Integer, RentsoftRequestEntry> readEntries(HttpServletRequest request) {
        HashMap<Integer, RentsoftRequestEntry> result = new HashMap<Integer, RentsoftRequestEntry>();
        Pattern p = Pattern.compile("(\\D+)(\\d+)");
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String paramName = (String)enumeration.nextElement();
            Matcher m = p.matcher(paramName);
            if (!m.find()) continue;
            int num = Utils.parseInt((String)m.group(2));
            RentsoftRequestEntry rentsoftRequestEntry = (RentsoftRequestEntry)result.get(num);
            if (rentsoftRequestEntry == null) {
                rentsoftRequestEntry = new RentsoftRequestEntry();
                result.put(num, rentsoftRequestEntry);
            }
            String value = request.getParameter(m.group());
            if ("uuid".equals(m.group(1))) {
                rentsoftRequestEntry.setUuid(value);
                continue;
            }
            if ("txid".equals(m.group(1))) {
                rentsoftRequestEntry.setTxid(value);
                continue;
            }
            if ("amount".equals(m.group(1))) {
                rentsoftRequestEntry.setAmount(Utils.parseBigDecimal((String)value, (BigDecimal)BigDecimal.ZERO));
                continue;
            }
            if ("comment".equals(m.group(1))) {
                rentsoftRequestEntry.setComment(value);
                continue;
            }
            if ("serviceKey".equals(m.group(1))) {
                rentsoftRequestEntry.setServiceKey(value);
                continue;
            }
            if ("serviceName".equals(m.group(1))) {
                rentsoftRequestEntry.setServiceName(value);
                continue;
            }
            if ("subId".equals(m.group(1))) {
                rentsoftRequestEntry.setSubId(Utils.parseInt((String)value));
                continue;
            }
            if ("periodEnd".equals(m.group(1))) {
                rentsoftRequestEntry.setPeriodEnd(TimeUtils.parseDate((String)value, (String)"yyyy-MM-dd"));
                continue;
            }
            if ("status".equals(m.group(1))) {
                if (SubscribtionStatus.Status.ACTIVE.getRequestValue().equals(value)) {
                    rentsoftRequestEntry.setStatus(SubscribtionStatus.Status.ACTIVE.getCode());
                    continue;
                }
                if (SubscribtionStatus.Status.LOCK_FINANCE.getRequestValue().equals(value)) {
                    rentsoftRequestEntry.setStatus(SubscribtionStatus.Status.LOCK_FINANCE.getCode());
                    continue;
                }
                if (SubscribtionStatus.Status.LOCK_VOLUNTARY.getRequestValue().equals(value)) {
                    rentsoftRequestEntry.setStatus(SubscribtionStatus.Status.LOCK_VOLUNTARY.getCode());
                    continue;
                }
                if (SubscribtionStatus.Status.TEST.getRequestValue().equals(value)) {
                    rentsoftRequestEntry.setStatus(SubscribtionStatus.Status.TEST.getCode());
                    continue;
                }
                if (!SubscribtionStatus.Status.DELETED.getRequestValue().equals(value)) continue;
                rentsoftRequestEntry.setStatus(SubscribtionStatus.Status.DELETED.getCode());
                continue;
            }
            if (!"tariffId".equals(m.group(1))) continue;
            rentsoftRequestEntry.setTariffId(Utils.parseInt((String)value));
        }
        return result;
    }

    private void write(PrintWriter out, String key, int num, Object value) {
        out.write(key + num + "=" + value + "\n");
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("(\\D+)(\\d+)");
        Matcher m = p.matcher("serviceName0345");
        System.out.println(m.find());
        System.out.println(m.group());
        System.out.println(m.group(1));
        System.out.println(m.group(2));
    }
}

