/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.rscm.client.RSCMUtils;
import ru.bitel.bgbilling.modules.rscm.common.service.RSCMService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class ServiceConfigServices
extends BGUTabPanel {
    private BGUTable table = null;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private TableModel tableModel = new TableModel(ServiceConfigServices.class.getName());

    public void jbInit() {
        this.table = new BGUTable((javax.swing.table.TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    ServiceConfigServices.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult searchResult = ((RSCMService)((ClientContext)this.getContext()).getPort(RSCMService.class)).searchRSCMService(this.table.getSort(), this.pagePanel.getPage());
            this.tableModel.setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new RSCMServiceParameterEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", new ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.tableModel, RSCMServiceParameterEditor.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService rscmService = (ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.tableModel.getSelectedRow();
            if (rscmService != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                try {
                    ((RSCMService)((ClientContext)this.getContext()).getPort(RSCMService.class)).deleteRSCMService(rscmService.getId());
                    this.performAction("refresh");
                }
                catch (BGException ex) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage());
                }
            }
        });
    }

    class TableModel
    extends BGTableModel<ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService> {
        static final String COLUMN_ID = "id";
        static final String COLUMN_UNIT = "unit";
        static final String COLUMN_INSTALLMENT_DATA = "installmentData";
        static final String COLUMN_SERVICE_TITLE = "serviceTitle";

        public TableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 80, 300, 500, COLUMN_SERVICE_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430 (\u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0432 \u0447\u0430\u0441\u0442\u044f\u0445)", 400, 600, -1, COLUMN_INSTALLMENT_DATA, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f", 80, 150, 200, COLUMN_UNIT, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService rscmService, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if (COLUMN_INSTALLMENT_DATA.equals(identifier)) {
                if (rscmService.getInstallmentData() != null) {
                    return RSCMUtils.getInstallmentDescription(new JSONObject(rscmService.getInstallmentData()));
                }
                return "";
            }
            return super.getValue((Object)rscmService, column);
        }
    }

    public class RSCMServiceParameterEditor
    extends BGEditorDialog<ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService> {
        private BGTextField unit;
        private BGComboBox<IdTitle> service;
        private BGComboBox<KeyValue> paymentMode;
        private JCheckBox installmentFlag;
        private BGTextField payments;
        private BGTextField parts;
        private JTextArea samples;
        private KeyValue[] paymentModes;

        public RSCMServiceParameterEditor(String title, ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService data) {
            super(title, (Object)data);
            this.unit = new BGTextField(10);
            this.service = new BGComboBox();
            this.paymentMode = new BGComboBox();
            this.installmentFlag = new JCheckBox();
            this.payments = new BGTextField(10);
            this.parts = new BGTextField(5);
            this.samples = new JTextArea(4, 30);
            this.paymentModes = new KeyValue[]{new KeyValue("day", "\u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e"), new KeyValue("week", "\u0435\u0436\u0435\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u043e"), new KeyValue("month", "\u0435\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u043e"), new KeyValue("monthFirst", "\u0435\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u043e (\u043f\u0435\u0440\u0432\u044b\u0439 \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430)"), new KeyValue("monthLast", "\u0435\u0436\u0435\u043c\u0435\u0441\u044f\u0447\u043d\u043e (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430)"), new KeyValue("quarter", "\u0435\u0436\u0435\u043a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u043e"), new KeyValue("year", "\u0435\u0436\u0435\u0433\u043e\u0434\u043d\u043e")};
        }

        public void doDialogPanel() {
            block8: {
                this.installmentFlag.setSelected(false);
                this.service.setPreferredSize(new Dimension(400, 24));
                this.unit.setHorizontalAlignment(0);
                this.parts.setHorizontalAlignment(0);
                Dimension dimension = new Dimension(350, 80);
                JScrollPane pane = new JScrollPane(this.samples);
                pane.setMinimumSize(dimension);
                pane.setPreferredSize(dimension);
                this.samples.setMargin(new Insets(5, 5, 5, 5));
                this.samples.setEditable(false);
                this.samples.setText("\u041f\u0440\u0438\u043c\u0435\u0440\u044b \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0432\u0437\u043d\u043e\u0441\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u044f\u0445 (\u0441\u0443\u043c\u043c\u0430 \u0447\u0430\u0441\u0442\u0435\u0439 \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0434\u043e\u043b\u0436\u043d\u0430 = \u0432\u0441\u0435\u0433\u043e \u0447\u0430\u0441\u0442\u0435\u0439):\n*/10 - \u0440\u0430\u0432\u043d\u044b\u043c\u0438 \u0434\u043e\u043b\u044f\u043c\u0438 10 \u043c\u0435\u0441\u044f\u0446\u0435\u0432\n50;35;15 - \u0442\u0440\u0438 \u043c\u0435\u0441\u044f\u0446\u0430: 50 \u0447\u0430\u0441\u0442\u0435\u0439 \u0432 \u043f\u0435\u0440\u0432\u044b\u0439, \u0434\u0430\u043b\u0435\u0435 35 \u0438 15\n0;*/10 - \u043f\u0435\u0440\u0432\u044b\u0439 \u043c\u0435\u0441\u044f\u0446 0, \u0434\u0430\u043b\u0435\u0435 10 \u043c\u0435\u0441\u044f\u0446\u0435\u0432 \u0440\u0430\u0432\u043d\u044b\u043c\u0438 \u0434\u043e\u043b\u044f\u043c\u0438");
                int gridy = 0;
                this.panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.service, new GridBagConstraints(1, gridy++, 1, 1, 0.7, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
                this.panel.add((Component)new JLabel("\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.unit, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
                this.panel.add((Component)new JLabel("\u041e\u043f\u043b\u0430\u0442\u0430 \u0432 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.installmentFlag, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)new JLabel("\u0412\u0437\u043d\u043e\u0441\u044b \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0432 \u0447\u0430\u0441\u0442\u044f\u0445:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.getPaymentPanel(), new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)new JLabel("\u0413\u0440\u0430\u0444\u0438\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add((Component)this.paymentMode, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
                this.panel.add((Component)pane, new GridBagConstraints(0, gridy++, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
                this.panel.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
                try {
                    JSONArray paymentsArray;
                    DefaultComboBoxModel<IdTitle> model = null;
                    if (((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getId() > 0) {
                        IdTitle item = new IdTitle(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getServiceId(), ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getServiceTitle());
                        model = new DefaultComboBoxModel<IdTitle>(new IdTitle[]{item});
                    } else {
                        IdTitle defaultItem = new IdTitle(-1, "-- \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443 --");
                        model = new DefaultComboBoxModel<IdTitle>(new IdTitle[]{defaultItem});
                        for (IdTitle listItem : ((RSCMService)((ClientContext)ServiceConfigServices.this.getContext()).getPort(RSCMService.class)).getRSCMServiceList()) {
                            model.addElement(new IdTitle(listItem.getId(), listItem.getTitle()));
                        }
                    }
                    this.service.setModel(model);
                    this.service.setEnabled(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getId() == 0);
                    this.service.setSelectedIndex(0);
                    this.paymentMode.setModel(new DefaultComboBoxModel<KeyValue>(this.paymentModes));
                    this.paymentMode.setSelectedIndex(2);
                    this.unit.setText(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getUnit());
                    if (((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getInstallmentData() == null) break block8;
                    this.installmentFlag.setSelected(true);
                    JSONObject jsonObject = new JSONObject(((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).getInstallmentData());
                    this.payments.setText(jsonObject.optString("payments"));
                    int partsInt = jsonObject.optInt("parts");
                    this.parts.setText(partsInt > 0 ? String.valueOf(partsInt) : "");
                    if (Utils.isBlankString((String)this.parts.getText()) && (paymentsArray = jsonObject.optJSONArray("paymentsArray")) != null) {
                        BigDecimal sum = BigDecimal.ZERO;
                        int len = paymentsArray.length();
                        for (int index = 0; index < len; ++index) {
                            sum = sum.add(new BigDecimal(paymentsArray.getInt(index)));
                        }
                        this.parts.setText(sum.toPlainString());
                    }
                    String mode = jsonObject.optString("paymentMode", "month");
                    for (int index = 0; index < this.paymentModes.length; ++index) {
                        if (!this.paymentModes[index].getKey().equals(mode)) continue;
                        this.paymentMode.setSelectedIndex(index);
                        break;
                    }
                }
                catch (BGException ex) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getLocalizedMessage());
                }
            }
        }

        private JPanel getPaymentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.payments, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new JLabel(" \u0432\u0441\u0435\u0433\u043e \u0447\u0430\u0441\u0442\u0435\u0439:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.parts, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            if (Utils.isEmptyString((String)this.unit.getText().trim())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \"\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f\"!");
                return false;
            }
            IdTitle item = (IdTitle)this.service.getSelectedItem();
            if (item.getId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return false;
            }
            JSONObject jsonObject = null;
            if (this.installmentFlag.isSelected()) {
                int partsInt = Utils.parseInt((String)this.parts.getText());
                if (partsInt < 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432\u0441\u0435\u0433\u043e \u0447\u0430\u0441\u0442\u0435\u0439 (\u0446\u0435\u043b\u043e\u0435 > 0)!");
                    return false;
                }
                jsonObject = new JSONObject();
                String value = this.payments.getText().trim();
                String error = null;
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                if (!value.isEmpty() && (error = this.checkPayments(list, value, partsInt)) != null) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"\u0412\u0437\u043d\u043e\u0441\u044b \u043f\u043e \u043c\u0435\u0441\u044f\u0446\u0430\u043c \u0432 \u0447\u0430\u0441\u0442\u044f\u0445\"\n\n" + error));
                    return false;
                }
                JSONArray paymentsArray = new JSONArray();
                list.forEach(e -> paymentsArray.put(e));
                jsonObject.put("paymentsArray", (Object)paymentsArray);
                jsonObject.put("payments", (Object)value);
                jsonObject.put("parts", partsInt);
                jsonObject.put("paymentMode", (Object)((KeyValue)this.paymentMode.getSelectedItem()).getKey());
            }
            ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).setServiceId(item.getId());
            ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).setUnit(this.unit.getText());
            ((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data).setInstallmentData(this.installmentFlag.isSelected() ? jsonObject.toString() : null);
            try {
                ((RSCMService)((ClientContext)ServiceConfigServices.this.getContext()).getPort(RSCMService.class)).updateRSCMService((ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService)this.data);
                ServiceConfigServices.this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            return true;
        }

        private String checkPayments(List<BigDecimal> list, String text, int parts) {
            Object error = null;
            BigDecimal partsBigDecimal = new BigDecimal(parts);
            for (String s : text.split(";")) {
                if (!(s = s.trim()).matches("^(\\d{1,2}|\\*\\/\\d+)$")) {
                    error = s;
                    break;
                }
                if (s.matches("^\\d+$")) {
                    list.add(new BigDecimal(s));
                    continue;
                }
                if (!s.matches("^\\*\\/\\d+$")) continue;
                BigDecimal sum = BigDecimal.ZERO;
                for (BigDecimal b : list) {
                    sum = sum.add(b);
                }
                int d = Utils.parseInt((String)s.substring(2));
                BigDecimal v = partsBigDecimal.subtract(sum).divide(new BigDecimal(d), 0, RoundingMode.HALF_UP);
                if (v.compareTo(BigDecimal.ZERO) <= 0) continue;
                for (int i = 0; i < d; ++i) {
                    list.add(v);
                }
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (BigDecimal b : list) {
                sum = sum.add(b);
            }
            if (sum.compareTo(partsBigDecimal) != 0) {
                error = "(\u0441\u0443\u043c\u043c\u0430 \u0447\u0430\u0441\u0442\u0435\u0439 = " + sum + ") != " + partsBigDecimal;
            }
            return error;
        }
    }
}

