/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostGroupDao
extends AbstractDao<ForpostGroup> {
    private final String TABLE_FORPOST_ACCOUNT;
    private final String TABLE_FORPOST_ACCOUNT_CONTRACT;

    public ForpostGroupDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_group");
        this.TABLE_FORPOST_ACCOUNT = "smarthouse_forpost_account_" + moduleId;
        this.TABLE_FORPOST_ACCOUNT_CONTRACT = "smarthouse_forpost_account_contract_" + moduleId;
    }

    protected ForpostGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        ForpostGroup result = new ForpostGroup();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setAccountId(rs.getInt("account_id"));
        result.setParentId(rs.getInt("parent_id"));
        result.setData(rs.getString("data"));
        return result;
    }

    protected void updateImpl(ForpostGroup forpostGroup) throws BGException, SQLException {
        if (forpostGroup != null) {
            try {
                int parameterIndex = 1;
                String sqlSet = "account_id=?, name=?, parent_id=?, data=?";
                PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlSet + " ON DUPLICATE KEY UPDATE " + sqlSet);
                ps.setInt(parameterIndex++, forpostGroup.getId());
                ps.setInt(parameterIndex++, forpostGroup.getAccountId());
                ps.setString(parameterIndex++, forpostGroup.getName());
                ps.setInt(parameterIndex++, forpostGroup.getParentId());
                ps.setString(parameterIndex++, forpostGroup.getData());
                ps.setInt(parameterIndex++, forpostGroup.getAccountId());
                ps.setString(parameterIndex++, forpostGroup.getName());
                ps.setInt(parameterIndex++, forpostGroup.getParentId());
                ps.setString(parameterIndex++, forpostGroup.getData());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public ForpostGroup getForpostGroup(int id) throws BGException {
        try {
            return (ForpostGroup)this.getById(id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostGroups(SearchResult<ForpostTMCAO<ForpostGroup>> searchResult) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS u.*, a.name AS accountName, c.id AS contractId, c.title AS contractTitle FROM " + this.tableName + " AS u LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT + " AS a ON a.id=u.account_id LEFT JOIN " + this.TABLE_FORPOST_ACCOUNT_CONTRACT + " AS ac ON ac.account_id=u.account_id LEFT JOIN contract AS c ON c.id=ac.contract_id " + (page != null ? page.sqlLimit() : ""), 1);){
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ForpostTMCAO tableModelRow = new ForpostTMCAO();
                tableModelRow.setContractId(rs.getInt("contractId"));
                tableModelRow.setContractTitle(rs.getString("contractTitle"));
                tableModelRow.setAccountName(rs.getString("accountName"));
                tableModelRow.setObject((Object)this.getFromRS(rs));
                list.add(tableModelRow);
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(int accountId, ForpostGroup[] groups) throws BGException {
        if (groups == null) {
            return;
        }
        long now = System.currentTimeMillis();
        String sqlField = "account_id=?, name=?, parent_id=?, data=?, sync_datetime=?";
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, " + sqlField + " ON DUPLICATE KEY UPDATE " + sqlField);
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>? AND account_id=?");){
            for (ForpostGroup forpostGroup : groups) {
                int parameterIndex = 1;
                psInsert.setInt(parameterIndex++, forpostGroup.getId());
                psInsert.setInt(parameterIndex++, accountId);
                psInsert.setString(parameterIndex++, forpostGroup.getName());
                psInsert.setInt(parameterIndex++, forpostGroup.getParentId());
                psInsert.setString(parameterIndex++, forpostGroup.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setInt(parameterIndex++, accountId);
                psInsert.setString(parameterIndex++, forpostGroup.getName());
                psInsert.setInt(parameterIndex++, forpostGroup.getParentId());
                psInsert.setString(parameterIndex++, forpostGroup.getData());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            psDelete.setLong(1, now);
            psDelete.setInt(2, accountId);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchForpostAccountGroups(SearchResult<ForpostGroup> searchResult, int accountId) throws BGException {
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + (accountId > 0 ? " WHERE account_id=? " : ""));){
            if (accountId > 0) {
                ps.setInt(1, accountId);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void deleteForpostGroup(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");){
            ps.setInt(1, id);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

