/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractTitlePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableEditorType;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableRow;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostEditorDialog;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTable;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCamera;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraBrand;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostCameraModel;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class ForpostContractCameraPanel
extends ForpostContractBasePanel {
    private CameraTableModel tableModel;
    private ForpostService cameraService = null;
    private Directory<ForpostCameraBrand> cameraBrands = null;

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new ContractTitlePanel("\u041a\u0430\u043c\u0435\u0440\u044b:", (JComponent)((Object)this)), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapScrollPane((JComponent)this.getTable(), (int)300, (int)100), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void deleteAccountCameras(int id) throws BGMessageException, BGException {
        this.getForpostCameraService().deleteForpostAccountCameras(this.accountId);
    }

    @Override
    protected BGTableModel<?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new CameraTableModel(CameraTableModel.class.getName());
        }
        return this.tableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            ForpostCamera forpostCamera = this.getForpostCameraService().getDefaultForpostCamera();
            forpostCamera.setAccountId(this.accountId);
            new ForpostEditorDialog<ForpostCamera>(forpostCamera, "forpost.contractCameraAdd", (ClientContext)this.getContext(), (JPanel)((Object)this)).getDialog().setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            ForpostCamera forpostCamera = (ForpostCamera)((CameraTableModel)this.getTableModel()).getSelectedRow();
            if (forpostCamera == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041a\u0430\u043c\u0435\u0440\u0443\" \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
            } else {
                this.getCameraEditDialog(forpostCamera).setVisible(true);
                this.performAction("camera.refresh");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ForpostCamera forpostCamera = (ForpostCamera)((CameraTableModel)this.getTableModel()).getSelectedRow();
            if (forpostCamera == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041a\u0430\u043c\u0435\u0440\u0443\" \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.");
            } else if (ClientUtils.confirmDelete((Object)forpostCamera.getName())) {
                this.getForpostCameraService().forpostCameraDelete(forpostCamera.getId());
                this.performAction("camera.refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("camera.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", ICON_REFRESH){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((CameraTableModel)ForpostContractCameraPanel.this.getTableModel()).setData(ForpostContractCameraPanel.this.getForpostCameraService().searchForpostAccountCameras(ForpostContractCameraPanel.this.accountId).getList());
            }
        };
    }

    private JDialog getCameraEditDialog(final ForpostCamera forpostCamera) {
        final ForpostParamTableModel paramTableModel = new ForpostParamTableModel();
        CellEditorListener cellEditorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ParamTableRow tableRow = (ParamTableRow)paramTableModel.getSelectedRow();
                try {
                    ForpostContractCameraPanel.this.getForpostCameraService().forpostCameraParamUpdate(forpostCamera.getId(), tableRow.getName(), tableRow.getValue());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        };
        ForpostParamTable paramTable = new ForpostParamTable((TableModel)((Object)paramTableModel), cellEditorListener);
        paramTable.setContext((ClientContext)this.getContext());
        paramTableModel.addRow(new ParamTableRow("Name", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getName()));
        paramTableModel.addRow(new ParamTableRow("AccountObjectID", "\u041e\u0431\u044a\u0435\u043a\u0442", String.valueOf(forpostCamera.getAccountObjectId())));
        paramTableModel.addRow(new ParamTableRow("MasterID", "\u041a\u043b\u0430\u0441\u0442\u0435\u0440", String.valueOf(forpostCamera.getMasterId())));
        paramTableModel.addRow(new ParamTableRow("Login", "\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043a\u0430\u043c\u0435\u0440\u0435", forpostCamera.getLogin()));
        paramTableModel.addRow(new ParamTableRow("Password", "\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u043a\u0430\u043c\u0435\u0440\u0435", forpostCamera.getString("Password")));
        paramTableModel.addRow(new ParamTableRow("IPOrDomain", "IP-\u0430\u0434\u0440\u0435\u0441 \u0438\u043b\u0438 \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0435 \u0438\u043c\u044f (\u0432 \u0442. \u0447. DDNS) \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u043a\u0430\u043c\u0435\u0440\u0435", forpostCamera.getIpOrDomain()));
        paramTableModel.addRow(new ParamTableRow("Port", "\u041f\u043e\u0440\u0442 \u0432\u0438\u0434\u0435\u043e/\u0430\u0443\u0434\u0438\u043e", String.valueOf(forpostCamera.getPort())));
        paramTableModel.addRow(new ParamTableRow("HTTPPort", "\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0449\u0438\u0439 \u043f\u043e\u0440\u0442 (HTTP/ONIF)", forpostCamera.getString("HTTPPort")));
        paramTableModel.addRow(new ParamTableRow("IsSound", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0438 \u0437\u0430\u043f\u0438\u0441\u044c \u0437\u0432\u0443\u043a\u0430", forpostCamera.getString("IsSound"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("RecordType", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0430\u0440\u0445\u0438\u0432", forpostCamera.getString("RecordType")));
        paramTableModel.addRow(new ParamTableRow("MaxBandwidth", "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u0432 \u041a\u0431\u0438\u0442/\u0441 \u0431\u0438\u0442\u0440\u0435\u0439\u0442\u0430 \u043f\u043e\u0442\u043e\u043a\u0430 \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("MaxBandwidth")));
        paramTableModel.addRow(new ParamTableRow("Address", "\u0410\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u043e\u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("Address")));
        paramTableModel.addRow(new ParamTableRow("CameraModelID", "\u041c\u043e\u0434\u0435\u043b\u044c \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("CameraModelID")));
        paramTableModel.addRow(new ParamTableRow("Protocol", "\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("Protocol")));
        paramTableModel.addRow(new ParamTableRow("RtspTransport", "RTSP \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442", forpostCamera.getString("RtspTransport")));
        paramTableModel.addRow(new ParamTableRow("MJPEG", "\u041f\u0443\u0442\u044c \u043a \u043f\u043e\u0442\u043e\u043a\u0443 \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("MJPEG")));
        paramTableModel.addRow(new ParamTableRow("PTZTypeID", "\u0422\u0438\u043f PTZ", forpostCamera.getString("PTZTypeID")));
        paramTableModel.addRow(new ParamTableRow("Quota", "\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0430\u0440\u0445\u0438\u0432\u0430 \u0432 \u0441\u0435\u043a.", forpostCamera.getString("Quota")));
        paramTableModel.addRow(new ParamTableRow("LightCameraBufferEnabled", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0431\u0443\u0444\u0435\u0440\u0438\u0437\u0430\u0446\u0438\u044e \u0434\u043e\u043f. \u043f\u043e\u0442\u043e\u043a\u0430", forpostCamera.getString("LightCameraBufferEnabled"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("IsActive", "\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442/\u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u043a\u0430\u043c\u0435\u0440\u0443", String.valueOf(forpostCamera.getIsActive()), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("SecretKey", "\u041f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043e \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0438 \u043e\u0442 \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("SecretKey"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("SyncCamera", "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u0443\u044e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("SyncCamera"), ParamTableEditorType.ON_OFF));
        paramTableModel.addRow(new ParamTableRow("Channel", "\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u043d\u0430\u043b\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430", forpostCamera.getString("Channel")));
        paramTableModel.addRow(new ParamTableRow("MAC", "MAC-\u0430\u0434\u0440\u0435\u0441 \u043a\u0430\u043c\u0435\u0440\u044b, \u0435\u0441\u043b\u0438 \u043a\u0430\u043c\u0435\u0440\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0440\u0435\u0436\u0438\u043c Plug&Play", forpostCamera.getString("MAC")));
        paramTableModel.addRow(new ParamTableRow("SkipCameraCheck", "\u041d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0442\u044c \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u044c \u043a\u0430\u043c\u0435\u0440\u044b", forpostCamera.getString("SkipCameraCheck"), ParamTableEditorType.ON_OFF));
        int gridy = 0;
        Dimension dimension = new Dimension(900, 450);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)new JScrollPane((Component)((Object)paramTable)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u0430\u043c\u0435\u0440\u044b", new JButton[]{new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")});
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> dialog.setVisible(false));
        return dialog;
    }

    private ForpostService getForpostCameraService() {
        if (this.cameraService == null) {
            this.cameraService = (ForpostService)((ClientContext)this.getContext()).getPort(ForpostService.class);
        }
        return this.cameraService;
    }

    private Directory<ForpostCameraBrand> getForpostCameraBrandDirectory() throws BGException {
        if (this.cameraBrands == null) {
            this.cameraBrands = ((ClientContext)this.getContext()).getDirectory(ForpostCameraBrand.class);
        }
        return this.cameraBrands;
    }

    class CameraTableModel
    extends BGTableModel<ForpostCamera> {
        private Map<String, String> cameraModels;

        public CameraTableModel(String name) {
            super(name);
            this.cameraModels = new HashMap<String, String>();
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", Boolean.class, 80, 80, 80, "isActive", true);
            this.addColumn("\u041c\u043e\u0434\u0435\u043b\u044c \u043a\u0430\u043c\u0435\u0440\u044b", 200, 200, 200, "cameraModelID", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u043c\u0435\u0440\u044b", 100, 200, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 150, 150, 150, "login", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0425\u043e\u0441\u0442:\u043f\u043e\u0440\u0442", 200, 200, 200, "ipOrDomain", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(ForpostCamera forpostCamera, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            Map map = Utils.linesToPairsHash((String)forpostCamera.getData());
            if ("isActive".equals(identifier)) {
                return forpostCamera.getIsActive() == 1;
            }
            if ("ipOrDomain".equals(identifier)) {
                return forpostCamera.getIpOrDomain() + ":" + forpostCamera.getPort();
            }
            if ("login".equals(identifier)) {
                return forpostCamera.getLogin();
            }
            if ("cameraModelID".equals(identifier)) {
                String cameraModelID = (String)map.get("CameraModelID");
                Object cameraModel = this.cameraModels.get(cameraModelID);
                if (cameraModel == null) {
                    int cameraModelId = Utils.parseInt((String)cameraModelID);
                    ForpostCameraModel forpostCameraModel = ForpostContractCameraPanel.this.getForpostService().forpostCameraModelGet(cameraModelId);
                    if (forpostCameraModel != null) {
                        cameraModel = forpostCameraModel.getName();
                        ForpostCameraBrand forpostCameraBrand = (ForpostCameraBrand)ForpostContractCameraPanel.this.getForpostCameraBrandDirectory().get(forpostCameraModel.getBrandId());
                        if (forpostCameraBrand != null) {
                            cameraModel = forpostCameraBrand.getName() + " " + (String)cameraModel;
                        }
                    } else {
                        cameraModel = "???";
                    }
                    this.cameraModels.put(cameraModelID, (String)cameraModel);
                }
                return cameraModel;
            }
            return super.getValueAt((Object)forpostCamera, column);
        }
    }
}

