/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.copy;

import jakarta.xml.ws.BindingProvider;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScriptBase;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceMap;
import ru.bitel.bgbilling.modules.tv.common.event.TvAccountModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.event.access.TvAccountDeviceStateAndOptionsModifiedEvent;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.InvalidParameterException_Exception;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.SubscriberMngFacadeAPI;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.SubscriberMngFacadeAPIService;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.Terminal;
import ru.bitel.bgbilling.modules.tv.server.integration.bcc.telecomtv.ws.subscriber.TerminalArray;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntimeMap;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.PatternStringGenerator;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class TelecomTvTerminalSynchronizingTask
extends GlobalScriptBase {
    private static final Logger logger = LogManager.getLogger();

    public void execute(Setup setup, ConnectionSet connectionSet) throws Exception {
        List moduleList = ModuleCache.getInstance().getModulesList("tv");
        for (BGModule module : moduleList) {
            this.processModule(setup, connectionSet, module.getId());
        }
    }

    private void processModule(Setup setup, ConnectionSet connectionSet, int moduleId) throws Exception {
        logger.info("processModule " + moduleId);
        this.print("processModule " + moduleId);
        ServerContext context = (ServerContext)ServerContext.get();
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
        TvDeviceMap tvDeviceMap = TvDeviceMap.getInstance((int)moduleId);
        TvDeviceService tvDeviceService = (TvDeviceService)context.getService(TvDeviceService.class, moduleId);
        TvAccountService tvAccountService = (TvAccountService)context.getService(TvAccountService.class, moduleId);
        HashMap<Long, TvAccountSpecRuntime> terminalAccountSpecIdMap = new HashMap<Long, TvAccountSpecRuntime>();
        TvAccountSpecRuntimeMap tvAccountSpecRuntimeMap = new TvAccountSpecRuntimeMap(connectionSet.getConnection(), moduleId);
        List tvAccountSpecList = tvAccountService.tvAccountSpecList();
        for (TvAccountSpec tvAccountSpec : tvAccountSpecList) {
            TvAccountSpecRuntime tvAccountSpecRuntime = (TvAccountSpecRuntime)tvAccountSpecRuntimeMap.get(tvAccountSpec.getId());
            long terminalTypeId = tvAccountSpecRuntime.config.getLong("terminal.typeId", 0L);
            if (terminalTypeId <= 0L) continue;
            terminalAccountSpecIdMap.put(terminalTypeId, tvAccountSpecRuntime);
        }
        List deviceTypeIds = Utils.toIntegerList((String)moduleSetup.get("om.deviceTypeIds", null));
        for (Integer deviceTypeId : deviceTypeIds) {
            for (TvDevice tvDevice : tvDeviceService.deviceList(deviceTypeId.intValue())) {
                this.processDevice(setup, context, connectionSet, moduleId, tvDeviceMap, tvDevice, terminalAccountSpecIdMap, tvAccountService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDevice(Setup setup, ServerContext context, ConnectionSet connectionSet, int moduleId, TvDeviceMap tvDeviceMap, TvDevice tvDevice, Map<Long, TvAccountSpecRuntime> terminalAccountSpecIdMap, TvAccountService tvAccountService) throws Exception {
        logger.info("processDevice " + tvDevice.getId());
        this.print("processDevice " + tvDevice.getId());
        TvDeviceMap.TvDeviceMapItem tvDeviceMapItem = tvDeviceMap.get(tvDevice.getId());
        ParameterMap config = tvDeviceMapItem.getConfig();
        String host = null;
        int port = 0;
        List addressList = tvDevice.getHosts();
        if (addressList.size() > 0) {
            InetSocketAddress socketAddress = (InetSocketAddress)addressList.get(0);
            host = socketAddress.getAddress().getHostAddress();
            port = socketAddress.getPort();
        }
        if (Utils.isBlankString(host)) {
            host = "127.0.0.1";
        }
        if (port <= 0) {
            port = 8080;
        }
        String username = config.get("om.login", config.get("om.username", tvDevice.getUsername()));
        String password = config.get("om.password", tvDevice.getPassword());
        String urlString = "http://" + host + ":" + port;
        URL url = new URL(urlString);
        SubscriberMngFacadeAPIService subscriberMngFacadeAPIService = new SubscriberMngFacadeAPIService(new URL(url, "AdminAPI/SubscriberMngFacadeAPI?wsdl"));
        SubscriberMngFacadeAPI subscriberMngFacadeAPI = subscriberMngFacadeAPIService.getSubscriberMngFacadeAPIPort();
        Map requestContext = ((BindingProvider)subscriberMngFacadeAPI).getRequestContext();
        requestContext.put("jakarta.xml.ws.service.endpoint.address", urlString + "/AdminAPI/SubscriberMngFacadeAPI");
        TvAccountDao tvAccountDao = new TvAccountDao(connectionSet.getConnection(), moduleId);
        String clientId = subscriberMngFacadeAPI.login(username, password);
        try {
            this.processDevice(context, connectionSet, moduleId, tvDeviceMap, tvDevice, tvAccountDao, clientId, terminalAccountSpecIdMap, tvAccountService, subscriberMngFacadeAPI);
        }
        finally {
            subscriberMngFacadeAPI.logout(clientId);
        }
    }

    private void processDevice(ServerContext context, ConnectionSet connectionSet, int moduleId, TvDeviceMap tvDeviceMap, TvDevice tvDevice, TvAccountDao tvAccountDao, String clientId, Map<Long, TvAccountSpecRuntime> terminalAccountSpecIdMap, TvAccountService tvAccountService, SubscriberMngFacadeAPI subscriberMngFacadeAPI) throws Exception {
        Date now = new Date();
        List tvAccountList = tvAccountService.tvAccountList(tvDevice.getId(), null, now, now);
        for (TvAccount tvAccount : tvAccountList) {
            if (tvAccount.getParentId() > 0) continue;
            long householdId = Utils.parseLong((String)tvAccount.getDeviceAccountId());
            if (householdId <= 0L) {
                logger.info("Household not specified for tvAccount:" + tvAccount.getId());
                this.print("Household not specified for tvAccount:" + tvAccount.getId());
                continue;
            }
            try {
                this.processAccount(context, connectionSet, moduleId, tvDeviceMap, tvDevice, tvAccountDao, clientId, terminalAccountSpecIdMap, tvAccountService, subscriberMngFacadeAPI, householdId, tvAccount);
            }
            catch (InvalidParameterException_Exception ex) {
                logger.info("Household not found with id:" + householdId + " for tvAccount:" + tvAccount.getId() + ". " + ex.getMessage());
                this.print("Household not found with id:" + householdId + " for tvAccount:" + tvAccount.getId() + ". " + ex.getMessage());
            }
            context.commit();
        }
    }

    private void processAccount(ServerContext context, ConnectionSet connectionSet, int moduleId, TvDeviceMap tvDeviceMap, TvDevice tvDevice, TvAccountDao tvAccountDao, String clientId, Map<Long, TvAccountSpecRuntime> terminalAccountSpecIdMap, TvAccountService tvAccountService, SubscriberMngFacadeAPI subscriberMngFacadeAPI, long householdId, TvAccount parentTvAccount) throws Exception {
        List<TvAccount> children = tvAccountDao.listChildren(parentTvAccount.getId());
        TerminalArray terminalArray = subscriberMngFacadeAPI.getTerminalsByHousehold(clientId, householdId);
        block0: for (Terminal terminal : terminalArray.getItem()) {
            TvAccountSpecRuntime tvAccountSpecRuntime;
            if (children != null) {
                for (TvAccount child : children) {
                    if (Utils.parseLong((String)child.getDeviceAccountId()) == terminal.getId()) continue block0;
                    if (!Utils.isBlankString((String)child.getDeviceAccountId()) || !terminal.getMacAddress().equalsIgnoreCase(TvUtils.macAddressToString(child.getMacAddressListBytes())) || !terminal.getSerial().equalsIgnoreCase(child.getIdentifier())) continue;
                    logger.info("Found not linked by deviceAccountId terminal");
                    this.print("Found not linked by deviceAccountId terminal");
                    String deviceAccountId = String.valueOf(terminal.getId());
                    tvAccountDao.updateDeviceStateAndOptions(child.getId(), deviceAccountId, (short)1, child.getDeviceOptionIds(), child.getAccessCode());
                    context.publishAfterCommit((Event)new TvAccountDeviceStateAndOptionsModifiedEvent(moduleId, parentTvAccount.getContractId(), child.getDeviceId(), child.getId(), deviceAccountId, 1, null));
                    continue block0;
                }
            }
            if ((tvAccountSpecRuntime = terminalAccountSpecIdMap.get(terminal.getTerminalType())) == null) {
                logger.error("Found not linked terminal, but tvAccountSpec not found for terminalType=" + terminal.getTerminalType());
                this.print("Found not linked terminal, but tvAccountSpec not found for terminalType=" + terminal.getTerminalType());
                continue;
            }
            logger.info("Found new terminal in MW");
            this.print("Found new terminal in MW");
            TvAccount tvAccount = new TvAccount();
            tvAccount.setContractId(parentTvAccount.getContractId());
            tvAccount.setParentId(parentTvAccount.getId());
            tvAccount.setSpecId(tvAccountSpecRuntime.tvAccountSpec.getId());
            tvAccount.setDeviceId(parentTvAccount.getDeviceId());
            tvAccount.setDateFrom(parentTvAccount.getDateFrom());
            tvAccount.setDateTo(parentTvAccount.getDateTo());
            tvAccount.setMacAddressList(Collections.singletonList(TvUtils.parseMacAddress(terminal.getMacAddress())));
            tvAccount.setIdentifier(terminal.getSerial());
            tvAccount.setLogin(null);
            tvAccount.setPassword(null);
            tvAccount.setStatus(0);
            tvAccount.setComment("");
            tvAccount.setDeviceState((short)1);
            tvAccount.setDeviceAccountId(String.valueOf(terminal.getId()));
            String titlePattern = tvAccountSpecRuntime.config.get("title.pattern", "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 title.pattern \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430!");
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceIdentifier", (String)tvDevice.getIdentifier());
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"deviceTitle", (String)tvDevice.getTitle());
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"login", (String)tvAccount.getLogin());
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"id", (String)String.valueOf(tvAccount.getId()));
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"identifier", (String)tvAccount.getIdentifier());
            StringBuilder macString = new StringBuilder();
            if (tvAccount.getMacAddressList() != null && tvAccount.getMacAddressList().size() > 0) {
                for (byte[] mac : tvAccount.getMacAddressList()) {
                    macString.append(Utils.bytesToString((byte[])mac, (boolean)true, null));
                    macString.append(", ");
                }
                macString.setLength(macString.length() - 2);
            }
            titlePattern = PatternStringGenerator.insertPatternPart((String)titlePattern, (String)"macAddress", (String)macString.toString());
            tvAccount.setTitle(titlePattern);
            logger.info(titlePattern);
            this.print(titlePattern);
            tvAccountDao.update(tvAccount);
            tvAccountDao.updateDeviceStateAndOptions(tvAccount.getId(), tvAccount.getDeviceAccountId(), tvAccount.getDeviceState(), null, 0);
            context.publishAfterCommit((Event)new TvAccountModifiedEvent(moduleId, tvAccount.getContractId(), 0, null, tvAccount));
            logger.info("Link terminal:" + terminal.getId() + " with tvAccount:" + tvAccount.getId());
            this.print("Link terminal:" + terminal.getId() + " with tvAccount:" + tvAccount.getId());
        }
    }
}

