/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.naming.NamingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.tv.server.Module;
import ru.bitel.bgbilling.modules.tv.server.event.TvReloadEvent;
import ru.bitel.bgbilling.modules.tv.server.event.TvReloadLocalEvent;
import ru.bitel.bgbilling.modules.tv.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvTarifficationManager;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;

public abstract class TvApplication
implements CommandListener,
ThreadContextFactory<ServerContext>,
Lifecycle {
    private static final Logger logger = LogManager.getLogger();
    protected final ScheduledExecutorService scheduledExecutorService;
    public final boolean realtime;
    public final Date initialDate;
    public final Setup setup;
    public final int applicationId;
    public final int moduleId;
    public final int rootDeviceId;
    public final TvTariffContext tvTariffContext;
    public final ContractRuntimeMap contractRuntimeMap;
    public final TvAccountRuntimeMap tvAccountRuntimeMap;
    public TvAccountSpecRuntimeMap tvAccountSpecRuntimeMap;
    public ServiceSpecRuntimeMap serviceSpecRuntimeMap;
    public ProductSpecRuntimeMap productSpecRuntimeMap;
    public volatile Set<Integer> childrenDeviceIds;
    public final TvDeviceRuntimeMap deviceMap;
    public final ConvergenceBalanceManager convergenceBalanceManager;
    public static final int EMPTY_ROOT_DEVICE_ID = -10;
    protected final Date dateFrom;
    public static final int CHECK_TARIFF_PRICE_DISABLE = 0;
    public static final int CHECK_TARIFF_PRICE_ENABLE = 1;
    public static final int CHECK_TARIFF_PRICE_STRICT = 2;
    public static final int CHECK_TARIFF_PRICE_ENABLE_WITHOUT_TIME = 3;
    public static final int CHECK_TARIFF_PRICE_STRICT_WITHOUT_TIME = 4;
    public final int checkTariffPrice;
    private final EventListener<TvReloadEvent> reloadEventListener = new EventListener<TvReloadEvent>(){

        public void notify(final TvReloadEvent e, EventListenerContext ctx) throws BGException {
            logger.info("TvReloadEvent");
            new Thread("tv-reload"){

                @Override
                public void run() {
                    ServerContext context = new ServerContext(TvApplication.this.setup, TvApplication.this.moduleId, 0);
                    context.init();
                    ThreadContext.set((ThreadContext)context);
                    try {
                        TvApplication.this.reload(e.getUserId());
                        context.commit();
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        ThreadContext.set(null);
                        context.destroy();
                    }
                }
            }.start();
        }
    };

    public TvApplication(boolean realtime, Setup setup, int applicationId, int moduleId, boolean loadSaScripts) throws BGException {
        this(realtime, setup, applicationId, moduleId, loadSaScripts, -1, new Date());
    }

    public TvApplication(boolean realtime, final Setup setup, int applicationId, final int moduleId, boolean loadSaScripts, int rootDeviceId, Date dateFrom) throws BGException {
        this.realtime = realtime;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(4, (ThreadFactory)new WorkerThreadFactory("tvApplication", null, (ThreadContextFactory)new ThreadContextFactory<ServerContext>(){

            public ServerContext newThreadContext() {
                return new ServerContext(setup, moduleId, 0);
            }
        }));
        this.initialDate = new Date();
        this.dateFrom = dateFrom;
        this.applicationId = applicationId;
        this.moduleId = moduleId;
        this.rootDeviceId = rootDeviceId != -1 ? rootDeviceId : (rootDeviceId = setup.getInt("rootDeviceId", -1));
        this.setup = setup;
        if (moduleId <= 0) {
            throw new BGException("Not defined 'moduleId' in XML!");
        }
        if (rootDeviceId != -10 && rootDeviceId <= 0) {
            throw new BGException("Not defined 'rootDeviceId' in XML!");
        }
        if (rootDeviceId == -10) {
            rootDeviceId = 0;
        }
        this.convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
        if (realtime) {
            // empty if block
        }
        logger.info("rootDeviceId=" + rootDeviceId);
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(moduleId));
        this.checkTariffPrice = moduleSetup == null ? 1 : moduleSetup.getInt("accounting.tariffication.checkPrice", 1);
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, (boolean)true);){
            this.deviceMap = new TvDeviceRuntimeMap(setup, moduleId, rootDeviceId, loadSaScripts);
            this.contractRuntimeMap = new ContractRuntimeMap(this.initialDate);
            this.tvAccountRuntimeMap = new TvAccountRuntimeMap(this.moduleId, this.contractRuntimeMap, this.initialDate, this);
            this.tvTariffContext = new TvTariffContext(this, connectionSet, moduleId, dateFrom, TvTariffContext.TvTariffMode.realtime);
            this.tvAccountSpecRuntimeMap = new TvAccountSpecRuntimeMap(connectionSet.getConnection(), moduleId);
            this.serviceSpecRuntimeMap = ServiceSpecRuntimeMap.getInstance(connectionSet);
            this.productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(connectionSet);
        }
        try {
            if (realtime) {
                new ScriptEventProcessor(setup).start();
                new CommonKernelEventProcessor(setup);
                try {
                    Setup.getEnvironment().bind("threadContextFactory", (Object)this);
                }
                catch (NamingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private synchronized void reload(int userId) throws BGException {
        EventProcessor.getInstance().request((QueueEvent)new TvReloadLocalEvent(this.moduleId, userId, this.childrenDeviceIds));
    }

    public void start() throws Exception {
        ServerContext context = (ServerContext)ThreadContext.get();
        this.deviceMap.load(context.getConnection());
        this.load();
        this.tvAccountRuntimeMap.load(this, context.getConnectionSet());
        EventProcessor.getInstance().addListener(this.reloadEventListener, TvReloadEvent.class, this.moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<TvReloadLocalEvent>(){

            public void notify(TvReloadLocalEvent e, EventListenerContext ctx) throws BGException {
                TvApplication.this.load();
            }
        }, TvReloadLocalEvent.class, this.moduleId, null);
    }

    public void load() {
        HashSet<Integer> childrenDeviceIds = new HashSet<Integer>();
        for (TvDeviceRuntime deviceRuntime : this.deviceMap.values()) {
            childrenDeviceIds.add(deviceRuntime.tvDevice.getId());
        }
        this.childrenDeviceIds = childrenDeviceIds;
        logger.info("childrenDeviceIds=" + childrenDeviceIds);
    }

    public void stop() throws Exception {
    }

    public ServerContext newThreadContext() {
        return new ServerContext(this.setup, this.moduleId, 0);
    }

    public String getCommandsHelp() {
        return "";
    }

    public String executeCommand(String cmd, String param) {
        return "";
    }

    public Set<Integer> tvAccountOptionSet(ConnectionSet connectionSet, TvAccountRuntime tvAccountRuntime, Date now) throws BGException {
        TvTarifficationManager tarifficationManager = new TvTarifficationManager(this.setup, connectionSet, this.moduleId);
        TvTariffRequest req = tarifficationManager.tarifficate(tvAccountRuntime.getContractRuntime().contractId, tvAccountRuntime, now);
        return req.getOptionSet();
    }

    public AuthResult authorization(ConnectionSet connectionSet, TvAccountRuntime tvAccountRuntime, Date now, BigDecimal accountDelta) throws BGException {
        TvAccount tvAccount = tvAccountRuntime.getTvAccount();
        if (tvAccount.getStatus() != 0) {
            logger.info("tvAccount[id=" + tvAccount.getId() + "] status not active (accessCode=" + tvAccount.getAccessCode() + ").");
            return new AuthResult(AccessCode.SERVICE_CLOSED.getCode());
        }
        if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, tvAccountRuntime.getContractRuntime().getStatus())) {
            logger.info("tvAccount[id=" + tvAccount.getId() + "] contract status not active.");
            return new AuthResult(AccessCode.CONTRACT_LOCKED.getCode());
        }
        HashSet<Integer> optionSet = new HashSet<Integer>();
        TvTarifficationManager tarifficationManager = new TvTarifficationManager(this.setup, connectionSet, this.moduleId);
        TvTariffRequest req = tarifficationManager.tarifficate(tvAccountRuntime.getContractRuntime().contractId, tvAccountRuntime, now);
        BigDecimal balance = req.getBalance();
        BigDecimal limit = req.getLimit();
        boolean balanceInsufficient = accountDelta != null ? balance.subtract(accountDelta).compareTo(limit) < 0 : balance.compareTo(limit) < 0;
        Module.Conf conf = (Module.Conf)this.setup.getConfig(this.moduleId, Module.Conf.class);
        boolean checkBalance = true;
        checkBalance = conf.lockByBalance ? true : conf.lockByBalanceTvAccountSpecIds != null && conf.lockByBalanceTvAccountSpecIds.contains(tvAccount.getSpecId());
        if (req != null) {
            if (req.getAccessCode() != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                logger.info("Authorization denied (by tariff or serv restriction) with accessCode " + req.getAccessCode());
                return new AuthResult(req.getAccessCode());
            }
            if (req.isIgnoreBalanceInsufficient()) {
                checkBalance = false;
            }
            optionSet.addAll(req.getOptionSet());
        }
        if (checkBalance) {
            if (balanceInsufficient) {
                logger.info("tvAccount[id=" + tvAccount.getId() + "] balance is out of limit: " + balance);
                return new AuthResult(AccessCode.BALANCE_INSUFFICIENT.getCode());
            }
            logger.info("tvAccount[id=" + tvAccount.getId() + "] balance ok: " + balance);
        } else {
            logger.info("tvAccount[id=" + tvAccount.getId() + "] skip balance check");
        }
        if (logger.isInfoEnabled()) {
            logger.info("OptionSet: " + optionSet);
        }
        return new AuthResult(AccessCode.AUTHORIZATION_SUCCEEDED.getCode(), optionSet, req);
    }

    public ContractRuntimeMap getContractRuntimeMap() {
        return this.contractRuntimeMap;
    }

    public TvAccountRuntimeMap getTvAccountRuntimeMap() {
        return this.tvAccountRuntimeMap;
    }

    public TvAccountSpecRuntimeMap getTvAccountSpecRuntimeMap() {
        return this.tvAccountSpecRuntimeMap;
    }

    public ProductSpecRuntimeMap getProductSpecRuntimeMap() {
        return this.productSpecRuntimeMap;
    }

    public TvDeviceRuntimeMap getTvDeviceRuntimeMap() {
        return this.deviceMap;
    }
}

