/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.MediatorAdapter;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordProcessor;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.ConfigParameter;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.VoiceLogProcessedEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.common.mediation.Mediator;
import ru.bitel.bgbilling.modules.voice.common.mediation.VoiceNumberApplyTo;
import ru.bitel.bgbilling.modules.voice.server.bean.Keys;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class AbstractMediator
extends MediatorAdapter
implements Mediator {
    protected final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    protected final String CDR_BG_DIR = "bg";
    protected VoiceDevice device;
    protected VoiceDeviceType deviceType;
    protected ParameterMap deviceConfig;
    protected int moduleId;
    protected Setup setup;
    protected boolean cdrZeroSkip = false;
    private NumberConverter[] callingStationE164Converter;
    private NumberConverter[] calledStationE164Converter;

    public Object init(Setup setup, int moduleId, VoiceDevice device, VoiceDeviceType deviceType, ParameterMap config) throws Exception {
        this.device = device;
        this.deviceType = deviceType;
        this.deviceConfig = config;
        this.moduleId = moduleId;
        this.setup = setup;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("device.config => \n{}", (Object)device.getConfig());
            this.logger.debug("deviceType.config => \n{}", (Object)device.getConfig());
        }
        this.cdrZeroSkip = new Preferences(deviceType.getConfig(), "\n").getBoolean(Keys.CDR_ZERO_SKIP.key, this.cdrZeroSkip);
        ArrayList<NumberConverter> callingStationE164ConverterList = new ArrayList<NumberConverter>();
        ArrayList<NumberConverter> calledStationE164ConverterList = new ArrayList<NumberConverter>();
        JSONArray cdrConverterRules = new JSONArray(config.get("cdr.converter.rules", "[]"));
        block5: for (int index = 0; index < cdrConverterRules.length(); ++index) {
            JSONObject rule = cdrConverterRules.getJSONObject(index);
            NumberConverter numberConverter = new NumberConverter(rule.optString("rule"), rule.optString("value"));
            VoiceNumberApplyTo applyTo = VoiceNumberApplyTo.valueOf((String)rule.optString("applyTo", VoiceNumberApplyTo.ALL.name()));
            this.logger.debug("applyTo: {}; rule: {}; result: {}", (Object)applyTo.name(), (Object)numberConverter.pattern, (Object)numberConverter.replacement);
            switch (applyTo) {
                case ALL: {
                    callingStationE164ConverterList.add(numberConverter);
                    calledStationE164ConverterList.add(numberConverter);
                    continue block5;
                }
                case CALLED: {
                    calledStationE164ConverterList.add(numberConverter);
                    continue block5;
                }
                case CALLING: {
                    callingStationE164ConverterList.add(numberConverter);
                }
            }
        }
        if (config != null) {
            String[] pattern;
            String patternString;
            for (ParameterMap e : config.subIndexed("mediator.callingStationE164.convert").values()) {
                patternString = e.get("", null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("callingStationE164:patternString={}", (Object)patternString);
                }
                if (Utils.isBlankString((String)patternString)) continue;
                pattern = patternString.split("=>");
                callingStationE164ConverterList.add(new NumberConverter(pattern[0], pattern[1]));
            }
            for (ParameterMap e : config.subIndexed("mediator.calledStationE164.convert").values()) {
                patternString = e.get("", null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("calledStationE164:patternString={}", (Object)patternString);
                }
                if (Utils.isBlankString((String)patternString)) continue;
                pattern = patternString.split("=>");
                calledStationE164ConverterList.add(new NumberConverter(pattern[0], pattern[1]));
            }
        }
        this.callingStationE164Converter = callingStationE164ConverterList.toArray(new NumberConverter[0]);
        this.calledStationE164Converter = calledStationE164ConverterList.toArray(new NumberConverter[0]);
        return null;
    }

    public void readHourDataLog(VoiceRecordProcessor processor, Date hour) throws Exception {
        LocalDateTime time = TimeUtils.convertDateToLocalDateTime((Date)hour);
        this.preload();
        Path logPath = Paths.get(this.device.getLogPath(), new String[0]);
        this.logger.debug("logPath => " + logPath.toString());
        if (Files.notExists(logPath, new LinkOption[0])) {
            Files.createDirectories(logPath, new FileAttribute[0]);
        }
        String prefix = time.format(DateTimeFormatter.ofPattern("yyyyMMddHH"));
        Path dayLogPath = Paths.get(logPath.toString(), "bg", prefix.substring(0, 4), prefix.substring(4, 6), prefix.substring(6, 8));
        this.logger.debug("dayLogPath => " + dayLogPath.toString());
        if (Files.notExists(dayLogPath, new LinkOption[0])) {
            Files.createDirectories(dayLogPath, new FileAttribute[0]);
        }
        Path hourLogPath = Paths.get(dayLogPath.toString(), prefix.substring(8));
        this.logger.debug("hourLogPath => " + hourLogPath.toString());
        if (Files.exists(hourLogPath, new LinkOption[0])) {
            Files.lines(hourLogPath).forEach(line -> {
                try {
                    this.processLine(processor, line.split("\t"));
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            });
        }
    }

    protected abstract VoiceRecord processLine(VoiceRecordProcessor var1, String[] var2) throws InterruptedException;

    public void getLogExists(Date month, int[] data) {
        String path = this.device.getLogPath();
        File rootDir = new File(path);
        if (!rootDir.exists()) {
            return;
        }
        long start = System.currentTimeMillis();
        File bgDir = new File(rootDir, "bg");
        bgDir.mkdirs();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("logDir = {}", (Object)bgDir.toPath().toString());
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");
        LocalDateTime hour = TimeUtils.convertDateToLocalDateTime((Date)month);
        hour = hour.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
        LocalDateTime nextMonth = hour.plusMonths(1L);
        while (hour.isBefore(nextMonth)) {
            String prefix = hour.format(dateTimeFormatter);
            Path hourPath = Paths.get(bgDir.toPath().toString(), prefix.substring(0, 4), prefix.substring(4, 6), prefix.substring(6, 8), prefix.substring(8));
            if (Files.exists(hourPath, new LinkOption[0])) {
                int n = hour.getDayOfMonth() - 1;
                data[n] = data[n] | 1 << hour.getHour();
            }
            hour = hour.plusHours(1L);
        }
        if (this.logger.isDebugEnabled()) {
            for (int day = 0; day < data.length; ++day) {
                StringBuffer str = new StringBuffer();
                for (int h = 0; h < 24; ++h) {
                    str.append((data[day] & 1 << h) > 0 ? "1" : "0");
                }
                this.logger.debug(String.format("day => %2d   hour => %24s", day + 1, str.toString()));
            }
        }
        this.logger.info("getLogExists run time = " + (System.currentTimeMillis() - start) + "ms");
    }

    private String toE164(NumberConverter[] converters, String number) {
        if (converters != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("converters.length = {}", (Object)converters.length);
            }
            String value = number;
            int size = converters.length;
            for (int i = 0; i < size; ++i) {
                NumberConverter c = converters[i];
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("converters[{}] = {}; number = {}", (Object)i, (Object)(c.pattern + " => " + c.replacement), (Object)number);
                }
                value = value.replaceAll(c.pattern, c.replacement);
            }
            return value;
        }
        return number;
    }

    public String callingStationIdToE164(String callingStationId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callingStationId: {}; callingStationE164Converter.size(): {}", (Object)callingStationId, (Object)this.callingStationE164Converter.length);
        }
        return this.toE164(this.callingStationE164Converter, callingStationId);
    }

    public String calledStationIdToE164(String calledStationId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("calledStationId: {}; calledStationE164Converter.size(): {}", (Object)calledStationId, (Object)this.calledStationE164Converter.length);
        }
        return this.toE164(this.calledStationE164Converter, calledStationId);
    }

    protected boolean skipCDR(CDR cdr) {
        return this.cdrZeroSkip && cdr.amount == 0;
    }

    protected String getNumber(ByteBuffer byteBuffer, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int b = byteBuffer.get() & 0xFF;
            int b1 = (b & 0xF0) >> 4;
            int b2 = b & 0xF;
            buf.append(b1 == 15 ? "" : Integer.valueOf(b1)).append(b2 == 15 ? "" : Integer.valueOf(b2));
        }
        return buf.toString();
    }

    protected void preload() {
        try {
            Path logPath = Paths.get(this.device.getLogPath(), new String[0]);
            this.logger.debug("logPath => " + logPath.toString());
            if (Files.notExists(logPath, new LinkOption[0])) {
                Files.createDirectories(logPath, new FileAttribute[0]);
            }
            Path inboxLogDir = Paths.get(logPath.toString(), "inbox");
            this.logger.debug("inboxLogDir => " + inboxLogDir.toString());
            Files.createDirectories(inboxLogDir, new FileAttribute[0]);
            Path processedDir = Paths.get(logPath.toString(), "processed");
            this.logger.debug("processedDir => " + processedDir.toString());
            Files.createDirectories(processedDir, new FileAttribute[0]);
            Files.walk(inboxLogDir, new FileVisitOption[0]).forEach(file -> {
                this.logger.debug("file => {}", (Object)file.getFileName());
                if (Files.isDirectory(file, new LinkOption[0])) {
                    return;
                }
                if (file.getFileName().startsWith(".")) {
                    return;
                }
                if (this.filterFiles((Path)file)) {
                    return;
                }
                HashMap<String, List<String>> cdrs = new HashMap<String, List<String>>();
                this.parseLog((Path)file, (Map<String, List<String>>)cdrs);
                this.saveCDRInSormLog(cdrs);
                try {
                    for (String key : cdrs.keySet()) {
                        Path dayPath = Paths.get(logPath.toString(), "bg", key.substring(0, 4), key.substring(4, 6), key.substring(6, 8));
                        Files.createDirectories(dayPath, new FileAttribute[0]);
                        Path cdrPath = Paths.get(dayPath.toString(), key.substring(8));
                        LinkedHashSet<String> cdrSet = new LinkedHashSet<String>();
                        if (Files.exists(cdrPath, new LinkOption[0])) {
                            for (String cdr : Files.readAllLines(cdrPath)) {
                                cdrSet.add(cdr);
                            }
                        }
                        cdrSet.addAll((Collection)cdrs.get(key));
                        StringBuffer buffer = new StringBuffer();
                        for (String s : cdrSet) {
                            buffer.append(s).append("\n");
                        }
                        Files.writeString(cdrPath, (CharSequence)buffer.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                    }
                    Path outboxPath = this.getOutboxPath(processedDir, (Path)file);
                    Files.createDirectories(outboxPath, new FileAttribute[0]);
                    Files.move(file, Paths.get(outboxPath.toString(), file.getFileName().toString()), new CopyOption[0]);
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            });
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
    }

    private void saveCDRInSormLog(Map<String, List<String>> cdrs) {
        if (this.deviceConfig.get("sorm.cdr.upload", "0").equals("0")) {
            return;
        }
        this.logger.debug(String.format("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 CDR \u0434\u043b\u044f \u0421\u041e\u0420\u041c. moduleId=%s, deviceId=%s", this.moduleId, this.device.getId()));
        try (Connection connection = this.setup.getDBConnectionFromPool();){
            String tableName = ServerUtils.getModuleTableName((String)"sorm_voice_cdr_log", (int)this.moduleId);
            ServerUtils.checkTable((Connection)connection, (String)tableName, (String)this.createQuerySormCDRLogTable(tableName));
            int lineCount = 0;
            try (PreparedStatement ps = connection.prepareStatement("INSERT INTO " + tableName + " SET voiceDeviceId=?, line=?, time=NOW()");){
                for (String key : cdrs.keySet()) {
                    for (String line : cdrs.get(key)) {
                        ps.setInt(1, this.device.getId());
                        ps.setString(2, line);
                        ps.addBatch();
                        ++lineCount;
                    }
                }
                ps.executeBatch();
            }
            this.logger.debug(String.format("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e \u043b\u043e\u0433\u043e\u0432 CDR \u0434\u043b\u044f \u0421\u041e\u0420\u041c. moduleId=%s, deviceId=%s, \u0437\u0430\u043f\u0438\u0441\u0435\u0439=%s", this.moduleId, this.device.getId(), lineCount));
            EventProcessor.getInstance().publish((Event)new VoiceLogProcessedEvent(this.moduleId, this.device.getId(), lineCount, this.deviceConfig.get("cdr.converter.rules", "[]")));
        }
        catch (SQLException | BGException ex) {
            this.logger.error((Object)ex);
        }
    }

    protected Path getOutboxPath(Path processedDir, Path file) {
        return Paths.get(processedDir.toString(), String.valueOf(LocalDate.now().getYear()));
    }

    protected void parseLog(Path path, Map<String, List<String>> cdrs) {
    }

    protected boolean filterFiles(Path path) {
        return false;
    }

    protected static List<String> parseLine(String line) {
        ArrayList<String> data = new ArrayList<String>();
        if (line == null || line.isBlank()) {
            return data;
        }
        int index = 0;
        Object value = "";
        String[] tokens = line.split(",");
        while (index < tokens.length) {
            if (((String)(value = (String)value + tokens[index++])).replaceAll("[^\"]", "").length() % 2 == 1) {
                value = (String)value + ",";
                continue;
            }
            data.add(((String)value).replaceAll("^\"", "").replaceAll("\"$", "").replaceAll("\"\"", "\""));
            value = "";
        }
        return data;
    }

    public List<ConfigParameter> configParameterList() {
        List configParameters = super.configParameterList();
        configParameters.add(new ConfigParameter(Keys.CDR_ZERO_SKIP.key, "false", "true - \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u0438 \u0441 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0434\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c\u044e"));
        return configParameters;
    }

    private String createQuerySormCDRLogTable(String tableName) {
        return "CREATE TABLE IF NOT EXISTS " + tableName + " (`id` INT NOT NULL AUTO_INCREMENT,`voiceDeviceId` INT NOT NULL,`line` TEXT NOT NULL DEFAULT '',`time` TIMESTAMP NOT NULL,PRIMARY KEY (`id`));";
    }

    public static void main(String[] args) {
        System.out.println("81073472".replaceAll("^810(\\d+)$", "$1"));
        System.out.println("89174".replaceAll("^8(\\d+)$", "7$1"));
    }

    static class NumberConverter {
        final String pattern;
        final String replacement;

        public NumberConverter(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }
    }

    protected static class CDR {
        public LocalDateTime start;
        public String numberA = "";
        public String origNumberA = "";
        public String numberB = "";
        public String trunkIncoming = "0";
        public String trunkOutgoing = "0";
        public int amount = 0;

        public String toString() {
            return TimeUtils.format((LocalDateTime)this.start, (String)"yyyy-MM-dd'T'HH:mm:ss") + "\t" + this.numberA + "\t" + this.numberB + "\t" + this.amount + "\t" + this.trunkIncoming + "\t" + this.trunkOutgoing;
        }

        public static CDR toCDR(String[] params) {
            CDR cdr = new CDR();
            cdr.start = TimeUtils.parseLocalDateTime((String)params[0], (String)"yyyy-MM-dd'T'HH:mm:ss");
            cdr.numberA = params[1];
            cdr.numberB = params[2];
            cdr.amount = Utils.parseInt((String)params[3]);
            cdr.trunkIncoming = params[4];
            cdr.trunkOutgoing = params[5];
            return cdr;
        }
    }
}

