/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapRange;
import ru.bitel.bgbilling.modules.voice.common.dto.VoiceCostMapRangeItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceCostMapDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.CostMapImportManager;
import ru.bitel.bgbilling.modules.voice.server.bean.code.CostMapItemReader;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceCostMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.bean.range.VoiceCostMapRangeDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceCostMapUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService")
public class VoiceCostMapServiceImpl
extends AbstractService
implements VoiceCostMapService {
    private VoiceCostMapDao costMapDao;
    private VoiceCostMapItemDao costMapItemDao;

    @PostConstruct
    private void init() {
        this.costMapDao = new VoiceCostMapDao(this.getConnection(), this.moduleId);
        this.costMapItemDao = new VoiceCostMapItemDao(this.getConnection(), this.moduleId);
    }

    public List<VoiceCostMap> voiceCostMapList(int operatorId) throws BGException {
        return this.costMapDao.list(operatorId);
    }

    public int voiceCostMapUpdate(VoiceCostMap costMap) throws BGException {
        this.costMapDao.update(costMap);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, costMap.getId()));
        return costMap.getId();
    }

    public int voiceCostMapDelete(int costMapId) throws BGException {
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, costMapId));
        return this.costMapDao.delete(costMapId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String voiceCostMapItemTree(int costMapId, Date date) throws BGException {
        List<VoiceCostMapItem> costMapItemList = this.costMapItemDao.list(costMapId, date);
        VoiceUtils.fillParents(costMapItemList);
        VoiceCostMapItem root = new VoiceCostMapItem();
        root.setTitle("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
        root = (VoiceCostMapItem)TreeUtils.tree(costMapItemList, (Node)root);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(root);
                oos.flush();
                EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, costMapId));
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    public VoiceCostMapItem voiceCostMapItemGet(int itemId) throws BGException {
        return (VoiceCostMapItem)this.costMapItemDao.get(itemId);
    }

    public int voiceCostMapItemUpdate(VoiceCostMapItem item) throws BGException {
        CostMapImportManager manager = new CostMapImportManager(this.getConnection(), this.moduleId, this.userId);
        return manager.updateCostMapItem(item);
    }

    public int voiceCostMapItemDelete(List<Integer> itemIds) throws BGException {
        if (!itemIds.isEmpty()) {
            int itemId = itemIds.get(0);
            VoiceCostMapItem item = (VoiceCostMapItem)this.costMapItemDao.get(itemId);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, item.getCostMapId()));
        }
        for (Integer itemId : itemIds) {
            this.costMapItemDao.delete(itemId);
        }
        return itemIds.size();
    }

    public void importCostMap(int operatorId, int costMapId, Period period, boolean addNewGeocodes, String importerId, String importContent) throws BGException {
        new CostMapImportManager(this.getConnection(), this.moduleId, costMapId).importCostMap(costMapId, period, addNewGeocodes, importerId, importContent);
    }

    public void exportCostMap() throws BGException {
    }

    public void voiceCostMapItemDeleteAll(int costMapId) throws BGException {
        this.costMapItemDao.deleteByMapId(costMapId);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceCostMapUpdateEvent(this.moduleId, this.userId, costMapId));
    }

    public List<VoiceCostMapItem> costMapItemHistory(int codeId, int costMapId) throws BGException {
        List<VoiceCostMapItem> list = this.costMapItemDao.codeMap(codeId, costMapId).get(codeId);
        if (list == null) {
            list = new ArrayList<VoiceCostMapItem>();
        }
        return list;
    }

    public JSONArray importTemplateList() throws BGException {
        JSONArray array = new JSONArray();
        for (Class clazz : Utils.getClassList((String)"ru.bitel.bgbilling.modules.voice.server.bean.code.importer")) {
            if (!Arrays.asList(clazz.getInterfaces()).contains(CostMapItemReader.class)) continue;
            try {
                CostMapItemReader itemReader = clazz.asSubclass(CostMapItemReader.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)itemReader.getId());
                jsonObject.put("title", (Object)("[S] " + itemReader.getTitle()));
                array.put((Object)jsonObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return array;
    }

    public int voiceCostMapRangeUpdate(VoiceCostMapRange data) throws BGException, BGMessageException {
        try (VoiceCostMapRangeDao costMapRangeDao = new VoiceCostMapRangeDao(this.getConnection(), this.moduleId);){
            costMapRangeDao.update(data);
            int n = data.getId();
            return n;
        }
    }

    public List<VoiceCostMapRange> voiceCostMapRangeList(int costMapId, Date onDate) throws BGException, BGMessageException {
        try (VoiceCostMapRangeDao costMapRangeDao = new VoiceCostMapRangeDao(this.getConnection(), this.moduleId);){
            List<VoiceCostMapRange> list = costMapRangeDao.list(costMapId, onDate);
            return list;
        }
    }

    public List<VoiceCostMapRangeItem> voiceCostMapRangeItems(int costMapId, Date onDate) throws BGException, BGMessageException {
        try (VoiceCostMapRangeDao costMapRangeDao = new VoiceCostMapRangeDao(this.getConnection(), this.moduleId);){
            List<VoiceCostMapRangeItem> list = costMapRangeDao.items(costMapId, onDate);
            return list;
        }
    }
}

