package ru.bitel.bgbilling.modules.botmanager.dyn.auth;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.common.Utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AuthProcessingByFIO
    implements DialogProcessing
{
    private static final Logger logger = LogManager.getLogger( AuthProcessingByFIO.class );

    private static final int ERROR_DIALOG_ID = 8;
    private static final int REQUEST_PASS_DIALOG = 9;

    //параметры договора
    private final int FIRST_NAME_PID = 195; //имя
    private final int LAST_NAME_PID = 194; //фамилия
    private final int MIDDLE_NAME_PID = 196; //отчество


    @Override
    public void preDialog( ServerContext serverContext, JSONObject botData )
        throws BGException
    {

    }

    @Override
    public void processDialog( ServerContext serverContext,
                               JSONObject botData,
                               String inputTextOfUser )
        throws BGException
    {
        if( Utils.isBlankString(inputTextOfUser) )
        {
            botData.put( NEXT_DIALOG_ID, ERROR_DIALOG_ID );
            return;
        }

        String[] fio = inputTextOfUser.split( " " );

        if( fio.length != 3 )
        {
            botData.put( ERROR_MESSAGE, "Для поиска договора укажите фамилию, имя и отчество разделённые пробелом" );
            return;
        }

        if( logger.isDebugEnabled() )
        {
            logger.info( "Поиск договора" );
        }

        int cid = findContractByFIO( serverContext.getConnection(), fio[1], fio[0], fio[2] );
        if( cid < 0 )
        {
            botData.put( ERROR_MESSAGE, "Не удалось найти договор" );
        }
        else
        {
            botData.put( NEXT_DIALOG_ID, REQUEST_PASS_DIALOG );
            botData.put( CONTRACT_ID, cid );
        }
    }

    private int findContractByFIO( Connection connection, String firstName, String lastName, String middleName )
        throws BGException
    {
        int cid = -1;

        String query = "select c.id from contract as c "
                       + "left join contract_parameter_type_1 as param on c.id=param.cid "
                       + "where param.pid IN(?,?,?) AND param.val=? OR param.val=? OR param.val=? GROUP BY c.id";
        try(PreparedStatement ps = connection.prepareStatement( query ))
        {
            int index = 1;
            ps.setInt( index++, FIRST_NAME_PID );
            ps.setInt( index++, LAST_NAME_PID );
            ps.setInt( index++, MIDDLE_NAME_PID );
            ps.setString( index++, firstName );
            ps.setString( index++, lastName );
            ps.setString( index, middleName );

            ResultSet rs = ps.executeQuery();
            if( rs.next() )
            {
                cid = rs.getInt( 1 );
            }
            rs.close();
        }
        catch( SQLException ex )
        {
            throw new BGException(ex);
        }

        return cid;
    }

    @Override
    public String title()
    {
        return "Обработка авторизации по ФИО";
    }
}
