/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bvcom.server.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.bvcom.common.bean.Transaction;
import ru.bitel.bgbilling.modules.bvcom.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.bvcom.server.bean.BVParams;
import ru.bitel.bgbilling.modules.bvcom.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class CheckReturnRequestStatus
extends TaskBase {
    private BVParams params;

    protected boolean initTask() {
        if (this.moduleId < 0) {
            this.getLogger().error("Param mid not found!");
            return false;
        }
        this.params = new BVParams(this.setup.getModuleSetup(Integer.valueOf(this.moduleId)));
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             BalanceUtils bu = new BalanceUtils(con);){
            TransactionManager manager = new TransactionManager(con, this.moduleId);
            this.getLogger().info("Get transaction list for return");
            List<Transaction> transactionList = manager.getReturnMoneyTransactionList();
            for (Transaction transaction : transactionList) {
                String[] answerValues;
                String login = this.params.getClient();
                String clientOrderId = this.params.getTransactionFormat().format(transaction.getId());
                String merchantControl = this.params.getMerchantControl();
                String orderId = transaction.getBvcomOrderId();
                String control = this.getControlHash(login, orderId, clientOrderId, merchantControl);
                this.getLogger().info("Connecting to BVCom server...");
                URL url = new URL(this.params.getServerUrl() + "status/" + this.params.getEndPointId());
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setDoOutput(true);
                StringBuilder urlString = new StringBuilder("login= " + login);
                urlString.append("&client_orderid=" + clientOrderId);
                urlString.append("&orderid=" + orderId);
                urlString.append("&control=" + control);
                this.getLogger().info("Query to BVCom: " + url.toString() + "?" + urlString);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));
                bw.write(urlString.toString().toCharArray());
                bw.close();
                connection.connect();
                this.getLogger().info("Get BVCom answer....");
                InputStream is = connection.getInputStream();
                char[] bvcom_answer = new char[is.available()];
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                br.read(bvcom_answer);
                this.getLogger().info("Answer from BVCom: " + new String(bvcom_answer));
                HashMap<String, String> paramVal = new HashMap<String, String>();
                for (String s : answerValues = new String(bvcom_answer).trim().split("&")) {
                    String[] tmp = s.trim().split("=");
                    paramVal.put(tmp[0], tmp[1]);
                }
                if (!paramVal.containsKey("status")) continue;
                String status = (String)paramVal.get("status");
                if (status.equals("approved")) {
                    Charge charge = new Charge();
                    charge.setDate(new Date());
                    charge.setComment("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u0435\u043d\u0435\u0433 \u0438\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b. \u041d\u043e\u043c\u0435\u0440 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438: " + transaction.getId());
                    charge.setContractId(transaction.getContractId());
                    charge.setSum(transaction.getSum());
                    charge.setUserId(-1);
                    charge.setTypeId(this.params.getChargeTypeId());
                    ChargeDao chargeDao = new ChargeDao(con);
                    chargeDao.update((Object)charge);
                    chargeDao.close();
                    ServerUtils.commitConnection((Connection)con);
                    bu.updateBalance(new Date(), transaction.getContractId());
                    EventProcessor.getInstance().publish((Event)new ChargeEvent(0, charge));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 4, charge.getSum()));
                    transaction.setStatus(TransactionStatus.RETURNED.getCode());
                } else if (status.equals("filtered")) {
                    transaction.setStatus(TransactionStatus.FILTERED.getCode());
                } else if (status.equals("declined")) {
                    transaction.setStatus(TransactionStatus.DECLINED.getCode());
                }
                manager.update(transaction);
            }
            manager.close();
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            this.error = e;
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c BVCom. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    private String getControlHash(String login, String orderId, String clientOrderId, String merchantControl) throws BGException {
        String result = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(login.getBytes());
            md.update(clientOrderId.getBytes());
            md.update(orderId.getBytes());
            md.update(merchantControl.getBytes());
            result = Utils.bytesToHexString((byte[])md.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

