/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.pub;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.card.server.action.pub.ActionIVRBase;
import ru.bitel.common.Utils;

public class ActionIVRGetBalance
extends ActionIVRBase {
    public void doAction() throws SQLException, BGException {
        String statPswd = this.request.getParameter("stat_pswd");
        String promptUrl = this.request.getParameter("prompt_url");
        int contractId = Utils.parseInt((String)this.request.getParameter("contract_id"));
        Element block = this.getBlockElement();
        Element statVar = this.createElement(block, "var");
        statVar.setAttribute("name", "status");
        String status = "internal_error";
        if (statPswd != null) {
            try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());
                 BalanceUtils bu = new BalanceUtils(this.con);){
                Contract contract = (Contract)contractDao.get(contractId);
                if (contract != null && contract.getPassword().equals(statPswd)) {
                    boolean minus = false;
                    String balance = "";
                    BigDecimal balanceSumm = bu.getBalance(LocalDate.now(), contractId);
                    if (balanceSumm.compareTo(BigDecimal.ZERO) < 1) {
                        balance = balanceSumm.negate().toPlainString();
                        minus = true;
                    } else {
                        balance = balanceSumm.toPlainString();
                    }
                    String prefix = promptUrl + "/ru_";
                    String suffix = ".au";
                    List<String> phrases = this.summaToString(balance);
                    phrases.add(0, "you_have");
                    if (minus) {
                        phrases.add(1, "minus");
                    }
                    Element prompt = this.createElement(block, "prompt");
                    prompt.setAttribute("bargein", "true");
                    for (String phrase : phrases) {
                        if (!Utils.notBlankString((String)phrase)) continue;
                        Element audio = this.createElement(prompt, "audio");
                        audio.setAttribute("src", prefix + phrase + ".au");
                    }
                    status = "ok";
                } else {
                    status = "error";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        statVar.setAttribute("expr", "'" + status + "'");
        Element returnEl = this.createElement(block, "return");
        returnEl.setAttribute("namelist", "status");
        this.sendResponse(block.getOwnerDocument());
    }

    private List<String> summaToString(String summa) {
        ArrayList<String> result = new ArrayList<String>();
        int rub = 0;
        int kop = 0;
        try {
            int i = summa.indexOf(".");
            rub = Integer.parseInt(summa.substring(0, i));
            kop = Integer.parseInt(summa.substring(i + 1));
        }
        catch (Exception i) {
            // empty catch block
        }
        if (rub > 999) {
            int ttt = (rub - 1000000 * (rub / 1000000)) / 1000;
            if (ttt > 99) {
                result.add(ActionIVRGetBalance.v3(ttt / 100));
            }
            if (ttt > 9) {
                result.add(ActionIVRGetBalance.v2(ttt - 100 * (ttt / 100)));
            }
            int r0 = (ttt - 100 * (ttt / 100)) / 10;
            int r1 = ttt - 10 * (ttt / 10);
            if (r0 != 1 && r1 != 0) {
                result.add(ActionIVRGetBalance.v0(r1, 0));
            }
            if (result.size() > 0) {
                r0 = ttt - 100 * (ttt / 100);
                if (r0 > 10 && r0 < 20) {
                    result.add("5-20_thousand");
                } else if (r1 == 1) {
                    result.add("thousand");
                } else if (r1 > 1 && r1 < 5) {
                    result.add("2-4_thousand");
                } else if (ttt > 0) {
                    result.add("5-20_thousand");
                }
                result.add(" ");
            }
        }
        if (rub > 99) {
            result.add(ActionIVRGetBalance.v3((rub - 1000 * (rub / 1000)) / 100));
        }
        if (rub > 9) {
            result.add(ActionIVRGetBalance.v2(rub - 100 * (rub / 100)));
        }
        int r0 = (rub - 100 * (rub / 100)) / 10;
        int r1 = rub - 10 * (rub / 10);
        if (r0 != 1 && r1 != 0 || rub == 0) {
            result.add(ActionIVRGetBalance.v0(r1, 1));
        }
        if ((r0 = rub - 100 * (rub / 100)) > 10 && r0 < 20) {
            result.add("5-20_dollars");
        } else if (r1 == 1) {
            result.add("dollar");
        } else if (r1 > 1 && r1 < 5) {
            result.add("2-4_dollars");
        } else {
            result.add("5-20_dollars");
        }
        if (kop > 9) {
            result.add(ActionIVRGetBalance.v2(kop - 100 * (kop / 100)));
        }
        int k0 = (kop - 100 * (kop / 100)) / 10;
        int k1 = kop - 10 * (kop / 10);
        if (k0 != 1 && k1 != 0 || kop == 0) {
            result.add(ActionIVRGetBalance.v0(k1, 0));
        }
        if (kop != 0) {
            if (kop != 11 && kop - 10 * (kop / 10) == 1) {
                result.add("cent");
            } else if (kop != 12 && kop - 10 * (kop / 10) == 2) {
                result.add("2-4_cents");
            } else if (kop != 13 && kop - 10 * (kop / 10) == 3) {
                result.add("2-4_cents");
            } else if (kop != 14 && kop - 10 * (kop / 10) == 4) {
                result.add("2-4_cents");
            } else {
                result.add("5-20_cents");
            }
        }
        return result;
    }

    private static final String v3(int value) {
        String[] result = new String[]{"", "100", "200", "300", "400", "500", "600", "700", "800", "900"};
        return value < 10 ? result[value] : "";
    }

    private static final String v2(int value) {
        String[] result = new String[]{"", "", "20", "30", "40", "50", "60", "70", "80", "90"};
        int i = value / 10;
        if (i == 1) {
            return ActionIVRGetBalance.v1(value - i * 10);
        }
        if (i > 1 && i < 10) {
            return result[i];
        }
        return "";
    }

    private static final String v1(int value) {
        String[] result = new String[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19"};
        return value < 10 ? result[value] : "";
    }

    private static final String v0(int value, int mode) {
        String[][] result = new String[][]{{"", "0"}, {"1_f", "1_m"}, {"2_f", "2_m"}, {"3", "3"}, {"4", "4"}, {"5", "5"}, {"6", "6"}, {"7", "7"}, {"8", "8"}, {"9", "9"}};
        return value < 10 && value > -1 && mode < 2 && mode > -1 ? result[value][mode] : "";
    }
}

