/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.StatusEventManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class StatusSetter
extends TaskBase {
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u043f\u0430\u043a\u0435\u0442\u043e\u0432. \u041a\u043e\u0434\u044b \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    protected boolean initTask() {
        boolean result = true;
        if (this.moduleId < 0) {
            result = false;
            this.getLogger().error("Param mid not found!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.getLogger().info("Cardpackets status updating...");
            this.updateStatusByEvents(con, conSlave, this.getOperatingTime());
        }
        catch (Exception e) {
            this.getLogger().error("error StatusSetter task", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }

    private void updateStatusByEvents(Connection con, Connection conSlave, Calendar time) throws SQLException, BGException {
        CardPacketManager cardPacketManager = new CardPacketManager(con, this.moduleId);
        StatusEventManager eventManager = new StatusEventManager(conSlave, this.moduleId);
        for (CardPacket cardPacket : cardPacketManager.getCardPacketList(time)) {
            StatusEvent lastEvent = eventManager.getLastEventBefore(cardPacket.getId(), time);
            if (lastEvent == null || lastEvent.getStatus() == cardPacket.getStatus()) continue;
            this.getLogger().info("Change status " + cardPacket.toString() + " event " + lastEvent.getStringStatus());
            cardPacket.setStatus(lastEvent.getStatus());
            cardPacketManager.updateCardPacket(cardPacket);
        }
    }
}

