/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.gar.server.service;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class GarServer {
    private static final Logger logger = LogManager.getLogger();
    private static final String GAR_SERVER_URI_TEST_ENVIRONMENT = "http://localhost:8081/bgdirectory/v1";
    private static final String GAR_SERVER_URI = "http://81.30.206.92:8114/bgdirectory/v1";

    protected String getRegionList() throws BGException {
        return this.sendRequest(this.createHttpRequestBuilder("/gar/directory/regions").GET().build());
    }

    protected String searchCitiesByContainsName(int regionId, String searchValue) throws BGException {
        JSONObject requestParams = new JSONObject();
        requestParams.put("regionId", regionId);
        requestParams.put("searchValue", (Object)searchValue);
        requestParams.put("type", (Object)"city");
        return this.sendRequest(this.createHttpRequestBuilder("/address/search", requestParams).GET().build());
    }

    protected String getGarCityInfoByCityId(long cityId) throws BGException {
        return this.sendRequest(this.createHttpRequestBuilder("/address/city/getCity/" + cityId).GET().build());
    }

    protected String getStreetsByCityId(long cityId) throws BGException {
        return this.sendRequest(this.createHttpRequestBuilder("/address/city/getFullCityInfo/" + cityId).GET().build());
    }

    protected String checkLoadedRegion(int regionId) throws BGException {
        return this.sendRequest(this.createHttpRequestBuilder("/gar/directory/unload/check/" + regionId).GET().build());
    }

    protected String getCitiesByRegionId(int regionId) throws BGException {
        return this.sendRequest(this.createHttpRequestBuilder("/address/city/citiesByRegionId/" + regionId).GET().build());
    }

    protected JSONObject getCoordinatesByAddress(String address) throws BGException {
        JSONObject parameters = new JSONObject();
        parameters.put("address", (Object)address);
        return new JSONObject(this.sendRequest(this.createHttpRequestBuilder("/geocoding/getCoordinatesByAddress/", parameters).GET().build()));
    }

    protected String getAddressByCoordinates(Double latitude, Double longitude) throws BGException {
        JSONObject parameters = new JSONObject();
        parameters.put("latitude", (Object)latitude);
        parameters.put("longitude", (Object)longitude);
        return this.sendRequest(this.createHttpRequestBuilder("/geocoding/getAddressByCoordinates/", parameters).GET().build());
    }

    protected void updateUserAuthData(String login, String pswd) throws BGException {
        JSONObject requestBody = new JSONObject();
        requestBody.put("username", (Object)login);
        requestBody.put("bgContractTitle", (Object)login);
        requestBody.put("password", (Object)pswd);
        this.sendRequest(this.createHttpRequestBuilder("/user/add", null, true).POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build());
    }

    protected String startLoadRegion(int regionId) throws BGException {
        JSONObject requestBody = new JSONObject();
        requestBody.put("regionId", regionId);
        requestBody.put("clearOldData", false);
        requestBody.put("username", (Object)Setup.getSetup().get("license.contract.title"));
        return this.sendRequest(this.createHttpRequestBuilder("/gar/directory/unload").POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build());
    }

    protected String sendRequest(HttpRequest request) throws BGException {
        if (request.method().equals("POST")) {
            request = HttpRequest.newBuilder(request, (n, v) -> true).timeout(Duration.ofSeconds(3L)).setHeader("Content-Type", "application/json").build();
        }
        try {
            HttpResponse<String> response = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435. \u041a\u043e\u0434:" + response.statusCode() + ", message:" + response.body());
            }
            return response.body();
        }
        catch (ConnectException ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u0439 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\u0438. " + ex);
        }
        catch (IOException | InterruptedException e) {
            throw new BGException((Throwable)e);
        }
    }

    private HttpRequest.Builder createHttpRequestBuilder(String endpointPath) throws BGException {
        return this.createHttpRequestBuilder(endpointPath, null);
    }

    private HttpRequest.Builder createHttpRequestBuilder(String endpointPath, JSONObject parameters) throws BGException {
        return this.createHttpRequestBuilder(endpointPath, parameters, false);
    }

    private HttpRequest.Builder createHttpRequestBuilder(String endpointPath, JSONObject parameters, boolean withoutAuthHeader) throws BGException {
        if (!((String)endpointPath).startsWith("/")) {
            endpointPath = "/" + (String)endpointPath;
        }
        Setup setup = Setup.getSetup();
        String username = setup.get("license.contract.title");
        if (parameters == null || !parameters.has("username")) {
            if (parameters == null) {
                parameters = new JSONObject();
            }
            parameters.put("username", (Object)username);
        }
        try {
            URI uri = new URI(GAR_SERVER_URI + (String)endpointPath + this.requestParametersToString(parameters));
            logger.debug("RequestURI:" + uri);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
            requestBuilder.timeout(Duration.ofSeconds(20L));
            if (!withoutAuthHeader) {
                requestBuilder.header("Authorization", this.getBasicAuthenticationHeader(username, setup.get("license.contract.password")));
            }
            return requestBuilder;
        }
        catch (URISyntaxException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getBasicAuthenticationHeader(String username, String password) {
        String valueToEncode = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(valueToEncode.getBytes());
    }

    private String requestParametersToString(JSONObject parameters) {
        String params = "";
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder("?");
            for (String key : parameters.keySet()) {
                String value = parameters.optString(key);
                if (!Utils.notBlankString((String)value)) continue;
                sb.append(key).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8)).append("&");
            }
            params = sb.toString();
            if (Utils.notBlankString((String)params)) {
                params = params.substring(0, params.length() - 1);
            }
        }
        return params;
    }
}

