/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.action;

import bitel.billing.server.util.PagedList;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.phone.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItem;
import ru.bitel.bgbilling.modules.phone.server.bean.ClientItemManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class ActionFindPhone
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        boolean sortType;
        int mid = this.getIntParameter("mid", -1);
        int sortBy = this.getIntParameter("sort", 0);
        boolean bl = sortType = this.getIntParameter("view", 1) != 2;
        if (mid < 0) {
            throw new BGIllegalArgumentException();
        }
        Page page = this.getPage();
        String number = this.getParameter("phone");
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        String mode = this.getParameter("mode", "equal");
        PagedList<ClientItem> itemList = new ClientItemManager(this.con, mid).findByNumber(number, date1, date2, sortBy, sortType, mode, page);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (ClientItem item : itemList.getList()) {
            Element element = this.createElement(data, "row");
            element.setAttribute("f0", String.valueOf(item.getContractId()));
            element.setAttribute("f1", item.getContractTitle());
            element.setAttribute("f2", item.getContractComment());
            element.setAttribute("f3", Utils.toString(item.getClientNumbers()));
            element.setAttribute("f4", TimeUtils.formatPeriod((Calendar)item.getDate1(), (Calendar)item.getDate2()));
            element.setAttribute("f5", item.getComment());
        }
        table.setAttribute("allRecord", String.valueOf(itemList.getRecordsCount()));
        this.setPageAttribute(table, itemList.getPage());
    }
}

