/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.forpost;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.EditorTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ContractTitlePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.EditorLabel;
import ru.bitel.bgbilling.modules.smarthouse.client.common.ParamTableRow;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostContractBasePanel;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTable;
import ru.bitel.bgbilling.modules.smarthouse.client.forpost.ForpostParamTableModel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostObject;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;

public class ForpostContractObjectPanel
extends ForpostContractBasePanel {
    private ObjectTableModel tableModel;

    @Override
    protected void jbInit() throws Exception {
        Dimension dimension = new Dimension(300, 100);
        JScrollPane scrollPane = new JScrollPane((Component)this.getTable());
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add(new ContractTitlePanel("\u041e\u0431\u044a\u0435\u043a\u0442\u044b:", (JComponent)((Object)this)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void deleteAccountObjects(int accountId) throws BGMessageException, BGException {
        this.getForpostService().forpostAccountObjectDelete(accountId);
    }

    @Override
    protected BGTableModel<?> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ObjectTableModel(ObjectTableModel.class.getName());
        }
        return this.tableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.getObjectDialog(this.getForpostService().forpostObjectDefaultGet()).setVisible(true));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            ForpostObject forpostObject = (ForpostObject)((ObjectTableModel)this.getTableModel()).getSelectedRow();
            if (forpostObject == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041e\u0431\u044a\u0435\u043a\u0442\" \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
            } else {
                this.getObjectEditDialog(forpostObject).setVisible(true);
                this.performAction("object.refresh");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ForpostObject forpostObject = (ForpostObject)((ObjectTableModel)this.getTableModel()).getSelectedRow();
            if (forpostObject == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u041e\u0431\u044a\u0435\u043a\u0442\" \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f.");
            } else if (ClientUtils.confirmDelete((Object)forpostObject.getName())) {
                this.getForpostService().forpostObjectDelete(forpostObject.getId());
                this.performAction("object.refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("object.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c", ICON_REFRESH){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((ObjectTableModel)ForpostContractObjectPanel.this.getTableModel()).setData(ForpostContractObjectPanel.this.getForpostService().forpostAccountObjectSearch(ForpostContractObjectPanel.this.accountId).getList());
            }
        };
    }

    private JDialog getObjectDialog(ForpostObject forpostObject) {
        EditorTextField objectName = new EditorTextField(30, "\u0421\u0442\u0440\u043e\u043a\u0430<br>\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", this.focusListener);
        EditorTextField objectAddress = new EditorTextField(30, "\u0421\u0442\u0440\u043e\u043a\u0430<br>\u0410\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u043e\u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f", this.focusListener);
        Component[][] components = new Component[][]{{new EditorLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430"), objectName}, {new EditorLabel("\u0410\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u043e\u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f"), objectAddress}};
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        ClientUtils.addComponentToPanel((JPanel)panel, (int)gridy, (Component[][])components, (boolean)true);
        objectName.setText(String.valueOf(forpostObject.getName() != null ? forpostObject.getName() : ""));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            Color color = Color.YELLOW;
            boolean error = this.checkTextField(objectName, color, false);
            if (error) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439.");
                return;
            }
            forpostObject.setAccountId(this.accountId);
            forpostObject.setName(objectName.getText());
            forpostObject.setAddress(objectAddress.getText());
            try {
                int id = this.getForpostService().forpostObjectAdd(forpostObject);
                this.performAction("object.refresh");
                this.getTableModel().setSelectedRow(Integer.valueOf(id));
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        });
        return dialog;
    }

    private JDialog getObjectEditDialog(final ForpostObject forpostObject) {
        final ForpostParamTableModel paramTableModel = new ForpostParamTableModel();
        CellEditorListener cellEditorListener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                ParamTableRow tableRow = (ParamTableRow)paramTableModel.getSelectedRow();
                try {
                    ForpostContractObjectPanel.this.getForpostService().forpostObjectParamUpdate(forpostObject.getId(), tableRow.getName(), tableRow.getValue());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        };
        ForpostParamTable paramTable = new ForpostParamTable((TableModel)((Object)paramTableModel), cellEditorListener);
        paramTable.setContext((ClientContext)this.getContext());
        paramTableModel.addRow(new ParamTableRow("Name", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", forpostObject.getName()));
        paramTableModel.addRow(new ParamTableRow("Address", "\u0410\u0434\u0440\u0435\u0441 \u043c\u0435\u0441\u0442\u043e\u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f", forpostObject.getAddress()));
        paramTableModel.addRow(new ParamTableRow("Lat", "\u0428\u0438\u0440\u043e\u0442\u0430", forpostObject.getString("Lat")));
        paramTableModel.addRow(new ParamTableRow("Lon", "\u0414\u043e\u043b\u0433\u043e\u0442\u0430", forpostObject.getString("Lon")));
        int gridy = 0;
        Dimension dimension = new Dimension(600, 100);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)new JScrollPane((Component)((Object)paramTable)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", new JButton[]{new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c")});
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> dialog.setVisible(false));
        return dialog;
    }

    class ObjectTableModel
    extends BGTableModel<ForpostObject> {
        public ObjectTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 200, 300, 400, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u0434\u0440\u0435\u0441", -1, -1, -1, "address", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

