/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransaction;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransactionLog;
import ru.bitel.bgbilling.modules.softkey.common.service.SoftkeyService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;

public class SoftkeyMonitorTransactionsPanel
extends BGUPanel {
    private BGUTable transactionTable;
    private BGTableModel<SoftkeyTransaction> transactionModel;
    private BGTableModel<SoftkeyTransactionLog> logModel;
    private BGPanel filterPanel;
    private BGTextField contractTitleTextField;
    private BGComboBox<ComboBoxItem> statusComboBox;
    private BGControlPanelDateNoB fromDate;
    private BGControlPanelDateNoB toDate;
    private BGButton goButton;

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.transactionModel = new BGTableModel<SoftkeyTransaction>("SoftkeyTransactionMonitor"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", -1, 200, 200, "contractTitle", true);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "optionTitle", false);
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 200, 200, "statusTitle", true);
                this.addColumn("\u0414\u0430\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430", Column.DateTime.class, -1, 200, 200, "dt", true);
                this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", -1, 200, 200, "subscribeCount");
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", -1, 200, 200, "subscribeAmount");
            }
        };
        this.transactionTable = new BGUTable(this.transactionModel);
        this.transactionTable.setSelectionMode(0);
        this.transactionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        this.logModel = new BGTableModel<SoftkeyTransactionLog>("SoftkeyTransactionLogMonitor"){

            protected void initColumns() {
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "status");
                this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", -1, -1, -1, "logDate");
            }
        };
        this.filterPanel = new BGPanel();
        this.filterPanel.setLayout((LayoutManager)new GridBagLayout());
        this.filterPanel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        this.fromDate = new BGControlPanelDateNoB();
        this.toDate = new BGControlPanelDateNoB();
        this.contractTitleTextField = new BGTextField();
        this.statusComboBox = new BGComboBox();
        this.goButton = new BGButton("\u041f\u043e\u0438\u0441\u043a");
        LocalDate now = LocalDate.now();
        this.fromDate.setLocalDate(now.withDayOfMonth(1));
        this.toDate.setLocalDate(now);
        this.statusComboBox.addItem((Object)new ComboBoxItem(1, "\u0410\u043a\u0442\u0438\u0432\u043d\u0430"));
        this.statusComboBox.addItem((Object)new ComboBoxItem(2, "\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430"));
        this.statusComboBox.addItem((Object)new ComboBoxItem(3, "\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u0430"));
        this.statusComboBox.setSelectedIndex(0);
        this.filterPanel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440"), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.contractTitleTextField, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434  \u0441 "), (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.fromDate, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)new JLabel("  \u043f\u043e  "), (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.toDate, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441"), (Object)new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add(this.statusComboBox, (Object)new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.goButton, (Object)new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.filterPanel.add(Box.createHorizontalGlue(), (Object)new GridBagConstraints(9, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.filterPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.transactionTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoftkeyMonitorTransactionsPanel.this.performAction("refresh");
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            String contractTitle = this.contractTitleTextField.getText();
            Date fromDateValue = TimeUtils.convertCalendarToDate((Calendar)this.fromDate.getDateCalendar());
            Date toDateValue = TimeUtils.convertCalendarToDate((Calendar)this.toDate.getDateCalendar());
            int status = Utils.parseInt((String)this.statusComboBox.getSelectedId(), (int)1);
            List transactionList = ((SoftkeyService)((ClientContext)this.getContext()).getPort(SoftkeyService.class)).getTransactionList(contractTitle, status, fromDateValue, toDateValue);
            if (transactionList != null) {
                this.transactionModel.setData(transactionList);
            }
        });
        new AbstractBGUPanel.DefaultAction("GETLOG", "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SoftkeyTransaction transaction = (SoftkeyTransaction)SoftkeyMonitorTransactionsPanel.this.transactionModel.getSelectedRow();
                if (transaction != null) {
                    List transactionLogList = ((SoftkeyService)((ClientContext)SoftkeyMonitorTransactionsPanel.this.getContext()).getPort(SoftkeyService.class)).getTransactionLog(transaction.getId());
                    SoftkeyMonitorTransactionsPanel.this.logModel.setData(transactionLogList);
                }
            }
        };
    }
}

