/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.tv.common.event.access.om.OmTvAccountOptionsModifyEvent;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountSpecRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public class TvAccountRuntimeRoot
extends TvAccountRuntime {
    private static final Logger logger = LogManager.getLogger();
    final ContractRuntime contractRuntime;
    volatile TariffModuleTreeSet tariffTreeSet;
    volatile ProductRuntimeList productRuntimeList;
    volatile ProductPeriodRuntimeList productPeriodItemList;
    volatile ServiceRuntimeList serviceRuntimeList;
    public Set<Integer> tvOptions;
    public long tvOptionsMillis;

    TvAccountRuntimeRoot(int tvAccountId, AtomicReference<TvAccountSpecRuntime> servTypeRef, ContractRuntime contractRuntime) {
        super(tvAccountId, servTypeRef, null);
        this.contractRuntime = contractRuntime;
    }

    @Override
    public ContractRuntime getContractRuntime() {
        return this.contractRuntime;
    }

    @Override
    public TariffModuleTreeSet getTariffTreeSet() {
        return this.tariffTreeSet;
    }

    @Override
    public ProductRuntimeList getProductRuntimeList() {
        assert (this.contractRuntime.isHeldByCurrentThread());
        return this.productRuntimeList;
    }

    @Override
    public ProductPeriodRuntimeList getProductPeriodRuntimeList() {
        assert (this.contractRuntime.isHeldByCurrentThread());
        return this.productPeriodItemList;
    }

    public void setProductPeriodRuntimeList(ProductPeriodRuntimeList productPeriodRuntimeList) {
        assert (this.contractRuntime.isHeldByCurrentThread());
        this.productPeriodItemList = productPeriodRuntimeList;
    }

    @Override
    public ServiceRuntimeList getServiceRuntimeList() {
        assert (this.contractRuntime.isHeldByCurrentThread());
        return this.serviceRuntimeList;
    }

    public void setServiceRuntimeList(ServiceRuntimeList serviceRuntimeList) {
        assert (this.contractRuntime.isHeldByCurrentThread());
        this.serviceRuntimeList = serviceRuntimeList;
    }

    @Override
    public final void lock() {
        this.contractRuntime.lock();
    }

    @Override
    public final boolean tryLock() {
        return this.contractRuntime.tryLock();
    }

    @Override
    public final boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.contractRuntime.tryLock(timeout, unit);
    }

    @Override
    public final void unlock() {
        this.contractRuntime.unlock();
    }

    @Override
    public final boolean isHeldByCurrentThread() {
        return this.contractRuntime.isHeldByCurrentThread();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(200);
        result.append("ContractId: ");
        result.append(this.getTvAccount().getContractId());
        result.append("; tvAccountId: ");
        result.append(this.tvAccountId);
        result.append("\n\t");
        result.append(String.valueOf(this.getTvAccount()));
        result.append("\n\t");
        result.append("Products [");
        for (ProductPeriodRuntimeList.ProductPeriodItem periodItem : this.productPeriodItemList.items()) {
            result.append(periodItem.productId);
            result.append(":");
            result.append(TimeUtils.formatPeriod((Date)new Date(periodItem.timeFrom), (Date)new Date(periodItem.timeTo)));
            result.append("; ");
        }
        result.append("] ");
        result.append(this.getTariffTreeSet());
        result.append("\n\t");
        result.append("Device state: ");
        result.append(this.getTvAccount().getDeviceState());
        result.append("; serviceIds:");
        result.append(Utils.toString((Iterable)this.getTvAccount().getDeviceOptionIds()));
        return result.toString();
    }

    public boolean processOptionsModified(ServerContext context, int moduleId, long now, Set<Integer> tvOptions) throws BGException {
        long div;
        if (this.tvOptions != null && this.tvOptions.equals(tvOptions) && (div = now - this.tvOptionsMillis) < TimeUnit.HOURS.toMillis(3L)) {
            return false;
        }
        this.tvOptions = tvOptions.size() > 0 ? DEVICE_OPTIONS_SET_CACHE.intern(tvOptions) : Collections.emptySet();
        this.tvOptionsMillis = now;
        if (logger.isInfoEnabled()) {
            logger.info("Sending event to modify tvAccount[" + this.tvAccountId + "] options to: " + Utils.toString(tvOptions));
        }
        OmTvAccountOptionsModifyEvent e = new OmTvAccountOptionsModifyEvent(moduleId, this.contractRuntime.contractId, 0, this.getTvAccount().getDeviceId(), this.tvAccountId, tvOptions);
        if (context == null) {
            EventProcessor ep = EventProcessor.getInstance();
            ep.publish((Event)e);
        } else {
            context.publishAfterCommit((Event)e);
        }
        return true;
    }
}

