/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceCostMapDao
extends AbstractIdDao<VoiceCostMap> {
    private static final String COST_MAP_TABLE_NAME = "voice_cost_map";

    public VoiceCostMapDao(Connection con, int mid) {
        super(con, mid, COST_MAP_TABLE_NAME);
    }

    protected VoiceCostMap getFromRS(ResultSet rs) throws SQLException, BGException {
        return VoiceCostMap.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setOperatorId(rs.getInt("operatorId")).build();
    }

    protected void updateImpl(VoiceCostMap voiceCostMap) throws BGException, SQLException {
        boolean update = voiceCostMap.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, comment=?, operatorId=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, voiceCostMap.getTitle());
            ps.setString(index++, voiceCostMap.getComment());
            if (voiceCostMap.getOperatorId() > 0) {
                ps.setInt(index++, voiceCostMap.getOperatorId());
            } else {
                ps.setNull(index++, 4);
            }
            if (update) {
                ps.setInt(index++, voiceCostMap.getId());
            }
            ps.executeUpdate();
            if (!update) {
                voiceCostMap.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<VoiceCostMap> list(int operatorId) throws BGException {
        return super.list("operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL "), "id", new Object[0]);
    }
}

