/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.radius;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.voiceip.server.bean.FindMode;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginType;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpRadiusProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class FindLoginProcessor {
    private static final Logger logger = LogManager.getLogger();
    private Map<Integer, String> modeTypesMapAuo = new HashMap<Integer, String>();
    private Map<Integer, String> modeTypesMapAui = new HashMap<Integer, String>();
    private Map<Integer, String> modeTypesMapAco = new HashMap<Integer, String>();
    private Map<Integer, String> modeTypesMapAci = new HashMap<Integer, String>();
    private Map<Integer, FindModeItem> modeItemMap = new HashMap<Integer, FindModeItem>();
    private List<FindModeItem> modeList = new ArrayList<FindModeItem>();
    private Map<Integer, LoginType> typeMap = new HashMap<Integer, LoginType>();
    private String loginTableName;
    private String aliasTableName;

    public FindLoginProcessor(Setup setup, int moduleId, List<LoginType> typeList, Map<Integer, FindMode> modeMap, List<Integer> modesOrder) {
        this.loginTableName = "user_login_" + moduleId;
        this.aliasTableName = "user_alias_" + moduleId;
        for (FindMode mode : modeMap.values()) {
            FindModeItem item = new FindModeItem(mode);
            this.modeItemMap.put(mode.getId(), item);
            for (LoginType type : typeList) {
                if (type.getFindModeAuthOut() == mode.getId()) {
                    this.addType(mode, type, this.modeTypesMapAuo);
                }
                if (type.getFindModeAuthIn() == mode.getId()) {
                    this.addType(mode, type, this.modeTypesMapAui);
                }
                if (type.getFindModeAcctOut() == mode.getId()) {
                    this.addType(mode, type, this.modeTypesMapAco);
                }
                if (type.getFindModeAcctIn() != mode.getId()) continue;
                this.addType(mode, type, this.modeTypesMapAci);
            }
        }
        for (LoginType type : typeList) {
            this.typeMap.put(type.getId(), type);
        }
        for (Integer modeId : modesOrder) {
            FindMode mode = modeMap.get(modeId);
            if (logger.isDebugEnabled()) {
                logger.debug("FindMode={}", (Object)mode);
            }
            if (mode == null) continue;
            this.modeList.add(new FindModeItem(mode));
        }
    }

    private void addType(FindMode mode, LoginType type, Map<Integer, String> mapToAdd) {
        if (mapToAdd != null) {
            Object currentValue = mapToAdd.get(mode.getId());
            currentValue = currentValue == null ? String.valueOf(type.getId()) : (String)currentValue + "," + String.valueOf(type.getId());
            mapToAdd.put(mode.getId(), (String)currentValue);
        }
    }

    public VoiceIpLogin findLogin(RadiusPacket request, Connection con, int mode, java.util.Date date) {
        VoiceIpLogin result;
        block2: {
            FindModeItem item;
            block1: {
                result = null;
                if (mode < 0) break block1;
                FindModeItem item2 = this.modeItemMap.get(mode);
                if (item2 == null) break block2;
                result = item2.getLogin(request, con, date);
                break block2;
            }
            Iterator<FindModeItem> iterator = this.modeList.iterator();
            while (iterator.hasNext() && (result = (item = iterator.next()).getLogin(request, con, date)) == null) {
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FindModeItem item : this.modeList) {
            sb.append(item.toString());
            sb.append(" ");
        }
        return sb.toString();
    }

    private class FindModeItem {
        private static final int EQ_LOGIN = 1;
        private static final int EQ_ALIAS = 2;
        private int eq = 1;
        private RadiusAttributeInfo<?> ap;
        private int modeId;

        public FindModeItem(FindMode findMode) {
            this.modeId = findMode.getId();
            String[] attr_value = findMode.getValue().split("=");
            String attr = attr_value[0];
            String value = attr_value[1];
            this.ap = RadiusDictionary.findAttributeInfo((String)attr);
            this.eq = value.equals("ALIAS") ? 2 : 1;
        }

        public VoiceIpLogin getLogin(RadiusPacket request, Connection con, java.util.Date date) {
            VoiceIpLogin result = null;
            Date sqlDate = TimeUtils.convertDateToSqlDate((java.util.Date)date);
            if (this.ap == null) {
                return null;
            }
            RadiusAttribute ra = null;
            List attributes = request.getAttributes(this.ap.vendor, this.ap.type);
            if (attributes != null) {
                ra = (RadiusAttribute)attributes.get(0);
            }
            if (ra == null) {
                return null;
            }
            String types = this.getTypes(request);
            if (Utils.isBlankString((String)types)) {
                return null;
            }
            String attributeValue = ra.toString();
            try {
                String query = null;
                PreparedStatement ps = null;
                if (this.eq == 1) {
                    query = "SELECT * FROM " + FindLoginProcessor.this.loginTableName + " WHERE login=? AND type IN ( " + types + ") AND ( isNull(date1) OR date1<=?) AND ( isNull(date2) OR date2>=? )";
                    long loginValue = Utils.parseLong((String)attributeValue, (long)-1L);
                    if (loginValue >= 0L) {
                        ps = con.prepareStatement(query);
                        ps.setLong(1, loginValue);
                        ps.setDate(2, sqlDate);
                        ps.setDate(3, sqlDate);
                        ResultSet rs = ps.executeQuery();
                        if (rs.next()) {
                            result = new VoiceIpLogin();
                            this.loadLoginFromResultSet(result, rs);
                        }
                        ps.close();
                    }
                } else {
                    query = "SELECT login.* FROM " + FindLoginProcessor.this.aliasTableName + " AS alias  INNER JOIN " + FindLoginProcessor.this.loginTableName + " AS login ON alias.login_id=login.id  WHERE alias.login_alias=?  AND login.type IN (" + types + ")  AND ( isNull(login.date1) OR login.date1<=? )  AND ( isNull(login.date2) OR login.date2>=? )";
                    ps = con.prepareStatement(query);
                    ps.setString(1, attributeValue);
                    ps.setDate(2, sqlDate);
                    ps.setDate(3, sqlDate);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        result = new VoiceIpLogin();
                        this.loadLoginFromResultSet(result, rs);
                    }
                    ps.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        private String getTypes(RadiusPacket request) {
            String types = null;
            if ((Integer)request.getOption(VoiceIpRadiusProcessor.CALL_TYPE) == 1) {
                if (request.getCode() == 1) {
                    types = FindLoginProcessor.this.modeTypesMapAuo.get(this.modeId);
                } else if (request.getCode() == 4) {
                    types = FindLoginProcessor.this.modeTypesMapAco.get(this.modeId);
                }
            } else if (request.getCode() == 1) {
                types = FindLoginProcessor.this.modeTypesMapAui.get(this.modeId);
            } else if (request.getCode() == 4) {
                types = FindLoginProcessor.this.modeTypesMapAci.get(this.modeId);
            }
            return types;
        }

        private void loadLoginFromResultSet(VoiceIpLogin login, ResultSet rs) throws SQLException {
            login.setId(rs.getInt("id"));
            login.setContractId(rs.getInt("cid"));
            login.setLogin(rs.getLong("login"));
            login.setPswd(rs.getString("pswd"));
            login.setStatus(rs.getInt("status") == 0);
            login.setType(rs.getInt("type"));
            LoginType type = FindLoginProcessor.this.typeMap.get(login.getType());
            login.importTypeOptions(type);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.ap != null) {
                sb.append(this.ap.name);
            } else {
                sb.append("<!NULL ATTRIBUTE!>");
            }
            if (this.eq == 1) {
                sb.append("=LOGIN");
            } else {
                sb.append("=ALIAS");
            }
            return sb.toString();
        }
    }
}

