/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.event.worker;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class YoomoneyCheckEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;

    public YoomoneyCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), YoomoneyCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting YoomoneyCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "yoomoney-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.transactionManager.close();
            this.transactionManager = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        YoomoneyCheckEvent event = (YoomoneyCheckEvent)((Object)task);
        this.transactionManager.doCheckRequest(event.getObjectId());
        return null;
    }
}

