/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.action.web;

import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionButton;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantField;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantFieldType;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantActionDao;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantMasterDao;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantRequest;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponse;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantResponseStatus;

@WebAction(title="\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a")
public class ActionAssistant
extends AbstractAction {
    public ActionAssistant() {
        super("assistant");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        this.setResultParam("pageTitle", "\u041f\u043e\u043c\u043e\u0449\u043d\u0438\u043a - \u041c\u0430\u0441\u0442\u0435\u0440");
        this.setResultParam("masterId", this.req.getInt("masterId", -1));
        this.setResultParam("jspPage", this.moduleName + "/lk_body.jsp");
    }

    @WebOperation(title="\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043c\u0430\u0441\u0442\u0435\u0440\u0430")
    public void masterDoButton() throws BGException {
        AssistantButton assistantButton = AssistantButton.getAssistantButtonByCode((String)this.req.get("buttonCode"));
        if (assistantButton == null) {
            throw new BGException("assistantButton == null");
        }
        int masterId = this.req.getInt("masterId", -1);
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(this.con);
             AssistantActionDao assistantActionDao = new AssistantActionDao(this.con);){
            AssistantMaster assistantMaster = (AssistantMaster)assistantMasterDao.get(masterId);
            if (assistantMaster == null) {
                throw new BGMessageException("\u041c\u0430\u0441\u0442\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            if (!assistantMaster.isShowWebLKAssistant()) {
                throw new BGMessageException("\u041c\u0430\u0441\u0442\u0435\u0440 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0432 \u041b\u041a");
            }
            String actionId = this.req.get("actionId");
            actionId = actionId != null ? actionId : assistantMaster.getStartActionId();
            AssistantAction assistantAction = assistantActionDao.getByActionId(actionId, assistantMaster.getActionIds());
            if (assistantAction == null) {
                throw new BGMessageException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e [#" + actionId + "]");
            }
            try {
                ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction action = DynamicClassManager.getInstance().loadClass(assistantAction.getActionClass()).asSubclass(ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                JSONObject config = new JSONObject(assistantAction.getConfig());
                JSONObject fieldsData = new JSONObject();
                for (AssistantField assistantField : this.getAssistantFields(config)) {
                    fieldsData.put(assistantField.getKey(), (Object)this.req.get("field_" + assistantField.getKey()));
                }
                JSONObject formData = new JSONObject();
                formData.put("fields", (Object)fieldsData);
                formData.put("contractId", this.contractId);
                AssistantRequest assistantRequest = new AssistantRequest(assistantAction, formData.toString(), assistantButton);
                AssistantResponse assistantResponse = action.doAction(assistantRequest);
                if (assistantResponse.getStatus() == AssistantResponseStatus.OK) {
                    actionId = assistantResponse.getNextActionId();
                    if (actionId == null) {
                        actionId = this.getDefaultNextActionId(assistantAction.getConfig());
                    }
                    HashMap<String, String> queryParam = new HashMap<String, String>();
                    queryParam.put("actionId", actionId);
                    queryParam.put("masterUUID", UUID.randomUUID().toString());
                    this.setResultParam("masterId", masterId);
                    this.setResultParam("masterActionId", actionId);
                    this.setResultParam("operation", "masterDoShow");
                    this.setResultParam("queryParam", queryParam);
                } else {
                    ActionMessage message = new ActionMessage("contentRoot", "masterDoButton", "", "");
                    message.setTitle(assistantResponse.getErrorTitle());
                    message.setText(assistantResponse.getError());
                    message.setOnClose("close");
                    this.setResultParam("message", message);
                }
            }
            catch (Exception ex) {
                throw new BGMessageException(ex.getMessage());
            }
            this.masterDoShow();
        }
    }

    @WebOperation(title="\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u043c\u0430\u0441\u0442\u0435\u0440\u0430")
    public void masterDoShow() throws BGException {
        int masterId = this.req.getInt("masterId", -1);
        try (AssistantMasterDao assistantMasterDao = new AssistantMasterDao(this.con);
             AssistantActionDao assistantActionDao = new AssistantActionDao(this.con);){
            AssistantAction assistantAction;
            AssistantMaster assistantMaster = (AssistantMaster)assistantMasterDao.get(masterId);
            if (assistantMaster == null) {
                throw new BGMessageException("\u041c\u0430\u0441\u0442\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            if (!assistantMaster.isShowWebLKAssistant()) {
                throw new BGMessageException("\u041c\u0430\u0441\u0442\u0435\u0440 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0432 \u041b\u041a");
            }
            String masterUUID = Optional.ofNullable((String)this.getResultParam("masterUUID")).orElse(this.req.get("masterUUID"));
            String actionId = Optional.ofNullable((String)this.getResultParam("masterActionId")).orElse(this.req.get("actionId"));
            if (actionId == null) {
                actionId = assistantMaster.getStartActionId();
                HttpSession httpSession = this.context.getRequest().getSession(true);
                masterUUID = (String)httpSession.getAttribute("masterUUID");
                if (masterUUID != null) {
                    httpSession.removeAttribute(masterUUID);
                }
                masterUUID = UUID.randomUUID().toString();
                httpSession.setAttribute("masterUUID", (Object)masterUUID);
                httpSession.setAttribute(masterUUID, (Object)"{}");
            }
            if ((assistantAction = assistantActionDao.getByActionId(actionId, assistantMaster.getActionIds())) == null) {
                throw new BGMessageException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e [#" + actionId + "]");
            }
            AssistantResponse assistantResponse = null;
            try {
                if (assistantAction.getActionClass() != null) {
                    ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction action = DynamicClassManager.getInstance().loadClass(assistantAction.getActionClass()).asSubclass(ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantAction.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    HttpSession httpSession = this.context.getRequest().getSession(true);
                    if (masterUUID == null) {
                        masterUUID = (String)httpSession.getAttribute("masterUUID");
                    }
                    String data = "{}";
                    if (masterUUID != null) {
                        data = (String)httpSession.getAttribute(masterUUID);
                    }
                    assistantResponse = action.showAction(new AssistantRequest(assistantAction, data));
                }
            }
            catch (Exception ex) {
                throw new BGMessageException(ex.getMessage());
            }
            JSONObject config = new JSONObject(assistantAction.getConfig());
            List<AssistantField> assistantFields = this.getAssistantFields(config);
            if (assistantResponse != null) {
                Map<String, Object> map = assistantResponse.getFieldValues();
                assistantFields.forEach(a -> {
                    if (a.getType() == AssistantFieldType.COMBOX || a.getType() == AssistantFieldType.LIST) {
                        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
                        Object patt9733$temp = map.get(a.getKey());
                        if (patt9733$temp instanceof JSONArray) {
                            JSONArray value = (JSONArray)patt9733$temp;
                            for (int index = 0; index < value.length(); ++index) {
                                JSONObject itemJson = value.getJSONObject(index);
                                list.add(new KeyValue(itemJson.getString("key"), itemJson.getString("value")));
                                if (!itemJson.optString("selected", "false").equals("true")) continue;
                                a.setValue(itemJson.getString("key"));
                            }
                        }
                        a.setValues(list);
                    } else {
                        a.setValue(String.valueOf(map.getOrDefault(a.getKey(), a.getValue())));
                    }
                });
            }
            this.setResultParam("master", assistantMaster);
            this.setResultParam("masterUUID", masterUUID);
            this.setResultParam("masterAction", assistantAction);
            this.setResultParam("masterActionComment", config.optString("comment"));
            this.setResultParam("masterFields", assistantFields);
            this.setResultParam("masterButtons", this.getActionButtons(config.optJSONObject("options")));
            this.requestDispatcher(this.moduleName, "lk_master_show");
        }
    }

    private List<AssistantField> getAssistantFields(JSONObject config) {
        ArrayList<AssistantField> assistantFields = new ArrayList<AssistantField>();
        JSONArray params = config.optJSONArray("params");
        if (params != null) {
            params.forEach(a -> assistantFields.add(AssistantField.builder().setKey(((JSONObject)a).getString("key")).setType(AssistantFieldType.getAssistantFieldTypeByCode((String)((JSONObject)a).getString("type"))).setTitle(((JSONObject)a).getString("title")).setValue(((JSONObject)a).getString("value")).setComment(((JSONObject)a).getString("comment")).build()));
        }
        return assistantFields;
    }

    private List<AssistantActionButton> getActionButtons(JSONObject options) {
        ArrayList<AssistantActionButton> assistantButtons = new ArrayList<AssistantActionButton>();
        for (String key : new String[]{"1", "2", "3", "4", "Cancel"}) {
            if (!options.optBoolean("windowShowButton" + key, false)) continue;
            AssistantButton assistantButton = AssistantButton.getAssistantButtonByCode((String)(key.equals("Cancel") ? "cancel" : "button" + key));
            AssistantActionButton actionButton = new AssistantActionButton(assistantButton);
            actionButton.setTitle(options.optString("windowTextButton" + key, null));
            assistantButtons.add(actionButton);
        }
        return assistantButtons;
    }

    private String getDefaultNextActionId(String configData) {
        JSONObject config;
        JSONObject optionsJsonObject;
        String nextActionId = null;
        if (configData != null && (optionsJsonObject = (config = new JSONObject(configData)).optJSONObject("options")) != null && optionsJsonObject.has("nextActionId")) {
            nextActionId = optionsJsonObject.optString("nextActionId");
        }
        return nextActionId;
    }
}

