/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantActionBaseDialog;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantActionDialog;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantListCellRenderer;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.common.Preferences;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.list.BGUList;

public class AssistantMasterListDialog
extends AssistantActionBaseDialog {
    private BGToolBar toolBar = new BGToolBar();
    private BGUList<AssistantMaster> list = new BGUList();
    private JPanel buttonPanel = new JPanel(new FlowLayout(0));
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private JScrollPane iconsPanel = new JScrollPane();

    public AssistantMasterListDialog(ClientContext clientContext) {
        super(clientContext);
        this.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435");
        this.initToolBar();
        this.initCardPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.cardPanel, "Center");
        this.pack();
        Preferences preferences = ClientSetup.getInstance().getUserConfig();
        int width = preferences.getInt("assistant.actions.dialog.width", 800);
        int height = preferences.getInt("assistant.actions.dialog.height", 400);
        this.setSize(width, height);
        this.moveWindowToCenterScreen();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dimension = AssistantMasterListDialog.this.getSize();
                Preferences preferences = ClientSetup.getInstance().getUserConfig();
                preferences.set("assistant.actions.dialog.width", String.valueOf(dimension.width));
                preferences.set("assistant.actions.dialog.height", String.valueOf(dimension.height));
                ClientSetup.getInstance().saveUserConfig();
                dimension.width -= 100;
                dimension.height = AssistantMasterListDialog.this.buttonPanel.getSize().height - 10;
                AssistantMasterListDialog.this.buttonPanel.setPreferredSize(dimension);
                AssistantMasterListDialog.this.buttonPanel.revalidate();
                AssistantMasterListDialog.this.buttonPanel.repaint();
            }
        });
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        this.list.setCellRenderer((ListCellRenderer)new AssistantListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AssistantMaster assistantMaster;
                if (mouseEvent.getClickCount() == 2 && (assistantMaster = (AssistantMaster)AssistantMasterListDialog.this.list.getSelectedValue()) != null) {
                    AssistantMasterListDialog.this.openAssistantActionDialog(assistantMaster.getId(), assistantMaster.getStartActionId());
                }
            }
        });
        try {
            HashSet<String> modes = new HashSet<String>();
            modes.add("client");
            if (this.getContext().getContractId() > 0) {
                modes.add("contract");
            }
            List assistantMasters = this.getAssistantService().assistantMastersForUser(modes, this.getContext().getContractId());
            this.list.setData(assistantMasters);
            Dimension dimension = new Dimension(250, 80);
            int size = assistantMasters.size();
            for (int index = 0; index < size; ++index) {
                AssistantMaster assistantMaster = (AssistantMaster)assistantMasters.get(index);
                ImageIcon icon = assistantMaster.getIconData() != null ? new ImageIcon(Base64.getDecoder().decode(assistantMaster.getIconData())) : ClientUtils.getIcon((String)"assistant_default.png");
                JButton button = new JButton("<html>" + assistantMaster.getTitle() + "</html>", icon);
                button.setBackground(UIManager.getColor("TextField.background"));
                button.setCursor(Cursor.getPredefinedCursor(12));
                button.setFocusPainted(false);
                button.setMargin(new Insets(5, 5, 5, 5));
                button.setActionCommand(assistantMaster.getStartActionId());
                button.addActionListener(e -> this.openAssistantActionDialog(assistantMaster.getId(), e.getActionCommand()));
                button.setMinimumSize(dimension);
                button.setPreferredSize(dimension);
                button.setMaximumSize(dimension);
                button.setHorizontalAlignment(2);
                this.buttonPanel.add(button);
            }
        }
        catch (BGException e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    private void openAssistantActionDialog(int masterId, String actionId) {
        this.setVisible(false);
        this.dispose();
        try {
            AssistantActionDialog assistantActionDialog = new AssistantActionDialog(masterId, actionId, this.getContext());
            assistantActionDialog.showAction(null);
            assistantActionDialog.setVisible(true);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void initToolBar() {
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.toolBar.add((Action)new BGUAction("list", "\u0421\u043f\u0438\u0441\u043e\u043a", ClientUtils.getIcon((String)"list")){

            public void actionPerformed(ActionEvent actionEvent) {
                AssistantMasterListDialog.this.setShowMode(actionEvent.getActionCommand());
            }
        });
        this.toolBar.add((Action)new BGUAction("icons", "\u0418\u043a\u043e\u043d\u043a\u0438", ClientUtils.getIcon((String)"icons")){

            public void actionPerformed(ActionEvent actionEvent) {
                AssistantMasterListDialog.this.setShowMode(actionEvent.getActionCommand());
            }
        });
        this.toolBar.add(Box.createHorizontalGlue());
    }

    private void setShowMode(String mode) {
        this.cardLayout.show(this.cardPanel, mode);
        ClientSetup.getInstance().getUserConfig().set("assistant.actions.mode", mode);
        ClientSetup.getInstance().saveUserConfig();
    }

    private void initCardPanel() {
        this.cardPanel.add((Component)this.getListPanel(), "list");
        this.cardPanel.add((Component)this.getIconsPanel(), "icons");
        String mode = ClientSetup.getInstance().getUserConfig().get("assistant.actions.mode");
        if (mode != null) {
            this.cardLayout.show(this.cardPanel, mode);
        }
    }

    private JPanel getListPanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)this.list), new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getIconsPanel() {
        this.iconsPanel.setBorder(null);
        this.iconsPanel.setViewportView(this.buttonPanel);
        this.iconsPanel.setVerticalScrollBarPolicy(20);
        this.iconsPanel.setHorizontalScrollBarPolicy(30);
        this.iconsPanel.revalidate();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.iconsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }
}

