/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;
import ru.bitel.bgbilling.common.BGException;

public class CmdProtocolClient
implements AutoCloseable {
    private String serverhost;
    private int serverport;
    private Socket socket;
    private BufferedReader in;
    private BufferedWriter out;
    private String reply = null;
    private boolean replyResult;
    private int timeoutConnect = -1;
    private int timeoutEcho = 10000;
    private int timeoutCmd = 120000;
    private static final String STATUSSERVER_COMMAND = "!STATUSSERVER%)";

    public CmdProtocolClient(String connector) throws BGException {
        try {
            String[] params = connector.split(":");
            this.serverhost = params[0];
            this.serverport = Integer.parseInt(params[1]);
        }
        catch (Exception e) {
            throw new BGException("error connector format (" + connector + ")");
        }
    }

    public void connect() throws IOException {
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(this.serverhost);
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(addr, this.serverport), this.timeoutConnect > 0 ? this.timeoutConnect : 0);
        }
        catch (UnknownHostException e) {
            throw new IOException("connect: unknown host <" + this.serverhost + ">", e);
        }
        catch (Exception e) {
            throw new IOException("connect: error socket create <" + addr + " : " + this.serverport + ">", e);
        }
        try {
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "utf-8"));
            this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "utf-8"));
        }
        catch (IOException e) {
            throw new IOException("connect: error create I/O stream", e);
        }
    }

    public void disconnect() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            throw new IOException("disconnect: error close", e);
        }
    }

    public void setTimeouts(int timeoutEcho, int timeoutCmd) {
        this.timeoutEcho = timeoutEcho;
        this.timeoutCmd = timeoutCmd;
    }

    public void setTimeoutConnect(int timeoutConnect) {
        this.timeoutConnect = timeoutConnect;
    }

    public boolean send(String command, Object ... parameters) throws IOException {
        String linereply;
        boolean result;
        String rs = CmdProtocolClient.getRandStringNumber();
        this.out.write("COMMAND");
        this.out.newLine();
        this.out.flush();
        this.out.write(rs);
        this.out.newLine();
        this.out.write(command);
        this.out.newLine();
        for (Object param : parameters) {
            if (param instanceof Iterable) {
                for (Object paramItemList : (Iterable)param) {
                    this.out.write(paramItemList != null ? paramItemList.toString() : "NULL");
                    this.out.newLine();
                }
                continue;
            }
            this.out.write(param != null ? param.toString() : "NULL");
            this.out.newLine();
        }
        this.out.write("ENDCOMMAND");
        this.out.newLine();
        this.out.flush();
        this.socket.setSoTimeout(this.timeoutEcho);
        String echo = this.in.readLine();
        if (!"ECHO".equals(echo)) {
            throw new IOException("send: protocol error - unknown reply header <" + echo + "> (not valid server?)");
        }
        String code = this.in.readLine();
        if (!code.equals(rs)) {
            throw new IOException("send: protocol error - not valid reply key-mark <" + code + ">");
        }
        this.socket.setSoTimeout(this.timeoutCmd);
        String resultStatus = this.in.readLine();
        if ("OK".equals(resultStatus)) {
            result = true;
            this.replyResult = true;
        } else if ("ERROR".equals(resultStatus)) {
            result = false;
            this.replyResult = false;
        } else {
            throw new IOException("send: protocol error - unknown reply result status <" + resultStatus + ">");
        }
        StringBuffer sbreply = null;
        boolean firstline = true;
        while (!(linereply = this.in.readLine()).equals("ENDECHO")) {
            if (firstline) {
                sbreply = new StringBuffer(1024);
            }
            if (!firstline) {
                sbreply.append("\n");
            }
            sbreply.append(linereply);
            firstline = false;
        }
        this.reply = sbreply == null ? null : sbreply.toString();
        return result;
    }

    public String getServerStatus() throws IOException {
        String result = null;
        try {
            this.out.write(STATUSSERVER_COMMAND);
            this.out.newLine();
            this.out.flush();
            this.socket.setSoTimeout(this.timeoutEcho);
            result = this.in.readLine().replaceAll("; ", "\n");
        }
        catch (Exception e) {
            throw new IOException("get server status error", e);
        }
        return result;
    }

    private static String getRandStringNumber() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            sb.append(String.valueOf(Math.abs(new Random().nextInt()) % 10));
        }
        return sb.toString();
    }

    public String getReply() {
        return this.reply;
    }

    public boolean getReplyResult() {
        return this.replyResult;
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }
}

