/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2;

import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import jssc.SerialPortException;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2.PrinterShtrihErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2.PrinterStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.DeviceSerialPort;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class ShtrihFRKPrinter
extends DeviceSerialPort {
    private static final byte SS_ENQ = 5;
    private static final byte SS_STX = 2;
    private static final byte SS_ACK = 6;
    private static final byte SS_NAK = 21;
    private BGByteBuffer bPassword = null;
    private int oneByteTimeout = 100;
    private Logger logTrace;
    public static int OPENCHECK_TYPE_PAYMENT = 0;
    public static int OPENCHECK_TYPE_PAYMENTREFUND = 2;
    public static int OPENCHECK_TYPE_PAYMENTCORRECTION = 128;
    public static int OPENCHECK_TYPE_PAYMENTREFUNDCORRECTION = 130;

    public ShtrihFRKPrinter(SerialParameters portParam, int oneByteTimeout, long pass, Logger logTrace) {
        super(portParam);
        this.oneByteTimeout = oneByteTimeout;
        this.bPassword = ShtrihFRKPrinter.encodeNumber(pass, 4);
        this.logTrace = logTrace;
    }

    private static BGByteBuffer encodeString(String string, int bytes) {
        byte[] msgbytesLEN = new byte[bytes];
        if (string != null) {
            byte[] msgbytes = null;
            try {
                msgbytes = string.getBytes("windows-1251");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            System.arraycopy(msgbytes, 0, msgbytesLEN, 0, Math.min(bytes, msgbytes.length));
        }
        return new BGByteBuffer(msgbytesLEN, bytes);
    }

    private static BGByteBuffer encodeNumber(long number, int bytes) {
        if (number < 0L) {
            long summan = 1L;
            for (int i = 0; i < bytes; ++i) {
                summan *= 256L;
            }
            number += summan;
        }
        BGByteBuffer ret = new BGByteBuffer();
        for (int n = 0; n < bytes; ++n) {
            if (number > 0L) {
                byte number1 = (byte)(number % 256L);
                ret.pushEnd(number1);
                number /= 256L;
                continue;
            }
            ret.pushEnd((byte)0);
        }
        return ret;
    }

    private static long decodeNumber(byte[] buffer, int offset, int bytes) {
        long mul = 1L;
        long num = 0L;
        for (int i = offset; i < offset + bytes; ++i) {
            num += (long)BGByteBuffer.byte2int(buffer[i]) * mul;
            mul *= 256L;
        }
        return num;
    }

    private BGByteBuffer _sendCommand(BGByteBuffer command) throws PrinterShtrihErrorException, PrinterConnectException {
        byte berr;
        BGByteBuffer stxpacket = new BGByteBuffer(command);
        byte l = (byte)stxpacket.getBytes().length;
        stxpacket.pushBegin(l);
        stxpacket.pushEnd(stxpacket.getLRC());
        stxpacket.pushBegin((byte)2);
        this.$trace("SEND (full packet): " + stxpacket.toString());
        BGByteBuffer reply = this._transferPacket(stxpacket, true);
        this.$trace("RECV (packet body): " + reply.toString());
        byte code = reply.popBeginByte();
        if (code != -1) {
            if (code != command.getBytes()[0]) {
                throw new PrinterConnectException("protocol error: not equals code from ask (0x" + BGByteBuffer.toString(command.getBytes()[0]) + ") and reply (0x" + BGByteBuffer.toString(code) + ")");
            }
        } else {
            this.$trace("_sendCommand: detected two-byte command number");
            byte code2 = reply.popBeginByte();
            if (code2 != command.getBytes()[1]) {
                throw new PrinterConnectException("protocol error: not equals code2 of TWO-BYTE command from ask (0x" + BGByteBuffer.toString(command.getBytes()[1]) + ") and reply (0x" + BGByteBuffer.toString(code2) + ")");
            }
        }
        if ((berr = reply.popBeginByte()) != 0) {
            throw new PrinterShtrihErrorException(BGByteBuffer.byte2int(berr));
        }
        return reply;
    }

    private BGByteBuffer _transferPacket(BGByteBuffer packet, boolean wantToSend) throws PrinterConnectException {
        block4: for (int enternum = 0; enternum < 5; ++enternum) {
            try {
                int waitedByte;
                block15: {
                    int i;
                    block14: {
                        waitedByte = -1;
                        for (i = 0; i < 5; ++i) {
                            this.$trace("_transferPacket: send ENQ");
                            this._send((byte)5);
                            this.$trace("_transferPacket: set timeout 10000");
                            this._setTimeout(10000);
                            waitedByte = this._recv();
                            if (waitedByte == -1) {
                                this.$warn("_transferPacket: (timeout) there was no reaction to ENQ");
                                throw new PrinterConnectException("there was no reaction to ENQ. (\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043b\u0438 \u043f\u0440\u0438\u043d\u0442\u0435\u0440)");
                            }
                            if (waitedByte == 21) {
                                this.$trace("_transferPacket: getted NAK");
                                break block14;
                            }
                            if (waitedByte == 6) {
                                this.$trace("_transferPacket: getted ACK");
                                break block14;
                            }
                            this.$warn("_transferPacket: getted unknown response (not NAK or ACK)...");
                            this.$trace("_transferPacket: set timeout 2000");
                            this._setTimeout(2000);
                            BGByteBuffer buf = this._recv_all();
                            buf.pushBegin((byte)waitedByte);
                            this.$trace("_transferPacket: read garbage midden (with first byte): " + buf.toString());
                        }
                        throw new PrinterConnectException("reset: ENQ incorrect response to the 5 attempts.");
                    }
                    if (waitedByte == 21 && wantToSend) {
                        for (i = 0; i < 5; ++i) {
                            this.$trace("_transferPacket: send packet");
                            this._send(packet);
                            this.$trace("_transferPacket: set timeout " + this.oneByteTimeout);
                            this._setTimeout(this.oneByteTimeout);
                            waitedByte = this._recv();
                            if (waitedByte == -1) {
                                this.$warn("_transferPacket: (timeout) no answer to the command posted, (!)reentering");
                                continue block4;
                            }
                            if (waitedByte == 6) {
                                this.$trace("_transferPacket: getted ACK, ok!");
                                break block15;
                            }
                            this.$warn("_transferPacket: getted non-ACK " + BGByteBuffer.toString(waitedByte));
                        }
                        throw new PrinterConnectException("send command error: printer not reply ACK to the 5 attempts. ");
                    }
                }
                if (waitedByte == 6) {
                    try {
                        BGByteBuffer stx = this._readSTX();
                        this.$trace("_transferPacket: ok, send ACK");
                        this._send((byte)6);
                        return stx;
                    }
                    catch (PrinterConnectException e) {
                        this.$warn("_transferPacket: error read stx-packet, send NAK, (!)reentering");
                        this._send((byte)21);
                        continue;
                    }
                }
                return null;
            }
            catch (SerialPortException e) {
                throw new PrinterConnectException(e);
            }
        }
        throw new PrinterConnectException("there was no normal transfer to the 5 attempts (enters to transfer packet).");
    }

    private BGByteBuffer _readSTX() throws SerialPortException, PrinterConnectException {
        this.$trace("_readSTX: set timeout 120000");
        this._setTimeout(120000);
        int b = this._recv();
        if (b == -1) {
            this.$warn("_readSTX: (timeout) error read STX-byte");
            throw new PrinterConnectException("error read STX-byte");
        }
        this.$trace("_readSTX: ok read STX-byte");
        if (b != 2) {
            this.$warn("_readSTX: error STX-byte: STX=0x" + BGByteBuffer.toString((byte)b));
            throw new PrinterConnectException("error STX-byte");
        }
        int len = this._recv();
        if (len == -1) {
            this.$warn("_readSTX: (timeout) error read STX-packet (len)");
            throw new PrinterConnectException("error read STX-packet (len)");
        }
        this.$trace("_readSTX: ok read len=" + len);
        this.$trace("_readSTX: set timeout " + this.oneByteTimeout);
        this._setTimeout(this.oneByteTimeout);
        BGByteBuffer body = this._recv(len);
        if (body == null || body.getBytes().length != len) {
            this.$warn("_readSTX: error read STX-packet (body): body=" + body + ", len=" + len);
            throw new PrinterConnectException("error read STX-packet (body)");
        }
        this.$trace("_readSTX: ok read body " + body.toString());
        int lrc = this._recv();
        if (lrc == -1) {
            this.$warn("_readSTX: (timeout) error read STX-packet (checksum)");
            throw new PrinterConnectException("error read STX-packet (checksum)");
        }
        this.$trace("_readSTX: ok read lrc");
        BGByteBuffer stxpack = new BGByteBuffer();
        stxpack.pushEnd((byte)len);
        stxpack.pushEnd(body);
        byte cs = stxpack.getLRC();
        this.$trace("_readSTX: RECV (full): " + BGByteBuffer.toString((byte)2) + "|" + BGByteBuffer.toString(len) + "|" + body.toString() + "|" + BGByteBuffer.toString(lrc));
        if (cs == (byte)lrc) {
            return body;
        }
        this.$warn("_readSTX: STX-packet checksum/LRC failed (read=0x" + BGByteBuffer.toString((byte)lrc) + ", calc=0x" + BGByteBuffer.toString(cs) + ")");
        throw new PrinterConnectException("error read STX-packet (checksum failed)");
    }

    public String getName() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try getName()");
        BGByteBuffer reply = this._sendCommand(new BGByteBuffer(-4));
        byte type = reply.popBeginByte();
        byte subtype = reply.popBeginByte();
        byte pver = reply.popBeginByte();
        byte subpver = reply.popBeginByte();
        byte model = reply.popBeginByte();
        byte lang = reply.popBeginByte();
        String devicename = null;
        try {
            devicename = new String(reply.getBytes(), "windows-1251");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder name = new StringBuilder(128);
        name.append(devicename).append(" (");
        if (type == 0 && subtype == 0) {
            name.append("\u0442\u0438\u043f:\u041a\u041a\u041c/\u0424\u0420");
        } else {
            name.append("\u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e-\u0432\u043e: \u0442\u0438\u043f ").append(type).append(".").append(subtype);
        }
        name.append(", \u043c\u043e\u0434\u0435\u043b\u044c:").append(model);
        name.append(", \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b:").append(pver).append(".").append(subpver);
        name.append(", \u044f\u0437\u044b\u043a:").append(lang).append(lang == 0 ? "(RU)" : "");
        name.append(")");
        return name.toString();
    }

    public PrinterStatus getStatusShort() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try getStatusShort()");
        PrinterStatus ps = null;
        BGByteBuffer cmd = new BGByteBuffer(16);
        cmd.pushEnd(this.bPassword);
        BGByteBuffer reply = this._sendCommand(cmd);
        ps = new PrinterStatus();
        ps.operatorNum = reply.getBytes()[0];
        ps.rulonOpJournal = Utils.testBit((byte)reply.getBytes()[1], (int)0);
        ps.rulonVoucherTape = Utils.testBit((byte)reply.getBytes()[1], (int)1);
        ps.paperOpJournal = Utils.testBit((byte)reply.getBytes()[1], (int)6);
        ps.paperVoucherTape = Utils.testBit((byte)reply.getBytes()[1], (int)7);
        ps.leverPrintheadControlTape = Utils.testBit((byte)reply.getBytes()[2], (int)0);
        ps.leverPrintheadVoucherTape = Utils.testBit((byte)reply.getBytes()[2], (int)1);
        ps.coverCorpsFR = Utils.testBit((byte)reply.getBytes()[2], (int)2);
        ps.moneyBox = Utils.testBit((byte)reply.getBytes()[2], (int)3);
        ps.mode = reply.getBytes()[3];
        ps.submode = reply.getBytes()[4];
        ps.operationCount = reply.getBytes()[10] * 256 + reply.getBytes()[5];
        ps.voltageBackupBattery = Float.valueOf((float)BGByteBuffer.byte2int(reply.getBytes()[6]) / 51.0f);
        ps.voltagePowerSource = Float.valueOf((float)BGByteBuffer.byte2int(reply.getBytes()[7]) / 9.0f);
        ps.errorKEYUPD = reply.getBytes()[9];
        return ps;
    }

    void printLine(String string, boolean control) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try printLine(" + string + "," + control + ")");
        BGByteBuffer cmd = new BGByteBuffer(23);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(control ? (byte)3 : 2);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(string, 40));
        this._sendCommand(cmd);
    }

    void cut() throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try cut()");
        BGByteBuffer cmd = new BGByteBuffer(37);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)1);
        this._sendCommand(cmd);
    }

    private void runline(int lines, boolean check, boolean control) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(41);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)((check ? 2 : 0) | (control ? 1 : 0)));
        cmd.pushEnd((byte)lines);
        this._sendCommand(cmd);
    }

    public void _waitToNoPrint(int timeout, int numtry) throws PrinterShtrihErrorException, PrinterConnectException {
        if (numtry > 0) {
            PrinterStatus ps = null;
            for (int i = 0; i < numtry; ++i) {
                ps = this.getStatusShort();
                if (ps.submode != 4 && ps.submode != 5) {
                    return;
                }
                try {
                    Thread.sleep(timeout);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            throw new PrinterConnectException("too many wait to substatus with noprint (last mode " + ps.modeNumString() + ", submode " + ps.submode + ")");
        }
    }

    public void sale(long number, long price, int roomDivision, String text, int tax1, int tax2, int tax3, int tax4) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try sale(" + number + "," + price + "," + roomDivision + ",\"" + text + "\"," + tax1 + "," + tax2 + "," + tax3 + "," + tax4 + ")");
        BGByteBuffer cmd = new BGByteBuffer(-128);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(number, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(price, 5));
        cmd.pushEnd((byte)roomDivision);
        cmd.pushEnd((byte)tax1);
        cmd.pushEnd((byte)tax2);
        cmd.pushEnd((byte)tax3);
        cmd.pushEnd((byte)tax4);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 40));
        this._sendCommand(cmd);
    }

    public void saleback(long number, long price, int roomDivision, String text, int tax1, int tax2, int tax3, int tax4) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try saleback(" + number + "," + price + "," + roomDivision + ",\"" + text + "\"," + tax1 + "," + tax2 + "," + tax3 + "," + tax4 + ")");
        BGByteBuffer cmd = new BGByteBuffer(-126);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(number, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(price, 5));
        cmd.pushEnd((byte)roomDivision);
        cmd.pushEnd((byte)tax1);
        cmd.pushEnd((byte)tax2);
        cmd.pushEnd((byte)tax3);
        cmd.pushEnd((byte)tax4);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 40));
        this._sendCommand(cmd);
    }

    public void saleV2(int type, long number, long price, int roomDivision, String text, int tax, int payMethod, int payObject) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try saleV2(" + type + "," + number + "," + price + "," + roomDivision + ",\"" + text + "\"," + tax + "," + payMethod + "," + payObject + ")");
        BGByteBuffer cmd = new BGByteBuffer();
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)70);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)type);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(number, 6));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(price, 5));
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)tax);
        cmd.pushEnd((byte)roomDivision);
        cmd.pushEnd((byte)payMethod);
        cmd.pushEnd((byte)payObject);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 128));
        this._sendCommand(cmd);
    }

    public long closeCheck(long summa, long summa2, long summa3, long summa4, int discount, String text, int tax1, int tax2, int tax3, int tax4) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try closeCheck(" + summa + "," + summa2 + "," + summa3 + "," + summa4 + "," + discount + ",\"" + text + "\"," + tax1 + "," + tax2 + "," + tax3 + "," + tax4 + ")");
        BGByteBuffer cmd = new BGByteBuffer(-123);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa2, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa3, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa4, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(discount, 2));
        cmd.pushEnd((byte)tax1);
        cmd.pushEnd((byte)tax2);
        cmd.pushEnd((byte)tax3);
        cmd.pushEnd((byte)tax4);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 40));
        BGByteBuffer reply = this._sendCommand(cmd);
        long submit = ShtrihFRKPrinter.decodeNumber(reply.getBytes(), 1, 5);
        return submit;
    }

    public CloseCheckReturn closeCheckExV2(long summa, int summa_num, String text, int sno_num) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try closeCheckExV2(" + summa + "," + summa_num + ",,\"" + text + "\"," + sno_num + ")");
        BGByteBuffer cmd = new BGByteBuffer();
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)69);
        cmd.pushEnd(this.bPassword);
        for (int i = 1; i <= 16; ++i) {
            cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa_num == i ? summa : 0L, 5));
        }
        cmd.pushEnd((byte)0);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(0L, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(0L, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(0L, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(0L, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(0L, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(0L, 5));
        int osn = 1 << sno_num;
        cmd.pushEnd((byte)osn);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 64));
        BGByteBuffer reply = this._sendCommand(cmd);
        CloseCheckReturn ret = new CloseCheckReturn();
        ret.submit = ShtrihFRKPrinter.decodeNumber(reply.getBytes(), 0, 5);
        ret.fd = ShtrihFRKPrinter.decodeNumber(reply.getBytes(), 5, 4);
        ret.fp = ShtrihFRKPrinter.decodeNumber(reply.getBytes(), 9, 4);
        if (reply.getBytes().length >= 18) {
            ret.decodeDATE_TIME(reply.getBytes(), 13);
        }
        return ret;
    }

    public CloseCheckReturn closeCorrectionV2(int type, int priznak, long summa0, long summa, int summa_num, int sno_num) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try closeCorrectionV2(" + type + "," + priznak + "," + summa0 + "," + summa + "," + summa_num + "," + sno_num + ")");
        return null;
    }

    public void openCheck(int type) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try openCheck(type=" + type + ")" + (type >= 128 ? "[correction]" : ""));
        BGByteBuffer cmd = new BGByteBuffer(-115);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)type);
        this._sendCommand(cmd);
    }

    public void buzzer() throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try buzzer()");
        BGByteBuffer cmd = new BGByteBuffer(19);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void xreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try xreport()");
        BGByteBuffer cmd = new BGByteBuffer(64);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void zreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try zreport()");
        BGByteBuffer cmd = new BGByteBuffer(65);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void divreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try divreport()");
        BGByteBuffer cmd = new BGByteBuffer(66);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void repeatDoc() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try repeatDoc()");
        BGByteBuffer cmd = new BGByteBuffer(-116);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public BGByteBuffer pureCmd(String hexDump) throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try pureCmd(" + hexDump + ")");
        return this._sendCommand(new BGByteBuffer(hexDump));
    }

    public void continuePrint() throws PrinterConnectException, PrinterShtrihErrorException {
        this.$trace("try continuePrint()");
        BGByteBuffer cmd = new BGByteBuffer(-80);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void cancelCheck() throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try cancelCheck()");
        BGByteBuffer cmd = new BGByteBuffer(-120);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void openDay() throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try openDay()");
        BGByteBuffer cmd = new BGByteBuffer(-32);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void sendTLV(int tag, byte[] data) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try sendTLV(" + tag + ")");
        BGByteBuffer cmd = new BGByteBuffer();
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)12);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.makeTLV(tag, data));
        this._sendCommand(cmd);
    }

    public void sendTLVOperation(int tag, byte[] data) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try sendTLVOperation(" + tag + ")");
        BGByteBuffer cmd = new BGByteBuffer();
        cmd.pushEnd((byte)-1);
        cmd.pushEnd((byte)77);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.makeTLV(tag, data));
        this._sendCommand(cmd);
    }

    private static BGByteBuffer makeTLV(int tag, byte[] data) {
        BGByteBuffer buf = new BGByteBuffer();
        buf.pushEnd(ShtrihFRKPrinter.encodeNumber(tag, 2));
        buf.pushEnd(ShtrihFRKPrinter.encodeNumber(data.length, 2));
        buf.pushEnd(data, data.length);
        return buf;
    }

    public void open() throws PrinterConnectException {
        try {
            super._open();
            this._transferPacket(new BGByteBuffer(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            if (e instanceof PrinterConnectException) {
                throw (PrinterConnectException)e;
            }
            throw new PrinterConnectException(e);
        }
    }

    public void close() {
        try {
            super._close();
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _touch() {
        Object message = null;
        boolean isPrinterValid = false;
        try {
            this._open();
            for (int i = 0; i < 5; ++i) {
                this.$trace("_touch: start: send ENQ" + (String)(i > 0 ? " (attempt " + (i + 1) + ")" : ""));
                this._send((byte)5);
                this.$trace("_touch: set timeout 1000");
                this._setTimeout(1000);
                int b = this._recv();
                if (b == -1) {
                    this.$trace("_touch: timeout");
                    message = "no reaction";
                    break;
                }
                if (b == 21) {
                    this.$trace("_touch: getted NAK");
                    message = "OK reaction";
                    isPrinterValid = true;
                    break;
                }
                if (b == 6) {
                    this.$trace("_touch: getted ACK");
                    BGByteBuffer stx = this._readSTX();
                    if (stx != null) {
                        this.$trace("_touch: ACK reaction, readed STX: " + stx.toString());
                        this._send((byte)6);
                        message = "ACK reaction, readed STX: " + stx.toString();
                    } else {
                        this.$trace("_touch: ACK reaction, but error read STX");
                        this._send((byte)21);
                        message = "ACK reaction, but error read STX";
                    }
                    isPrinterValid = true;
                    continue;
                }
                this.$trace("_touch: getted garbage midden...");
                BGByteBuffer bufrecv = new BGByteBuffer((byte)b);
                this.$trace("_touch: set timeout 2000");
                this._setTimeout(2000);
                BGByteBuffer buf = this._recv_all();
                bufrecv.pushEnd(buf);
                message = "garbage midden: '" + bufrecv.toString() + "'";
                this.$trace("_touch: garbage midden: " + bufrecv.toString());
                isPrinterValid = false;
            }
            if (isPrinterValid) {
                try {
                    message = (String)message + "; name: " + this.getName();
                }
                catch (Throwable e) {
                    message = (String)message + "; error get name: " + BGException.printStackTraceToString((Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            message = "device touch error: " + e.toString();
        }
        finally {
            try {
                this._close();
            }
            catch (Throwable e) {
                this.logTrace.error("_touch: error close port", e);
            }
        }
        return message;
    }

    private void $trace(String message) {
        if (this.logTrace != null) {
            this.logTrace.trace("shtrih2-driver: " + message);
        }
    }

    private void $warn(String message) {
        if (this.logTrace != null) {
            this.logTrace.warn("shtrih2-driver: " + message);
        }
    }

    public int readTableByte(int table, int row, int cell) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try readTableByte(" + table + "," + row + "," + cell + ")");
        BGByteBuffer cmd = new BGByteBuffer();
        cmd.pushEnd((byte)31);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)table);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(row, 2));
        cmd.pushEnd((byte)cell);
        BGByteBuffer reply = this._sendCommand(cmd);
        if (reply.getBytes().length != 1) {
            throw new PrinterShtrihErrorException("table value (" + table + "," + row + "," + cell + ") isnt 1 byte len, but " + reply.getBytes().length);
        }
        return BGByteBuffer.byte2int(reply.popBeginByte());
    }

    public void writeTableByte(int table, int row, int cell, int val) throws PrinterShtrihErrorException, PrinterConnectException {
        this.$trace("try writeTableByte(" + table + "," + row + "," + cell + ", => " + val + ")");
        BGByteBuffer cmd = new BGByteBuffer();
        cmd.pushEnd((byte)30);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)table);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(row, 2));
        cmd.pushEnd((byte)cell);
        cmd.pushEnd((byte)val);
        this._sendCommand(cmd);
    }

    public static class CloseCheckReturn {
        long submit;
        long fd;
        long fp;
        LocalDateTime date;

        public void decodeDATE_TIME(byte[] buffer, int offset) {
            byte Y = buffer[offset];
            byte M = buffer[offset + 1];
            byte D = buffer[offset + 2];
            byte h = buffer[offset + 3];
            byte m = buffer[offset + 4];
            this.date = LocalDateTime.of(2000 + Y, M, (int)D, (int)h, (int)m);
        }
    }
}

