/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.BGControlPanelMonthAndDays;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.SynclogEntry;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.SynclogService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGLabeledControl;
import ru.bitel.common.client.BGTextDialog;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;

public class ServiceConfigSynclog
extends BGUPanel
implements ActionListener {
    private BGControlPanelMonthAndDays periodPanel = new BGControlPanelMonthAndDays(true);
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGUTable table;
    private BGTableModel<SynclogEntry> model;
    private BGTextField filterNumbers = new BGTextField(8);
    private BGControlPanelButtonGroup filterSuccess = new BGControlPanelButtonGroup(false);
    private BGTextField filterCid = new BGTextField(8);

    public ServiceConfigSynclog() {
        this.build();
    }

    protected void jbInit() {
        this.filterSuccess.addButton("+", "1", true);
        this.filterSuccess.addButton("-", "0", true);
        this.model = new BGTableModel<SynclogEntry>("SynclogEntry"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u0412\u0440\u0435\u043c\u044f", String.class, 100, 140, 240, null, false);
                this.addColumn("\u041a\u0430\u0440\u0442\u0430", 80, 160, 220, "number", false);
                this.addColumn("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f", 80, 100, 120, "operation", false);
                this.addColumn("\u0423\u0441\u043f\u0435\u0445", 30, 40, 50, "success", false);
                this.addColumn("ucid", 40, 60, 90, "usercardId", false);
                this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 80, 100, 200, "contractTitleComment", false);
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false);
                this.addColumn("contractId", 0, 0, 0, "contractId", false);
            }

            public Object getValue(SynclogEntry val, int column) throws BGException {
                if (column == 1) {
                    return TimeUtils.format((Date)val.getDate(), (String)"dd.MM.yyyy HH:mm:ss");
                }
                if (column == 5) {
                    return val.getUsercardId() > 0 ? Integer.valueOf(val.getUsercardId()) : null;
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.setLayout(new GridBagLayout());
        BGButton doFilter = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", "bApply", (ActionListener)this);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new BGLabeledControl((Component)this.filterNumbers, "\u041d\u043e\u043c\u0435\u0440(\u0430):"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)new BGLabeledControl((Component)this.filterSuccess, "\u0423\u0441\u043f\u0435\u0445:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)new BGLabeledControl((Component)this.filterCid, "cid:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)new BGLabeledControl((Component)this.periodPanel, "\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)doFilter, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    ServiceConfigSynclog.this.performAction("refresh");
                }
            }
        });
        this.pagePanel.setKey(this.getClass().getName());
        ClientUtils.addOpenAction((Component)this.table, (AWTEventListener)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                ServiceConfigSynclog.this.performAction("showcomment");
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            int fcid = Utils.parseInt((String)this.filterCid.getText(), (int)-1);
            Set fnumbers = Utils.toLongSet((String)this.filterNumbers.getText());
            Set fsuccess = Utils.toIntegerSet((String)this.filterSuccess.getSelectedCommand());
            Result result = ((SynclogService)((ClientContext)this.getContext()).getPort(SynclogService.class)).getSynclog(this.periodPanel.getPeriod(), this.pagePanel.getPage(), fcid, fnumbers, fsuccess, true);
            this.model.setData(result.getList());
            this.pagePanel.setPage(result.getPage());
        });
        new AbstractBGUPanel.DefaultAction("showcomment", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043f\u043e\u043b\u043d\u044b\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0437\u0430\u043f\u0438\u0441\u0438"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SynclogEntry entry = (SynclogEntry)ServiceConfigSynclog.this.model.getSelectedRow();
                if (ServiceConfigSynclog.this.table.getSelectedColumn() == 7) {
                    BGTextDialog dialog = new BGTextDialog();
                    entry = ((SynclogService)((ClientContext)ServiceConfigSynclog.this.getContext()).getPort(SynclogService.class)).getSynclogEntry(entry.getId(), entry.getDate());
                    dialog.getTextArea().setText(entry.getComment());
                    dialog.setModal(true);
                    dialog.setPreferredSize(new Dimension(1024, 480));
                    dialog.pack();
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } else if (ServiceConfigSynclog.this.table.getSelectedColumn() == 6 && entry.getContractId() > 0) {
                    ClientUtils.openContract((int)entry.getContractId());
                }
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("bApply".equals(e.getActionCommand())) {
            this.pagePanel.init();
            this.performAction("refresh");
        }
    }

    public void setParameter(Object parameter) {
        this.filterNumbers.setText(String.valueOf((Long)parameter));
        this.pagePanel.init();
        this.performAction("refresh");
    }
}

