/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import bitel.billing.server.tariff.TariffModuleTree;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.CalculateEvent;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.PacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.StatusEventManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardCopyManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.CardWork;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.CostPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.PacketCostCache;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class Calculator
extends TaskBase {
    private HashMap<Integer, TariffTreeSet> contractTreeSets = new HashMap();
    private Calendar startMonth;
    private Calendar stopMonth;
    private String cids;
    private String usercardIds = null;
    private PeriodicErrorManager errorManager;
    private Map<Integer, ContractTariffOptionList> tarifOptions = new HashMap<Integer, ContractTariffOptionList>();
    private ModuleSetup moduleSetup;
    private boolean isCalculateLockedCardpackets;
    private boolean isCalculateSuspendCardpackets;
    private boolean oneDayMode = false;
    private boolean oneMonthMode = false;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"yyyy.MM");
    }

    public void setCids(String value) {
        this.cids = value;
        this.getLogger().debug("set contract filter: " + this.cids);
    }

    public void setUsercardIds(List<Integer> usercardIds) {
        if (!usercardIds.isEmpty()) {
            this.usercardIds = Utils.toString(usercardIds);
            this.getLogger().debug("set usercard filter: " + this.usercardIds);
        }
    }

    public void setOneDayMode() {
        this.oneDayMode = true;
    }

    public void setOneMonthMode() {
        this.oneMonthMode = true;
    }

    protected boolean initTask() {
        boolean result = true;
        if (this.moduleId < 0) {
            result = false;
            this.getLogger().error("Param mid not found!");
        }
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        if (this.oneDayMode) {
            this.stopMonth = (Calendar)this.startMonth.clone();
        } else if (this.oneMonthMode) {
            this.stopMonth = (Calendar)this.startMonth.clone();
            TimeUtils.floor((Calendar)this.startMonth, (int)2);
            TimeUtils.moveToEndOfMonth((Calendar)this.stopMonth);
        } else {
            this.startMonth.add(11, -1);
            TimeUtils.floor((Calendar)this.startMonth, (int)2);
            this.stopMonth = (Calendar)this.startMonth.clone();
            TimeUtils.moveToEndOfMonth((Calendar)this.stopMonth);
            GregorianCalendar now = new GregorianCalendar();
            if (now.before(this.stopMonth)) {
                this.stopMonth = now;
            }
        }
        this.moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
        this.isCalculateLockedCardpackets = this.moduleSetup.getBoolean("calculate.locked.cardpackets", false);
        this.isCalculateSuspendCardpackets = this.moduleSetup.getBoolean("calculate.suspend.cardpackets", false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.errorManager = new PeriodicErrorManager(con);
            this.errorManager.initErrorMessage(this.moduleId, "CerberCrypt", String.valueOf(this.moduleId), this.startMonth.getTime());
            try {
                EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(0, this.moduleId, 0, this.startMonth.getTime(), this.stopMonth.getTime(), null, null, this.taskSetup.get("comment", null)));
            }
            catch (BGException e) {
                this.getLogger().error("error publish cerbercrypt CalculateEvent (before)", (Throwable)e);
            }
            CardPacketManager cardPacketManager = new CardPacketManager(conSlave, this.moduleId);
            this.calculate(con, conSlave, cardPacketManager.getCalculateCardPacketList(this.startMonth.getTime(), this.stopMonth.getTime(), this.cids, this.usercardIds, null), false);
            try {
                EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(1, this.moduleId, 0, this.startMonth.getTime(), this.stopMonth.getTime(), null, null, this.taskSetup.get("comment", null)));
            }
            catch (BGException e) {
                this.getLogger().error("error publish cerbercrypt CalculateEvent (after)", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.getLogger().error("calculate error", (Throwable)e);
        }
        finally {
            if (this.errorManager != null) {
                if (Utils.isBlankString((String)this.cids)) {
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                }
                this.errorManager.processErrors();
            }
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }

    public ServiceCostCache preCalculate(ConnectionSet connectionSet) throws BGException {
        if (Utils.isBlankString((String)this.cids)) {
            throw new BGIllegalArgumentException();
        }
        Connection con = connectionSet.getConnection();
        Connection conSlave = connectionSet.getSlaveConnection();
        CardPacketManager cardPacketManager = new CardPacketManager(conSlave, this.moduleId);
        ServiceCostCache serviceCost = this.calculate(con, conSlave, cardPacketManager.getCalculateCardPacketList(this.startMonth.getTime(), this.stopMonth.getTime(), this.cids, this.usercardIds, null), true);
        return serviceCost;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected final ServiceCostCache calculate(Connection con, Connection conSlave, List<CardPacket> cardPacketList, boolean preCalc) {
        StatusEventManager eventManager = new StatusEventManager(conSlave, this.moduleId);
        PacketManager packetManager = new PacketManager(conSlave, this.moduleId);
        try (BalanceUtils bu = new BalanceUtils(con);){
            ServiceCostCache serviceCostCache;
            try (UserCardManager usercardManager = new UserCardManager(con, this.moduleId, 0);){
                Map<Integer, Packet> packetMap = packetManager.getPacketMap();
                Map<Integer, UserCard> usercardMap = usercardManager.getUserCardMap();
                this.initContractTrees(conSlave, cardPacketList);
                this.getLogger().info("Extract works...");
                List<CardWork> cardWorkList = this.extractWorks(eventManager, packetMap, usercardMap, cardPacketList);
                ServiceCostCache costCache = new ServiceCostCache();
                this.getLogger().info("Setting money...");
                this.setMoney(con, costCache, cardWorkList, preCalc, usercardManager);
                if (!preCalc) {
                    String moduleServices = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
                    this.getLogger().info("Set accounts and update balance...");
                    bu.setAccount(con, this.getLogger(), this.startMonth, costCache, moduleServices, this.cids, null);
                }
                serviceCostCache = costCache;
            }
            return serviceCostCache;
        }
        catch (Exception e) {
            this.getLogger().error("error calculate", (Throwable)e);
            return null;
        }
    }

    private List<CardWork> extractWorks(StatusEventManager eventManager, Map<Integer, Packet> packetMap, Map<Integer, UserCard> usercardMap, List<CardPacket> cardPacketList) throws BGException {
        boolean active = false;
        ArrayList<CardWork> cardWorkList = new ArrayList<CardWork>();
        CardWork cardWork = null;
        for (CardPacket cardPacket : cardPacketList) {
            String text;
            String subject;
            Packet packet = packetMap.get(cardPacket.getPacketId());
            UserCard usercard = usercardMap.get(cardPacket.getUsercardId());
            if (cardWork == null || cardPacket.getUsercardId() != cardWork.usercardId) {
                cardWork = new CardWork();
                cardWork.usercardId = cardPacket.getUsercardId();
                cardWork.contractId = cardPacket.getContractId();
                cardWork.isSlavecard = usercard != null && usercard.getBasecardId() > 0;
                cardWorkList.add(cardWork);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("extract works: Processing: " + cardPacket.toString());
            }
            if (packet == null) {
                if (this.errorManager == null || this.errorManager.isCapReached()) continue;
                subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0430\u043a\u0435\u0442!";
                text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cardPacket.getContractId() + "): \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0430\u043a\u0435\u0442.\nID \u043f\u0430\u043a\u0435\u0442\u0430: " + cardPacket.getPacketId();
                this.errorManager.addErrorToList(subject, text);
                this.getLogger().error("extract works: not found packet with id = " + cardPacket.getPacketId());
                continue;
            }
            if (usercard == null) {
                if (this.errorManager == null || this.errorManager.isCapReached()) continue;
                subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u0430\u0440\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!";
                text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cardPacket.getContractId() + "): \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u0430\u0440\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\nID \u043a\u0430\u0440\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + cardPacket.getUsercardId();
                this.errorManager.addErrorToList(subject, text);
                this.getLogger().error("extract works: not found usercard with id = " + cardPacket.getUsercardId());
                continue;
            }
            StatusEvent event = null;
            Iterator<StatusEvent> eventIterator = eventManager.getEvents(cardPacket.getId(), this.startMonth).iterator();
            event = eventIterator.hasNext() ? eventIterator.next() : null;
            StatusEvent lastEvent = eventManager.getLastEventBefore(cardPacket.getId(), this.startMonth);
            active = lastEvent == null || lastEvent.getStatus() == 1 || lastEvent.getStatus() == 2 && this.isCalculateLockedCardpackets || lastEvent.getStatus() == 3 && this.isCalculateSuspendCardpackets;
            Calendar periodStart = (Calendar)this.startMonth.clone();
            while (TimeUtils.dateBeforeOrEq((Calendar)periodStart, (Calendar)this.stopMonth)) {
                boolean exists;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("extract works: date = " + TimeUtils.formatDate((Calendar)periodStart));
                }
                if (packet.isVirtualCinema()) {
                    exists = !(cardPacket.getDateFrom() != null && !TimeUtils.dateBeforeOrEq((Date)cardPacket.getDateFrom(), (Date)periodStart.getTime()) || cardPacket.getDateTo() != null && !TimeUtils.dateBefore((Date)periodStart.getTime(), (Date)cardPacket.getDateTo()));
                } else {
                    boolean bl = exists = !(cardPacket.getDateFrom() != null && !TimeUtils.dateBeforeOrEq((Date)cardPacket.getDateFrom(), (Date)periodStart.getTime()) || cardPacket.getDateTo() != null && !TimeUtils.dateBeforeOrEq((Date)periodStart.getTime(), (Date)cardPacket.getDateTo()));
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("extract works: active = " + active + "; exists = " + exists);
                }
                if (event != null && TimeUtils.dateEqual((Calendar)periodStart, (Calendar)event.getTime())) {
                    switch (event.getStatus()) {
                        case 2: {
                            active = this.isCalculateLockedCardpackets;
                            break;
                        }
                        case 3: {
                            active = this.isCalculateSuspendCardpackets;
                            break;
                        }
                        case 1: {
                            active = true;
                        }
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("extract works: change on event; active => " + active);
                    }
                    if (eventIterator.hasNext()) {
                        event = eventIterator.next();
                    }
                }
                if (active && exists) {
                    int dayOfMonth = periodStart.get(5);
                    List<Packet> packetList = cardWork.daysWork.get(dayOfMonth);
                    if (packetList == null) {
                        packetList = new ArrayList<Packet>();
                        cardWork.daysWork.put(dayOfMonth, packetList);
                    }
                    packetList.add(packet);
                    this.getLogger().debug("extract works: calculate add this day");
                }
                periodStart.add(6, 1);
            }
        }
        return cardWorkList;
    }

    private void setMoney(Connection con, ServiceCostCache costCache, List<CardWork> cardWorkList, boolean preCalc, UserCardManager usercardManager) throws BGException, SQLException {
        PacketCostCache packetCache = new PacketCostCache();
        UserCardCopyManager uccm = new UserCardCopyManager(con, this.moduleId, 0);
        int daysInMonth = this.startMonth.getActualMaximum(5);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("set money: days in month: " + daysInMonth + ", calculating...");
        }
        TariffRequest request = new TariffRequest();
        for (CardWork cardWork : cardWorkList) {
            TariffTreeSet treeSet = this.contractTreeSets.get(cardWork.contractId);
            if (treeSet == null) {
                if (this.errorManager == null || this.errorManager.isCapReached()) continue;
                String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e!";
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cardWork.contractId + "): \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e.\nID \u043a\u0430\u0440\u0442\u044b " + cardWork.usercardId;
                this.errorManager.addErrorToList(subject, text);
                this.getLogger().error("set money: tree set not found contractID: " + cardWork.contractId);
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("set money: cardwork: contract id=" + cardWork.contractId + "; usercard id=" + cardWork.usercardId);
            }
            if (cardWork.isSlavecard) {
                this.getLogger().debug("set money: usercard id=" + cardWork.usercardId + " ignored (this is slavecard)!");
                continue;
            }
            ContractTariffOptionList tariffOption = this.getContractTariffOptionList(con, cardWork.contractId);
            Calendar time = (Calendar)this.startMonth.clone();
            for (Integer day : cardWork.daysWork.keySet()) {
                List<Packet> usercardPackets = cardWork.daysWork.get(day);
                time.set(5, day);
                int cardcopyCount = 1 + uccm.getCopyCount(cardWork.usercardId, TimeUtils.convertCalendarToDate((Calendar)time));
                List<UserCard> uclist = usercardManager.getList(cardWork.contractId, TimeUtils.convertCalendarToDate((Calendar)time));
                int usercardCount = uclist.size();
                if (usercardCount <= 0) {
                    this.getLogger().warn("set money: ? no active usercard on day=" + day + " for cid=" + cardWork.contractId);
                }
                List<Packet> contractPackets = Calculator.getContractPackets(cardWorkList, day, cardWork.contractId);
                int usercardPacketCount = 0;
                for (Packet packet : usercardPackets) {
                    if (packet.isVirtualCinema()) continue;
                    ++usercardPacketCount;
                }
                int contractPacketCount = 0;
                for (Packet packet : contractPackets) {
                    if (packet.isVirtualCinema()) continue;
                    ++contractPacketCount;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("set money: day: " + day + "; usercard packet count: " + usercardPacketCount + "; contract packet count: " + contractPacketCount + "; card copies: " + String.valueOf(cardcopyCount) + "; usercard count: " + String.valueOf(usercardCount));
                }
                for (Packet packet : usercardPackets) {
                    TariffModuleTree tree;
                    int contractPacketCurrentCount = 0;
                    for (Packet p : contractPackets) {
                        if (p.isVirtualCinema() || p.getId() != packet.getId()) continue;
                        ++contractPacketCurrentCount;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("set money: packet id: " + packet.getId() + "; contract packet current count: " + contractPacketCurrentCount);
                    }
                    if ((tree = treeSet.getTree(time.getTime())) == null) {
                        if (this.errorManager == null || this.errorManager.isCapReached()) continue;
                        String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u0442\u0430\u0440\u0438\u0444\u043e\u0432!";
                        String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cardWork.contractId + "): \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043d\u0430 \u0434\u0430\u0442\u0443.\n\u0414\u0430\u0442\u0430: " + TimeUtils.formatDate((Calendar)time);
                        this.errorManager.addErrorToList(subject, text);
                        this.getLogger().error("set money: tariff not found date: " + TimeUtils.formatDate((Calendar)time) + "; contractID: " + cardWork.contractId);
                        continue;
                    }
                    request = new TariffRequest();
                    request.setRequestParam("packet", (Object)packet.getId());
                    request.setRequestParam("sid", (Object)packet.getServiceId());
                    request.setRequestParam("card_count", (Object)cardcopyCount);
                    request.setRequestParam("packet_count", (Object)usercardPacketCount);
                    request.setRequestParam("packet_list", usercardPackets);
                    request.setRequestParam("time", (Object)time);
                    request.setRequestParam("usercard_count", (Object)usercardCount);
                    request.setRequestParam("packet_count_oncontract", (Object)contractPacketCount);
                    request.setRequestParam("packet_list_oncontract", contractPackets);
                    request.setRequestParam("packet_count_current_oncontract", (Object)contractPacketCurrentCount);
                    request.setRequestParam("tariffOptions", (Object)tariffOption);
                    tree.processRequest(request);
                    Float cost = (Float)request.getResponseParam("cost");
                    Integer type = (Integer)request.getResponseParam("type");
                    Float discountPacket = (Float)request.getResponseParam("discount");
                    Set ignoreDiscountPackets = (Set)request.getResponseParam("packets_ignore_discount");
                    Float discountCard = (Float)request.getResponseParam("discount_card");
                    Float discountUsercard = (Float)request.getResponseParam("discount_usercard");
                    if (!request.wasAccepted() || cost == null || type == null || type <= 0) {
                        if (this.errorManager == null || this.errorManager.isCapReached()) continue;
                        String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d!";
                        String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + cardWork.contractId + "):  \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d. \n" + request.toString();
                        this.errorManager.addErrorToList(subject, text);
                        this.getLogger().error("set money: wrong tariff response (cid=" + cardWork.contractId + "): " + request.toString());
                        continue;
                    }
                    BigDecimal dayCost = BigDecimal.ZERO;
                    dayCost = type == 1 ? new BigDecimal(cost.floatValue()) : new BigDecimal(cost.floatValue()).divide(new BigDecimal(daysInMonth), 5, RoundingMode.UP);
                    if (!(packet.isVirtualCinema() || discountPacket == null || !(discountPacket.floatValue() > 0.0f) || ignoreDiscountPackets != null && ignoreDiscountPackets.contains(packet.getId()))) {
                        dayCost = dayCost.multiply(BigDecimal.ONE.subtract(new BigDecimal(discountPacket.floatValue()).divide(new BigDecimal(100))));
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("set money: after discount(packet) cost = " + dayCost);
                        }
                    }
                    if (discountCard != null) {
                        dayCost = dayCost.multiply(BigDecimal.ONE.subtract(new BigDecimal(discountCard.floatValue()).divide(new BigDecimal(100))));
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("set money: after discount(card copy count) cost = " + dayCost);
                        }
                    }
                    if (discountUsercard != null) {
                        dayCost = dayCost.multiply(BigDecimal.ONE.subtract(new BigDecimal(discountUsercard.floatValue()).divide(new BigDecimal(100))));
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("set money: after discount(usercard count) cost = " + dayCost);
                        }
                    }
                    dayCost = dayCost.multiply(new BigDecimal(cardcopyCount));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("set money: day cost: " + dayCost);
                    }
                    CostSum costSum = new CostSum(cardWork.contractId, packet.getServiceId(), dayCost);
                    costCache.addAmount(costSum);
                    CostPacket costPacket = new CostPacket();
                    costPacket.pid = packet.getId();
                    costPacket.day = day;
                    costPacket.cost = dayCost;
                    packetCache.addAmount(costPacket);
                }
            }
        }
        if (!preCalc && Utils.isBlankString((String)this.cids)) {
            this.insertDetail(con, packetCache);
        }
        uccm.close();
    }

    private static List<Packet> getContractPackets(List<CardWork> cardWorkList, int day, int contractId) {
        ArrayList<Packet> contractPackets = new ArrayList<Packet>();
        for (CardWork cardWork : cardWorkList) {
            List<Packet> oncardday;
            if (cardWork.contractId != contractId || (oncardday = cardWork.daysWork.get(day)) == null) continue;
            contractPackets.addAll(oncardday);
        }
        return contractPackets;
    }

    private ContractTariffOptionList getContractTariffOptionList(Connection con, int contractId) throws SQLException, BGException {
        ContractTariffOptionList tariffOption = this.tarifOptions.get(contractId);
        if (tariffOption == null) {
            try (ContractTariffOptionDao ctod = new ContractTariffOptionDao(con);){
                tariffOption = ctod.getContractRealtimeTariffOptionList(contractId, this.startMonth.getTime());
                this.tarifOptions.put(contractId, tariffOption);
            }
        }
        return tariffOption;
    }

    private void initContractTrees(Connection con, List<CardPacket> cardPacketList) {
        long startInit = System.currentTimeMillis();
        ContractManager cm = new ContractManager(con);
        for (CardPacket cardPacket : cardPacketList) {
            Integer cid = cardPacket.getContractId();
            if (this.contractTreeSets.containsKey(cid)) continue;
            this.contractTreeSets.put(cid, cm.getRealtimeTariffTreeSet(cid.intValue(), this.startMonth.getTime(), "cerbercrypt", this.moduleId, true));
        }
        this.getLogger().info("Trees prepare time => " + (System.currentTimeMillis() - startInit) + " ms");
        cm.close();
    }

    private void insertDetail(Connection con, PacketCostCache packetCache) throws SQLException {
        this.getLogger().info("Insert detail...");
        String tableName = ServerUtils.getModuleMonthTableName((String)"packet_detail", (Date)this.startMonth.getTime(), (int)this.moduleId);
        String query = "CREATE TABLE " + tableName + " ( id INT auto_increment PRIMARY KEY, pid INT NOT NULL, day SMALLINT NOT NULL, summa decimal(10,2) NOT NULL, KEY client_packet (pid,day))";
        ServerUtils.checkAndCreatePeriodicTableName((Connection)con, (String)tableName, (String)query);
        PreparedStatement delDetailPs = con.prepareStatement("DELETE FROM " + tableName + " WHERE day=? AND pid=? ");
        PreparedStatement insDetailPs = con.prepareStatement("INSERT INTO " + tableName + " ( day, pid, summa) VALUES ( ?, ?, ? ) ");
        CostPacket costPacket = null;
        Iterator<CostPacket> it = packetCache.getAmounts();
        while (it.hasNext()) {
            costPacket = it.next();
            delDetailPs.setInt(1, costPacket.day);
            delDetailPs.setInt(2, costPacket.pid);
            delDetailPs.executeUpdate();
            insDetailPs.setInt(1, costPacket.day);
            insDetailPs.setInt(2, costPacket.pid);
            insDetailPs.setBigDecimal(3, costPacket.cost);
            insDetailPs.executeUpdate();
        }
        delDetailPs.close();
        insDetailPs.close();
    }
}

