/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.action;

import bitel.billing.common.ModelItem;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrAddress;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrHouse;
import ru.bitel.bgbilling.plugins.cladr.common.model.CladrStreet;
import ru.bitel.bgbilling.plugins.cladr.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.cladr.server.dao.AddressDBFDAO;
import ru.bitel.bgbilling.plugins.cladr.server.dao.CladrStreetDAO;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ActionLoadCladr
extends ActionBase {
    String command = null;
    String code = null;
    CladrStreetDAO streetDAO = null;
    AddressDBFDAO addressDBF = null;
    CladrStreet street = null;
    Element status = null;
    boolean region = false;
    boolean area = false;
    boolean ignoreSocr = true;
    int direct = 0;
    int cityId = -1;

    public void doAction() throws Exception {
        this.command = this.getParameter("command");
        this.code = this.getParameter("city_code");
        this.region = this.getBooleanParameter("region");
        this.area = this.getBooleanParameter("area");
        this.ignoreSocr = this.getBooleanParameter("ignoreSocr");
        this.direct = this.getIntParameter("direct", 1);
        this.cityId = this.getIntParameter("city_id", -1);
        this.streetDAO = new CladrStreetDAO(this.con, log);
        this.addressDBF = new AddressDBFDAO(this.con, log);
        this.street = new CladrStreet();
        this.loadModelItem((ModelItem)this.street);
        this.status = this.createElement(this.rootNode, "status");
        if ("start".equals(this.command)) {
            this.startLoad();
        } else {
            this.street();
        }
    }

    protected void loadModelItem(ModelItem item) {
        for (String name : item.getAllKey()) {
            item.setValue(name, this.getParameter(name));
        }
    }

    private void startLoad() throws Exception {
        CladrAddress city = this.addressDBF.getAddressByCode(this.code);
        CladrAddress regionAddress = null;
        CladrAddress areaAddress = null;
        if (this.region) {
            regionAddress = this.addressDBF.getAddressLevelByCode(this.code, 1);
        }
        if (this.area) {
            areaAddress = this.addressDBF.getAddressLevelByCode(this.code, 2);
        }
        this.streetDAO.addCity(regionAddress, areaAddress, city, this.direct, this.cityId);
        List<CladrStreet> list = this.streetDAO.getStreetNotFromCladr(city, this.cityId);
        this.streetDAO.addStreetForCladrCompare(list);
        this.nextStreet();
    }

    private void street() throws Exception {
        if ("commit".equals(this.command)) {
            this.commitStreet();
        }
        if ("del".equals(this.command)) {
            this.delStreet();
        }
        if ("ignore".equals(this.command)) {
            this.ignoreStreet();
        }
    }

    private void commitStreet() throws Exception {
        this.street.setCityId(this.cityId);
        this.streetDAO.addStreet(this.street, this.ignoreSocr);
        AddressUtils.onUpdateAddressStreet((Setup)this.setup, (int)this.street.getId());
        this.ignoreStreet();
    }

    private void delStreet() throws Exception {
        this.streetDAO.delStreet(this.street);
        this.ignoreStreet();
    }

    private void ignoreStreet() throws Exception {
        this.streetDAO.delStreetFromCladrCompare(this.street);
        this.nextStreet();
    }

    private void nextStreet() throws Exception {
        this.street = this.streetDAO.getNextStreet();
        if (this.street != null) {
            this.street.saveToXML(this.rootNode);
            String[] words = this.street.getTitle().split(" ");
            List<CladrAddress> list = this.addressDBF.getStreetByTitleWord(this.code, words);
            this.buildList(this.rootNode, list);
        } else {
            List<CladrAddress> address = this.addressDBF.getStreetByCode(this.code);
            List<Integer> list = this.streetDAO.addStreeFromCladr(address, this.ignoreSocr, this.cityId);
            for (Integer streetId : list) {
                AddressUtils.onUpdateAddressStreet((Setup)this.setup, (int)streetId);
            }
            List<CladrHouse> houses = this.addressDBF.getHouseByCode(this.code);
            this.streetDAO.addHouseForCladr(houses);
            this.status.setAttribute("end", "1");
        }
    }
}

