/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ActionRegisterProblemTable
extends ActionBase {
    public void doAction() throws BGException {
        this.rootNode.setAttribute("xslt", "crm_register_problems.xsl");
        this.rootNode.setAttribute("userName", UserMap.getUser((Integer)this.userId).getName());
        int id = this.getIntParameter("id", -1);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        RegisterProblemManager manager = new RegisterProblemManager(this.con);
        Map<Integer, RegisterGroup> groupMap = new RegisterGroupManager(this.con).getGroupMap();
        SearchResult searchResult = new SearchResult();
        if (id > 0) {
            Page page = new Page();
            page.setPageIndex(1);
            page.setPageSize(1);
            page.setRecordCount(1);
            searchResult.setPage(page);
            searchResult.getList().add(manager.getProblemByID(id));
        } else {
            String status = this.getParameter("status", "");
            searchResult.setAttribute("status", status);
            searchResult.setAttribute("group", this.getParameter("group", ""));
            searchResult.setAttribute("executor", this.getParameter("executor", ""));
            searchResult.setAttribute("code", this.getParameter("code", ""));
            searchResult.setAttribute("comment", this.getParameter("comment", ""));
            searchResult.setAttribute("open_date_mode", String.valueOf(this.getIntParameter("open_date_mode", 0)));
            searchResult.setAttribute("status_date_mode", String.valueOf(this.getIntParameter("status_date_mode", 0)));
            searchResult.setAttribute("close_date_mode", String.valueOf(this.getIntParameter("close_date_mode", 0)));
            searchResult.setAttribute("sort1", this.getParameter("sort1", ""));
            searchResult.setAttribute("sort2", this.getParameter("sort2", ""));
            Page page = null;
            if ("html".equals(this.getParameter("contentType"))) {
                page = new Page();
                page.setPageIndex(0);
                page.setPageSize(0);
            } else {
                page = this.getPage();
            }
            searchResult.setPage(page);
            Period[] periods = new Period[]{new Period(this.getDateParameter("open_date1"), this.getDateParameter("open_date2")), new Period(this.getDateParameter("status_date1"), this.getDateParameter("status_date2")), new Period(this.getDateParameter("close_date1"), this.getDateParameter("close_date2"))};
            manager.searchList((SearchResult<RegisterProblem>)searchResult, periods);
        }
        String statusList = this.plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        for (RegisterProblem ri : searchResult.getList()) {
            String duration = null;
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(ri.getId()));
            row.setAttribute("comment", ri.getComment());
            this.stringToLines(row, ri.getComment(), "comment_line");
            RegisterGroup group = groupMap.get(ri.getGroupId());
            if (group != null) {
                row.setAttribute("group", group.getTitle());
            }
            row.setAttribute("status", statusMap.get(ri.getStatus()));
            row.setAttribute("urgency", this.getUrgencyColor(ri.getUrgency()) + ";" + String.valueOf(ri.getUrgency()));
            row.setAttribute("resolution", ri.getResolution());
            row.setAttribute("status_code", String.valueOf(ri.getStatus()));
            row.setAttribute("status_user", UserMap.getUser((Integer)ri.getStatusUserId()).getName());
            row.setAttribute("status_time", TimeUtils.format((Date)ri.getStatusTime(), (String)"dd.MM.yy HH:mm"));
            duration = ri.getCloseUserId() >= 0 ? this.formatDelta(ri.getOpenTime(), ri.getCloseTime()) : this.formatDelta(ri.getStatusTime(), new Date());
            row.setAttribute("duration", duration);
            row.setAttribute("history", "loopa.gif");
            if (ri.getCalls() == null) continue;
            StringBuffer calls = new StringBuffer("");
            StringBuilder contracts = new StringBuilder("");
            for (RegisterCall call : ri.getCalls()) {
                if (call.getContractId() <= 0) continue;
                if (calls.length() != 0) {
                    calls.append(";");
                }
                calls.append(call.getContractId());
                calls.append(":");
                calls.append(call.getContractTitle());
                calls.append(":");
                calls.append(call.getId());
                if (contracts.length() > 0) {
                    contracts.append(", ");
                }
                contracts.append(call.getContractTitle());
            }
            row.setAttribute("calls", calls.toString());
            row.setAttribute("contracts", contracts.toString());
        }
        this.setPageAttribute(table, searchResult.getPage());
    }

    private String getUrgencyColor(int urgency) {
        String[] colors = new String[]{"ffffff", "00ff00", "ffff00", "ffC800", "ff0000"};
        int result = 0;
        if (urgency <= 2 && urgency >= -2) {
            result = Integer.parseInt(colors[urgency + 2], 16);
        }
        return String.valueOf(result);
    }

    private String formatDelta(Date date1, Date date2) {
        long delta;
        String result = "";
        if (date1 != null && date2 != null && (delta = (date2.getTime() - date1.getTime()) / 1000L) > 0L) {
            result = TimeUtils.formatDeltaTime((long)delta);
        }
        return result;
    }

    protected void stringToLines(Element node, String str, String nodeName) {
        if (Utils.isEmptyString((String)str)) {
            return;
        }
        String[] lines = str.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            Element row = this.createElement(node, nodeName);
            row.setAttribute("text", lines[i]);
        }
    }
}

