/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.dialup.wifi;

import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiAgent;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class DialupWiFiAgent
extends WiFiAgent {
    protected String getModuleName() {
        return Utils.swapWords((String)"idlapuw.fii");
    }

    public double getBalance(String login) throws BGException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("module", "dialup");
        request.put("action", "WiFiGetBalanceInfo");
        request.put("userLogin", login);
        request.put("mid", String.valueOf(cfg.getModuleId()));
        Document doc = WiFiUtil.getDocument(request, (String)(cfg.isUseHttps() ? cfg.getServerHttpsUrl() : cfg.getServerHttpUrl()), (String)cfg.getServerLogin(), (String)cfg.getServerPasswd());
        if (WiFiUtil.checkStatus((Document)doc) == null) {
            String balStr = XMLUtils.selectText((Node)doc, (String)"/data/balance/@value", (String)"");
            return Utils.parseDouble((String)balStr, (double)0.0);
        }
        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430...");
    }

    public String sendPasswords(String email) throws BGException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        String serverLogin = cfg.getServerLogin();
        String serverPasswd = cfg.getServerPasswd();
        String serverHttpUrl = cfg.getServerHttpUrl();
        String serverHttpsUrl = cfg.getServerHttpsUrl();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("module", "dialup");
        request.put("action", "WiFiGetPassword");
        request.put("wifi.email", email);
        request.put("mid", String.valueOf(cfg.getModuleId()));
        return WiFiUtil.checkStatus((Document)WiFiUtil.getDocument(request, (String)(cfg.isUseHttps() ? serverHttpsUrl : serverHttpUrl), (String)serverLogin, (String)serverPasswd));
    }
}

