/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tasks;

import bitel.billing.server.contract.bean.ServiceCostCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatus;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatusBase;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffContext;
import ru.bitel.bgbilling.modules.drwebn.server.tasks.CalculatorUtils;
import ru.bitel.common.TimeUtils;

public class Calculator
extends TaskBase {
    private String cids;
    private PeriodicErrorManager errorManager;
    private boolean monthMode = false;
    private Calendar startMonth;
    private DrwebAgentDAO manager;
    Iterator<DrwebAgentStatus> statusIterator = null;
    DrwebAgentStatus status = null;
    DrwebAgentStatus nextStatus = null;

    protected boolean initTask() {
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        this.startMonth.set(5, 1);
        this.startMonth.set(11, 0);
        return true;
    }

    public void setMonthMode(boolean monthMode) {
        this.monthMode = monthMode;
    }

    public void setCids(String codes) {
        this.cids = codes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            this.manager = new DrwebAgentDAO(con, this.moduleId);
            this.errorManager = new PeriodicErrorManager(con);
            this.errorManager.initErrorMessage(this.moduleId, "drwebn", String.valueOf(this.moduleId), this.getOperatingTime().getTime());
            if (this.monthMode) {
                this.executeMonth(con);
            } else {
                this.execute(con);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
            this.errorManager.processErrors();
        }
    }

    protected void executeMonth(Connection con) throws BGException, SQLException {
        Calendar endMonth = TimeUtils.getEndMonth((Calendar)this.startMonth);
        this.getLogger().debug("Operation date: " + this.getOperatingTime().getTime());
        this.getLogger().debug("Calc period: " + TimeUtils.formatPeriod((Calendar)this.startMonth, (Calendar)endMonth));
        DrWebNTariffContext context = new DrWebNTariffContext(this.moduleId, this.startMonth, this.getOperatingTime());
        ServiceCostCache costCache = new ServiceCostCache();
        CalculatorUtils calcUtils = new CalculatorUtils(con, this.moduleId, this.startMonth, context, costCache);
        for (DrwebAgent agent : this.manager.getAgentListAll()) {
            ArrayList<DrwebAgentStatus> statusList = new ArrayList<DrwebAgentStatus>();
            List<DrwebAgentStatus> statusListAll = this.manager.getStatusList(agent.getId());
            if (statusListAll.isEmpty()) {
                String msg = "\u041d\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0443 \u0430\u0433\u0435\u043d\u0442\u0430 id=>" + agent.getId();
                this.getLogger().error(msg);
                this.errorManager.addErrorToList("\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", msg);
            }
            Collections.reverse(statusListAll);
            for (DrwebAgentStatus status : statusListAll) {
                if (TimeUtils.dateBefore((Date)status.getStatusDate(), (Date)this.startMonth.getTime())) {
                    statusList.add(status);
                    break;
                }
                statusList.add(status);
            }
            Collections.reverse(statusList);
            this.statusIterator = statusList.iterator();
            this.status = this.statusIterator.next();
            this.nextStatus = null;
            if (!this.statusIterator.hasNext()) {
                if (this.status.getStatus() != 1) {
                    this.getLogger().debug("Agent id=>" + agent.getId() + " is not OK status");
                    continue;
                }
            } else {
                this.nextStatus = this.statusIterator.next();
            }
            Calendar day = (Calendar)this.startMonth.clone();
            for (int i = 0; i < this.getOperatingTime().get(5); ++i) {
                if (this.nextStatus == null || !CalculatorUtils.isCurrentDayStatus(this.nextStatus, day)) {
                    calcUtils.processStatus(agent, (DrwebAgentStatusBase)this.status, day.getTime());
                    day = TimeUtils.getNextDay((Calendar)day);
                    continue;
                }
                if (!CalculatorUtils.isStartDayStatus(this.nextStatus)) {
                    calcUtils.processStatus(agent, (DrwebAgentStatusBase)this.status, day.getTime());
                }
                if (this.getNextStatus()) {
                    calcUtils.processStatus(agent, (DrwebAgentStatusBase)this.status, day.getTime());
                }
                while (CalculatorUtils.isCurrentDayStatus(this.nextStatus, day)) {
                    if (!this.getNextStatus()) continue;
                    calcUtils.processStatus(agent, (DrwebAgentStatusBase)this.status, day.getTime());
                }
                day = TimeUtils.getNextDay((Calendar)day);
            }
        }
        String moduleServices = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
        BalanceUtils bu = new BalanceUtils(con);
        bu.setAccount(con, this.getLogger(), this.startMonth, costCache, moduleServices, this.cids, null);
        bu.close();
    }

    private boolean getNextStatus() {
        boolean result = true;
        if (this.nextStatus == null) {
            return result;
        }
        result = this.status.getTariffId() != this.nextStatus.getTariffId() || this.status.getStatus() != this.nextStatus.getStatus();
        this.status = this.nextStatus;
        this.nextStatus = this.statusIterator.hasNext() ? this.statusIterator.next() : null;
        return result;
    }

    protected void execute(Connection con) throws BGException, SQLException {
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c DrWeb. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + (this.monthMode ? ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " : ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: ") + TimeUtils.format((Calendar)this.getOperatingTime(), (String)"yyyy.MM");
    }
}

