/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.gazprombank.common.service.GazprombankService;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankAutopaymentEvent;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.gazprombank.common.service.GazprombankService")
public class GazprombankServiceImpl
extends AbstractService
implements GazprombankService {
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws BGException {
        SearchResult transactionSearchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage(), searchParam.getSort());
        this.manager.searchTransaction(transactionSearchResult, searchParam);
        return transactionSearchResult;
    }

    public void checkTransactions(int contractId) throws BGException {
        this.manager.doCheckRequest(contractId, null);
    }

    public List<String[]> getAutopaymentBindingData(int contractId) throws BGException {
        return null;
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        autopaymentManager.close();
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (contractId > 0) {
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
            autopaymentManager.close();
            if (autopayment != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
                try {
                    EventProcessor.getInstance().publish((Event)new GazprombankAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
                }
                catch (BGException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
        autopaymentManager.close();
        return autopayment;
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws Exception {
    }
}

