/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.SerializeContract;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class PluginServerListener
extends WebMenuBase
implements OnInitServer,
OnDestroyServer,
SerializeContract,
EventListener<Event> {
    private static final Logger log = LogManager.getLogger();
    private XMPPConnection xmppConnection = null;

    public void notify(Event event, EventListenerContext ctx) throws BGException {
        ContractCreateEvent crEvent;
        ContractDeleteEvent cdEvent;
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        if (event instanceof ContractDeleteEvent && !(cdEvent = (ContractDeleteEvent)event).isCheck()) {
            int contractId = cdEvent.getContractId();
            Connection con = ctx.getConnection();
            try {
                PreparedStatement ps = con.prepareStatement("DELETE FROM helpdesk_param_" + plugin.getPluginUID() + " WHERE cid=?");
                ps.setInt(1, contractId);
                ps.executeUpdate();
                ps.close();
                ps = con.prepareStatement("DELETE FROM helpdesk_package_contract_" + plugin.getPluginUID() + " WHERE cid=?");
                ps.setInt(1, contractId);
                ps.executeUpdate();
                ps.close();
                ps = con.prepareStatement("DELETE FROM helpdesk_message_" + plugin.getPluginUID() + " WHERE topic_id IN( SELECT id FROM helpdesk_topic_" + plugin.getPluginUID() + " WHERE cid=? )");
                ps.setInt(1, contractId);
                ps.executeUpdate();
                ps.close();
                ps = con.prepareStatement("DELETE FROM helpdesk_topic_" + plugin.getPluginUID() + " WHERE cid=?");
                ps.setInt(1, contractId);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
        if (event instanceof ContractCreateEvent && !(crEvent = (ContractCreateEvent)event).isCheck()) {
            Document doc = crEvent.getPattern().getData();
            Element helpDesk = XMLUtils.selectElement((Node)doc, (String)"//helpDesk");
            Connection con = ctx.getConnection();
            int contractId = crEvent.getContractId();
            if (helpDesk != null) {
                int groupId;
                String mode = helpDesk.getAttribute("mode");
                if (!mode.equals("")) {
                    ParamManager paramManager = new ParamManager(con, plugin);
                    Properties properties = paramManager.getProperties(contractId);
                    properties.setProperty("mode.id", mode);
                    paramManager.setProperties(contractId, properties);
                }
                if ((groupId = Utils.parseInt((String)helpDesk.getAttribute("selectGroupId"), (int)-1)) != -1) {
                    new HelpDeskDirectoryManager(con, plugin).updateContractGroup(contractId, groupId);
                }
            }
        }
    }

    public void onInitServer(String applicationName) {
        try (Connection con = Setup.getSetup().getDBConnection();){
            new HelpdeskFileStorage(con);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        try {
            Setup setup = Setup.getSetup();
            String host = setup.get("jabber.host", null);
            String login = setup.get("jabber.login", null);
            String password = setup.get("jabber.password", null);
            if (host != null && login != null && password != null) {
                ConnectionConfiguration conf = new ConnectionConfiguration(host);
                conf.setReconnectionAllowed(true);
                XMPPConnection connection = new XMPPConnection(conf);
                connection.connect();
                connection.login(login, password);
                this.xmppConnection = connection;
                setup.putObject("helpdesk.xmppconnection", (Object)connection);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
            String telegramApiUrl = plugin.getSetup().get("telegram.api.url", "https://api.telegram.org/");
            String telegramBotToken = plugin.getSetup().get("telegram.bot.token", null);
            String telegramWebhookUrl = plugin.getSetup().get("telegram.webhook.url", null);
            if (Utils.notBlankString((String)telegramBotToken) && Utils.notBlankString((String)telegramWebhookUrl)) {
                String registrWebhookCommand = telegramApiUrl + "bot" + telegramBotToken + "/setWebhook?url=" + URLEncoder.encode(telegramWebhookUrl, "UTF-8");
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(registrWebhookCommand)).build();
                log.info("telegram.setWebhook = " + httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body());
            } else if (log.isDebugEnabled()) {
                log.debug("telegramBotToken = " + telegramBotToken);
                log.debug("telegramWebhookUrl = " + telegramWebhookUrl);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().addListener((EventListener)this, ContractDeleteEvent.class, 0, null);
            EventProcessor.getInstance().addListener((EventListener)this, ContractCreateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, PaymentEvent.class);
        }
        catch (BGException e) {
            log.error("error add event listener", (Throwable)e);
        }
    }

    public void onDestroyServer(String applicationName) {
        try {
            if (this.xmppConnection != null) {
                this.xmppConnection.disconnect();
            }
        }
        catch (Exception e) {
            log.error("error xmpp disconnect", (Throwable)e);
        }
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().removeListener((EventListener)this);
        }
        catch (BGException e) {
            log.error("error remove event listener", (Throwable)e);
        }
    }

    public void serializeContract(Connection con, int cid, XMLStreamWriter writer, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String pluginUID = "" + BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk").getPluginUID();
        String cidStr = String.valueOf(cid);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)("helpdesk_param_" + pluginUID), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)("helpdesk_package_contract_" + pluginUID), (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        String topicTable = "helpdesk_topic_" + pluginUID;
        String joinMessage = " LEFT JOIN " + topicTable + " as topic ON helpdesk_message_" + pluginUID + ".topic_id=topic.id";
        String joinTopic = null;
        if (onlyCurrent) {
            joinMessage = joinMessage + " AND ( topic.date_close is null OR topic.date_close>= CURDATE() )";
            joinTopic = " RIGHT JOIN " + topicTable + " as topic ON " + topicTable + ".id=topic.id AND ( topic.date_close is null OR topic.date_close >= CURDATE() )";
        }
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)("helpdesk_message_" + pluginUID), (String)"topic.cid", (String)cidStr, null, (boolean)false, null, null, (String)joinMessage);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)topicTable, (String)(topicTable + ".cid"), (String)cidStr, null, (boolean)false, null, null, (String)joinTopic);
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws BGException {
        HashSet<Integer> disableIds = new HashSet<Integer>();
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        Properties prop = new ParamManager(con, plugin).getProperties(contractId);
        if ("off".equals(prop.getProperty("mode.id", plugin.getSetup().get("mode.default.id", "on")))) {
            disableIds.add(1);
        }
        return this.disableContractWebMenuItems(this.getWebMenuItems(con, module, moduleId), disableIds);
    }
}

