/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.notification;

import bitel.billing.server.contract.bean.ContractModuleManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotSender;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class TelegramNotification {
    private static Logger log = LogManager.getLogger();
    private static final ContentType TEXT_PLAIN_CONTENT_TYPE = ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8);
    public static final String KEY_TELEGRAM_USER_ID = "telegram.user.id";
    public static final String KEY_TELEGRAM_USER_NAME = "telegram.user.name";

    public static void sendMessage(Topic topic, Message message, SendMessage sendMessage) {
        for (User user : UserMap.getMap().values()) {
            String telegramUserId = user.getConfigSetup().get(KEY_TELEGRAM_USER_ID, null);
            log.debug("ALL: user.id = {}; telegramUserId = {}", (Object)user.getId(), (Object)telegramUserId);
            if (telegramUserId == null) continue;
            TelegramNotification.sendMessage(telegramUserId, user.getId(), topic, message, sendMessage);
        }
    }

    public static void sendMessage(String telegramUserId, int userId, Topic topic, Message message, SendMessage sendMessage) {
        if (Utils.notBlankString((String)telegramUserId)) {
            TelegramNotification.sendTelegramNotificationByTelegramUserId(telegramUserId, userId, topic, message, sendMessage);
        } else if (TelegramNotification.checkBotManagerModuleOnContract(TelegramNotification.checkBotManagerInstalled(), topic.getContractId())) {
            try {
                String messageText = "\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0432\u0430\u0448\u0435 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u0432 \u0442\u0435\u043c\u0435 #" + topic.getId() + "\n\n" + message.getBody();
                new BotSender().send(BotSender.BotMessage.createMessage().setContract(topic.getContractId()).setText(messageText));
            }
            catch (BGException e) {
                log.error((Object)e);
            }
        }
    }

    private static void sendTelegramNotificationByTelegramUserId(String telegramUserId, int userId, Topic topic, Message message, SendMessage sendMessage) {
        log.debug("sendMessage: telegramUserId = {}", (Object)telegramUserId);
        try (Connection con = Setup.getSetup().getDBConnection();){
            String chatId = ServerUtils.getSetupValue((Connection)con, (String)("telegram." + telegramUserId + ".chat.id"), (String)telegramUserId);
            log.debug("sendMessage: chatId = {}", (Object)chatId);
            if (chatId != null) {
                BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
                String telegramApiUrl = plugin.getSetup().get("telegram.api.url", "https://api.telegram.org/");
                String telegramBotToken = plugin.getSetup().get("telegram.bot.token", null);
                if (telegramBotToken != null) {
                    sendMessage.setChatId(chatId);
                    if (topic.getUserId() > 0) {
                        sendMessage.setReplyMarkup(null);
                    } else if (message.getUserIdFrom() == 0) {
                        sendMessage.setReplyMarkup((ReplyKeyboard)TelegramNotification.getTopicUserButton(topic.getId(), userId));
                    }
                    if (Utils.notEmptyCollection((Collection)new HelpdeskFileStorage(con).getFilesListByOwner(message.getId()))) {
                        TelegramNotification.addDownloadAttachmentsButton(sendMessage);
                    }
                    String responseData = new ObjectMapper().writeValueAsString((Object)sendMessage);
                    try {
                        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
                        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(telegramApiUrl + "bot" + telegramBotToken + "/sendMessage")).setHeader("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(responseData)).build();
                        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                        log.debug("sendMessage reply: {}", (Object)response.body());
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                } else {
                    log.error("Set in plugin config: telegram.bot.token=");
                }
            } else {
                log.warn("chatId not set for telegram.user.id = " + telegramUserId);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private static int checkBotManagerInstalled() {
        return ModuleCache.getInstance().getModulesList().stream().filter(installedModule -> "botmanager".equals(installedModule.getName())).findFirst().map(Id::getId).orElse(-1);
    }

    private static boolean checkBotManagerModuleOnContract(int moduleId, int contractId) {
        if (moduleId <= 0 || contractId <= 0) {
            return false;
        }
        try {
            ServerContext serverContext = (ServerContext)ServerContext.get();
            Set modulesOnContract = new ContractModuleManager(serverContext.getConnection()).getContractModuleSet(contractId);
            return modulesOnContract.contains(moduleId);
        }
        catch (BGException e) {
            log.error((Object)e);
            return false;
        }
    }

    private static void addDownloadAttachmentsButton(SendMessage sendMessage) {
        InlineKeyboardButton button = new InlineKeyboardButton("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f");
        button.setCallbackData("download_attachments");
        InlineKeyboardMarkup replyKeyboard = (InlineKeyboardMarkup)sendMessage.getReplyMarkup();
        if (replyKeyboard == null) {
            List<InlineKeyboardButton> buttons = Collections.singletonList(button);
            ArrayList<List<InlineKeyboardButton>> keyboard = new ArrayList<List<InlineKeyboardButton>>();
            keyboard.add(buttons);
            sendMessage.setReplyMarkup((ReplyKeyboard)new InlineKeyboardMarkup(keyboard));
        } else {
            replyKeyboard.getKeyboard().add(Collections.singletonList(button));
        }
    }

    public static synchronized void sendAttachmentFiles(String chatId, String telegramBotToken, String telegramApiUrl, FileStorage fileStorage, List<BGServerFile> filesOfMessage) throws IOException {
        for (BGServerFile attachmentFile : filesOfMessage) {
            File file = new File(fileStorage.getFileName(attachmentFile.getId()));
            if (!file.exists()) continue;
            InputFile inputFile = new InputFile(file, attachmentFile.getTitle());
            HttpEntity multipart = MultipartEntityBuilder.create().setLaxMode().setCharset(StandardCharsets.UTF_8).addTextBody("chat_id", chatId, TEXT_PLAIN_CONTENT_TYPE).addTextBody("document", inputFile.getAttachName(), TEXT_PLAIN_CONTENT_TYPE).addBinaryBody(inputFile.getMediaName(), inputFile.getNewMediaFile(), ContentType.APPLICATION_OCTET_STREAM, inputFile.getMediaName()).build();
            HttpPost httppost = new HttpPost(telegramApiUrl + "bot" + telegramBotToken + "/sendDocument");
            httppost.setEntity(multipart);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            try {
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) continue;
                    InputStream is = entity.getContent();
                    log.debug("sendDocument: reply = " + new String(is.readAllBytes(), "UTF-8"));
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            finally {
                if (httpclient == null) continue;
                httpclient.close();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static SendMessage getMessageText(Topic topic, Message message, List<BGServerFile> files, boolean owner) {
        SendMessage sendMessage = new SendMessage();
        try (Connection con = Setup.getSetup().getDBConnection();){
            SendMessage sendMessage2;
            try (ContractDao contractDao = new ContractDao(con, 0);){
                Contract contract = (Contract)contractDao.get(topic.getContractId());
                Object attachments = "";
                ArrayList<MessageEntity> entities = new ArrayList<MessageEntity>();
                StringBuilder text = new StringBuilder();
                text.append("HD#");
                TelegramNotification.addBoldEntity(topic.getId() + "-" + message.getId(), text, entities);
                text.append(" \u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440: ");
                TelegramNotification.addBoldEntity(owner ? "\u0412\u044b" : "\u043d\u0435\u0442", text, entities);
                text.append("\n\u0414\u043e\u0433\u043e\u0432\u043e\u0440: ");
                TelegramNotification.addBoldEntity(contract.getTitle(), text, entities);
                text.append(" [").append(contract.getComment()).append("]\n");
                text.append("\u0422\u0435\u043c\u0430: ");
                TelegramNotification.addBoldEntity(topic.getTitle(), text, entities);
                text.append("\n\n").append(message.getBody());
                if (Utils.notEmptyCollection(files)) {
                    attachments = "\n\n\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u044f:";
                    for (BGServerFile serverFile : files) {
                        attachments = (String)attachments + "\n" + serverFile.getTitle();
                        long size = serverFile.getSize();
                        if (size < 1024L) {
                            attachments = (String)attachments + " [" + Utils.formatLong((long)size) + " \u0411]";
                            continue;
                        }
                        if (size < 0x100000L) {
                            attachments = (String)attachments + " [" + Utils.formatLong((long)(size / 1024L)) + " \u041a\u0411]";
                            continue;
                        }
                        attachments = (String)attachments + " [" + Utils.formatLong((long)(size / 0x100000L)) + " \u041c\u0411]";
                    }
                }
                if (!entities.isEmpty()) {
                    sendMessage.setEntities(entities);
                }
                sendMessage.setText(text.toString() + (String)attachments);
                sendMessage2 = sendMessage;
            }
            return sendMessage2;
        }
        catch (Exception e) {
            log.error((Object)e);
            sendMessage.setText(e.getLocalizedMessage());
            return sendMessage;
        }
    }

    private static void addBoldEntity(String entitText, StringBuilder text, List<MessageEntity> entities) {
        entities.add(new MessageEntity("bold", Integer.valueOf(text.length()), Integer.valueOf(entitText.length())));
        text.append(entitText);
    }

    private static InlineKeyboardMarkup getTopicUserButton(int topicId, int userId) {
        InlineKeyboardButton button = new InlineKeyboardButton("\u0412\u0437\u044f\u0442\u044c \u0442\u0435\u043c\u0443");
        button.setCallbackData("HD|setTopicUserId|" + topicId + "|" + userId);
        ArrayList<InlineKeyboardButton> buttons = new ArrayList<InlineKeyboardButton>();
        buttons.add(button);
        ArrayList<ArrayList<InlineKeyboardButton>> keyboard = new ArrayList<ArrayList<InlineKeyboardButton>>();
        keyboard.add(buttons);
        return new InlineKeyboardMarkup(keyboard);
    }
}

