/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEventType;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=432000000L, deliveryMode=1)
@XmlRootElement
public class InetSaConnectionCloseEvent
extends PartitionedQueueEvent {
    private static final transient Logger logger = LogManager.getLogger();
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int inetServId;
    private final InetConnection connection;

    protected InetSaConnectionCloseEvent() {
        this.deviceId = -1;
        this.inetServId = -1;
        this.connection = null;
    }

    public InetSaConnectionCloseEvent(int moduleId, int userId, InetConnection connection) {
        this(moduleId, connection.getContractId(), userId, connection.getDeviceId(), connection.getServId(), connection);
    }

    public InetSaConnectionCloseEvent(int moduleId, int contractId, int userId, int deviceId, int inetServId, InetConnection connection) {
        super(moduleId, contractId, userId);
        this.deviceId = deviceId;
        this.inetServId = inetServId;
        this.connection = connection;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getInetServId() {
        return this.inetServId;
    }

    public InetConnection getConnection() {
        return this.connection;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; inetServId: ");
        sb.append(this.inetServId);
        sb.append("; connectionId: ");
        sb.append(this.connection.getId());
    }

    public ServiceActivatorEvent toSaEvent(Access access, ConnectionSet connectionSet, boolean manageConnections, InetConnectionManager connectionManager, Date now) throws BGException {
        InetServRuntime inetServRuntime = access.inetServRuntimeMap.get(Integer.valueOf(this.getInetServId()));
        if (inetServRuntime == null) {
            logger.error("InetServ not found with id=" + this.getInetServId());
            return null;
        }
        InetServ inetServ = inetServRuntime.getInetServ();
        if (!manageConnections) {
            logger.debug("Not manage connections");
            return null;
        }
        if (this.connection == null) {
            logger.error("Connection is null");
            return null;
        }
        short oldState = this.connection.getDeviceState();
        Set<Integer> oldOptionSet = this.connection.getDeviceOptions();
        String realm = InetUtils.getRealm((String)this.connection.getUsername());
        List childrenServs = ServiceActivatorEvent.getInetServChildren((InetServRuntimeMap)access.getInetServRuntimeMap(), (int)inetServ.getId(), (long)now.getTime());
        inetServ.setChildren(childrenServs);
        Set optionSet = access.inetServOptionSet(connectionSet, now.getTime(), inetServRuntime, realm);
        ServiceActivatorEvent result = new ServiceActivatorEvent(access, (Event)this, 0, inetServRuntime, ServiceActivatorEventType.SERVICE_MODIFY.getCode(), inetServ.getId(), ((InetServTypeRuntime)inetServRuntime.inetServTypeRef.get()).inetServType, inetServ, inetServ, oldState, InetServState.STATE_DISABLE.getCode(), oldOptionSet, optionSet, AccessCode.TOO_MANY_SESSIONS_ERROR.getCode());
        InetConnectionRuntime connectionRuntime = new InetConnectionRuntime(this.connection);
        result.setConnectionRuntime(connectionRuntime);
        return result;
    }

    protected String getPackageName() {
        return InetSaServModifyEvent.PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }
}

